#!/bin/sh
#
# CircleMUD 3.0 autorun script
# Contributions by Fred Merkel, Stuart Lamble, and Jeremy Elson
# Copyright (c) 1996 The Trustees of The Johns Hopkins University
# All Rights Reserved
# See license.doc for more information
#
#############################################################################
#
# This script can be used to run CircleMUD over and over again (i.e., have it
# automatically reboot if it crashes).  It will run the game, and copy some
# of the more useful information from the system logs to the 'log' directory
# for safe keeping.
#
# You can control the operation of this script by creating and deleting files
# in Circle's root directory, either manually or by using the 'shutdown'
# command from within the MUD.
#
# Creating a file called .fastboot makes the script wait only 5 seconds
# between reboot attempts instead of the usual 60.  If you want a quick
# reboot, use the "shutdown reboot" command from within the MUD.
#
# Creating a file called .killscript makes the script terminate (i.e., stop
# rebooting the MUD).  If you want to shut down the MUD and make it stay
# shut down, use the "shutdown die" command from within the MUD.
#
# Finally, if a file called pause exists, the script will not reboot the MUD
# again until pause is removed.  This is useful if you want to turn the MUD
# off for a couple of minutes and then bring it back up without killing the
# script.  Type "shutdown pause" from within the MUD to activate this feature.
#

# The default port to run the MUD on
set PORT=4096   

# Default flags to use
set FLAGS='-q '

#############################################################################

while ( : ) do

#
# Samedi 19Jun96 Added the following to prevent compile crashes
#
  if [ -r bin/circle.new ]; then
    mv bin/circle bin/circle.old
    mv bin/circle.new bin/circle
    chmod 775 bin/circle
  fi

#
# Added lockfile to avoid multiple autoruns
#

  if [ -f autorun.pid ]; then
    PID=`cat autorun.pid`
    if [ $PID != $$ ]; then
      STALE=`ps $PID 2> /dev/null | grep -c $PID`
      if [ $STALE = 0 ]; then
        echo Removing stale pid file.
        rm autorun.pid
      else
        echo "Duplicate autorun found.  Exiting."
        exit 1
      fi
    fi
  fi
  echo $$ > autorun.pid
  DATE=`date`
  rm -f maintenance
  echo "autorun starting game $DATE" >> syslog

  ulimit -c unlimited
  chmod 770 lib/pfiles
  if [ -r lib/pfiles/plr_index.fixed ]; then
    mv lib/pfiles/plr_index lib/pfiles/plr_index.old
    mv lib/pfiles/plr_index.fixed lib/pfiles/plr_index
  fi
  chmod 770 bin/circle
  bin/circle -q 4096 >> syslog 2>&1

  DATE=`date`
  echo "mud went down $DATE" >> syslog

  fgrep "self-delete" syslog >> log/delete
  fgrep "death trap" syslog >> log/dts
  fgrep "killed" syslog >> log/rip
  fgrep "Running" syslog >> log/restarts
  fgrep "advanced" syslog >> log/levels
  fgrep "equipment lost" syslog >> log/rentgone
  fgrep "usage" syslog >> log/usage
  fgrep "new player" syslog >> log/newplayers
  fgrep "SYSERR" syslog >> log/errors
  fgrep "(GC)" syslog >> log/godcmds
  fgrep "Bad PW" syslog >> log/badpws
  fgrep -i "OLC" syslog >> log/olc
  fgrep "HELP" syslog >> log/help 
  fgrep "SNOOP" syslog >> log/godcmds
  fgrep "BOT" syslog >> log/botabuse
  fgrep "PCLEAN" syslog >> log/pclean
  fgrep "REMORT" syslog >> log/remorts

  rm log/syslog.1
  mv log/syslog.2 log/syslog.1
  mv log/syslog.3 log/syslog.2
  mv log/syslog.4 log/syslog.3
  mv log/syslog.5 log/syslog.4
  mv log/syslog.6 log/syslog.5
  mv syslog       log/syslog.6
  touch syslog

# Whoever edited this forgot to put '; then' at the end of the line
  if [ -r lib/etc/dns.new ]; then
    mv lib/etc/dns.new lib/etc/dns
  fi

  if [ -r lib/core ]; then
    chmod 666 lib/core
    chgrp nomud lib/core
  fi

  if [ ! -r .fastboot ]; then
    sleep 3
  else
    rm .fastboot
  fi

  if [ -r .killscript ]; then
    DATE=`date`;
    echo "autoscript killed $DATE"  >> syslog
    rm .killscript
    rm autorun.pid
    exit 0
  fi

  while [ -r pause ]; do
    sleep 60
  done

done
