#include <stdio.h>

struct dns_entry {
  int ip[4];
  char *name;
  struct dns_entry *next;
};

#define DNS_HASH_NUM 257
struct dns_entry *dns_cache[DNS_HASH_NUM];

int main (int argc, char *argv[]) {
  FILE *fl;
  char line[256], name[256];
  struct dns_entry *dns, *tdns;
  int i, nume[DNS_HASH_NUM];

  fl = fopen("dns", "r");
  
  fprintf(stderr, "Loading dns entries");
  do {
    fprintf(stderr, ".");
    i = 0;
    fgets(line, 256, fl);
    if(*line != '~') {
      if (!(dns = (struct dns_entry *) malloc(sizeof(struct dns_entry)))) {
        fprintf(stderr, "Error allocating memory!\n");
        exit(1);
      }
      dns->name = NULL;
      dns->next = NULL;
      sscanf(line, "%d.%d.%d.%d %s", dns->ip, dns->ip + 1,
        dns->ip + 2, dns->ip + 3, name);
      dns->name = strdup(name);
      i = (dns->ip[0] * dns->ip[1]) % DNS_HASH_NUM;
      dns->next = dns_cache[i];
      nume[i]++;
      dns_cache[i] = dns;
    }
  } while (!feof(fl) && *line != '~');
  fclose(fl);
  
  fprintf(stderr, "done.\n\nSorting entries");

  for (i = 0; i < DNS_HASH_NUM; i++) {
    dns = dns_cache[i];
    fprintf(stderr, "\n%d(%d) ", i, nume[i]);
    while (dns) {
      fprintf(stderr, "."); 
      tdns = dns->next;
      while (tdns) {
/*        printf("%d.%d.%d.%d :: %d.%d.%d.%d\n", dns->ip[0], dns->ip[1], 
          dns->ip[2], dns->ip[3], tdns->ip[0], tdns->ip[1], tdns->ip[2], 
          tdns->ip[3]);   */
        if (dns->ip[0] == tdns->ip[0] && dns->ip[1] == tdns->ip[1] &&
            dns->ip[2] == tdns->ip[2] && dns->ip[3] == tdns->ip[3]) {
          dns->next = tdns->next;
          free(tdns);
          tdns = dns->next;
        } else {
          tdns = tdns->next;
        } /* end of if() */
      } /* end of while(tdns) */
    dns = dns->next;
    } /* end of while(dns) */
/*  getchar();  */
  } /* end of for() */

  fl = fopen("dns.new", "w");
  fprintf(stderr, "done.\n\nSaving");
  for (i = 0; i < DNS_HASH_NUM; i++) {
    dns = dns_cache[i];
    while (dns) {
      fprintf(stderr, ".");
      fprintf(fl, "%d.%d.%d.%d %s\n", dns->ip[0], dns->ip[1], dns->ip[2], 
              dns->ip[3], dns->name);
      dns = dns->next;
    } /* end of while(dns*/
  } /* end of for( */
  fprintf(fl, "~\n");
  fclose(fl);
  
} /* end of main() */
