#!/bin/sh
# Tcl/Tk Script \
exec tclsh $0 ${1+"$@"}

proc read_dns {infile} {
global entries
  set p1 {}
  set p2 {}
  set p3 {}
  set p4 {}
  set fl [open $infile r]
  catch {unset entries}
  set i 0
  while {![eof $fl]} {
    catch {unset line}
    gets $fl line
    regexp "^(\[0-9]+\\.\[0-9]+\\.\[0-9\-]+\\.)(\[0-9\-]+) *(\[^\\.\r\n]+\\.?)(\[^\r\n]*)$" $line match p1 p3 p4 p2
    set temp {}
    lappend temp $p1 $p2 $p3 $p4
    lappend entries $temp
    incr i
  }
  close $fl
}

proc rem_wild {} {
global entries
  set entries [lsort $entries]
  for {set i [expr [llength $entries] - 1]} {$i >= 0} {incr i -1} {
    puts -nonewline "+"
    flush stdout
    set l1 [lindex $entries $i]
    set l2 [lindex $entries [expr $i + 1]]
    if {[lindex $l1 0] == [lindex $l2 0] && [lindex $l1 1] == [lindex $l2 1]} {
      puts -nonewline "-"
      flush stdout
      set entries [lreplace $entries [expr $i + 1] [expr $i + 1]]
      set l1 [lreplace $l1 2 3 -1 ""]
      set entries [lreplace $entries $i $i $l1]
    } 
  }
}

proc write_dns {outfile} {
global entries
  set fl [open $outfile w]
  foreach i $entries {
    if {[lindex $i 3] == ""} {
      puts $fl "[lindex $i 0][lindex $i 2] [lindex $i 1]"
    } else {
      puts $fl "[lindex $i 0][lindex $i 2] [lindex $i 3][lindex $i 1]"
    }
  }
  close $fl
}

if {!$tcl_interactive} {
  read_dns dns
  rem_wild
  write_dns dns.new
}
