#!/usr/bin/tclsh

proc fix_pfiles {} {
  set fout [open "plr_index.ftcl" w]
  foreach FILE [lsort [glob ?/*]] {
    set nam [lindex [split $FILE /] 1]
    if [contains $nam ~,.] { continue }
    set fl [open $FILE r]
    set act [set lvl [set cls [set lst [set cln [set rce [set idn 0]]]]]]]
    set file [read $fl]
    regexp "Act : (\[A-z\]+)" $file tag act
    if [string match *k* $act] { continue }
    regexp "Clas: (\[0-9\]+)" $file tag cls
    regexp "Last: (\[0-9\]+)" $file tag lst
    regexp "Clan: (\[0-9\]+)" $file tag cln
    regexp "Race: (\[0-9\]+)" $file tag rce
    regexp "Id  : (\[0-9\]+)" $file tag idn
    puts $fout "$nam $idn $lvl $rce $cls $cln $lst"
    close $fl
  }
  close $fout
}

proc contains {str tokens} {
  set retval 0
  for {set x 0} {$x < [string length $tokens]} {incr x} {
     set cc [string index $tokens $x]
     if [string match "*${cc}*" $str] {
       set retval 1
     }
  }
  return $retval
}

fix_pfiles
