#!/usr/bin/tclsh
source flagdata.tcl

proc read_obj {filename} {
global vnum name sd ld action type extra wear minlevel minremort v0 v1 v2 v3 v4
global weight cost rent bv bv2 extraflags wearflags bvflags bv2flags affpos
global typeflags edesc aff affnum edescnum
  foreach var "vnum name sd ld action type extra wear minlevel minremort v0" {
    catch {unset $var}
  }
  foreach var "v1 v2 v3 v4 weight cost rent bv bv2" {
    catch {unset $var}
  }
  foreach var "edesc aff affnum edescnum" {
    catch {unset $var}
  }
  set fl [open $filename r]
  set index 0
  set mode vnum
  while {![eof $fl]} {
    gets $fl line
    switch $mode {
     vnum { set fc [string index $line 0]
            switch $fc {
              \#   { if {$line == "#99999"} {continue}
                     incr index
                     set enum 0
                     set affn 0
                     set edescnum($index) 0
                     set affnum($index) 0
                     set vnum($index) [string trimleft $line #]
                     set mode name
                   } 
              \$   { set mode done }
               E   { incr enum
                     set edescnum($index) $enum
                     set mode edesc }
               A   { incr affn
                     set affnum($index) $affn
                     set mode aff }
            }
          }
     done {  }
     name { set name($index)  [string trimright $line ~]
            set mode sd
            set sd($index)  ""
          }
       sd { if [strstr $line ~] {
              set line [string trimright $line ~]
              set mode ld
              set ld($index)  ""
            }  else { append line "\n" } 
            append sd($index) "$line"
          }
       ld { if [strstr $line ~] {
              set line [string trimright $line ~]
              set mode action
              set action($index)  ""
            } else { append line "\n" }
            append ld($index) "$line"
          }
            
   action { if [strstr $line ~] {
              set line [string trimright $line ~]
              set mode num1
            } else { append line "\n" } 
            append action($index) "$line"
          }
     num1 { set minlevel($index) 101
            set minremort($index) 0
            scan $line %s%s%s%s%s ttype textra twear minlevel($index) minremort($index)
            set type($index) [lindex $typeflags [expr $ttype - 1]]
            set extra($index) [parseflags $textra extraflags]
            set wear($index) [parseflags $twear wearflags]
            set mode num2
          }
     num2 { set v4($index) 0
            scan $line %s%s%s%s%s v0($index) v1($index) v2($index) v3($index) v4($index)
            set mode num3
          }
     num3 { set tbv [set tbv2 0]
            scan $line %s%s%s%s%s weight($index) cost($index) rent($index) tbv tbv2
            set bv($index) [parseflags $tbv bvflags]
            set bv2($index) [parseflags $tbv2 bv2flags]
            set mode vnum
          }
      aff { scan $line %s%s tpos tval
            set aff($index,$affn,pos) [lindex $affpos $tpos]
            if {![strstr $tval -]} { set tval "+$tval" }
            set aff($index,$affn,val) $tval
            set mode vnum
          }
    edesc { if {![info exists edesc($index,$enum,name)]} {
              set edesc($index,$enum,name) [string trimright $line ~]
              set edesc($index,$enum,desc) ""
            } else {
              if [strstr $line ~] {
                set line [string trimright $line ~]
                set mode vnum
              } else { append line "\n" } 
              append edesc($index,$enum,desc) "$line"
            }
          }
    }
  }
  close $fl
}  

proc write_obj {outfile} {
global vnum sd name ld wear bv bv2 extra weight cost rent minlevel
global minremort aff edesc type affnum edescnum
  set fl [open [string trimright $outfile .obj].txt w]
  for {set x 1} {$x <= [array size vnum]} {incr x} {
    if {$minlevel($x) >= 101} { continue }
    puts $fl "Name: '$sd($x)', Aliases: $name($x)"
    puts $fl "[format "Vnum: \[%5d\], Type: $type($x)" $vnum($x)]"
    if {$ld($x) != ""} {
      puts $fl "L-Des: $ld($x)"
    }
    if {$wear($x) != ""} {
      puts $fl "Can be worn on: $wear($x)"
    }
    if {$bv($x) != ""} {
      puts $fl "Set char bits : $bv($x)"
    }
    if {$bv2($x) != ""} {
      puts $fl "Set char bits : $bv2($x)"
    }
    if {$extra($x) != ""} {
      puts $fl "Extra flags   : $extra($x)"
    }
    set tmp [format "Weight: %d, Value: %d, Cost/day: %d, Minimum level: %d, Remorts: %d" \
            $weight($x) $cost($x) $rent($x) $minlevel($x) $minremort($x)]
    puts $fl "$tmp"
    puts $fl "[parse_vno $x]"
    set affs ""
    for {set y 1} {$y <= $affnum($x)} {incr y} {
      append affs "$aff($x,$y,val) to $aff($x,$y,pos),"
    }
    set affs [string trimright $affs ,]
    if {$affs==""} { set affs "<None>" }
    puts $fl "Affections: $affs\n"
  }
  close $fl
}

proc parseflags {flags list} {
global $list alphabet
upvar 1 $list ll
  set retval ""
  for {set x 0} {$x < [string length $flags]} {incr x} {
    set flag [string index $flags $x]
    set ind [lsearch $alphabet $flag]
    append retval " [lindex $ll $ind]"
  }
  if {$retval == " "} {
    set retval ""
  } 
  return $retval
}
 
proc strstr {haystack needle} {
  if [string match *${needle}* $haystack] {
    set retval 1
  } else {
    set retval 0
  }
  return $retval
}

proc parse_vno {num} {
global v0 v1 v2 v3 v4 type
  switch $type($num) {
      LIGHT { set retval [format "Hours left: %d:" $v2($num)] }
      SCROLL -
      POTION -
      PILL { set retval [format "Spells: (Level %d) %d, %d, %d" $v0($num) $v1($num) $v2($num) $v3($num)] }
      WAND -
      STAFF { set retval [format "Spell: %d at level %d, %d (of %d) charges remaining" $v3($num) $v0($num) $v2($num) $v1($num)] }
      WEAPON { set retval [format "Todam:%dd%d, Message type: %d" $v1($num) $v2($num) $v3($num)] }
      ARMOR { set retval [format "AC-apply: %d" $v0($num)] }
      LIV_ARMOR { set retval [format "AC Bonus: Level * %d/%d + %d  Max: %d" $v1($num) $v2($num) $v0($num) $v3($num)] }
      ECONOMIZER { set retval [format "Mana Savings:%d%%" $v0($num)] }
      TRAP { set retval [format "Spell: %d, - Hitpoints: %d" $v0($num) $v1($num)] }
      CONTAINER { set retval [format "Weight Capacity: %d, Lock type: %d, Key Num: %d, Corpse: %s" $v0($num) $v1($num) $v2($num) $v3($num)] }
      DRINKCON -
      FOUNTAIN { set retval [format "Capacity: %d, Contains %d, Poisoned: %d, Liquid: %d" $v0($num) $v1($num) $v3($num) $v2($num)] }
      NOTE { set retval [format "Tongue: %d" $v0($num)] }
      KEY { set retval "" }
      FOOD { set retval [format "Makes full: %d, Poisoned: %d" $v0($num) $v3($num)] }
      MONEY { set retval [format "Coins: %d" $v0($num)] }
      LOCKPICK { set retval [format "Quality: %d, Broken: %d" $v0($num) $v1($num)] }
      BOW { set retval [format "Range: %d, StrReq: %d, Dam Bonus: %d, Ammo: %d" $v0($num) $v1($num) $v2($num) $v3($num)] }
      GUN { set retval [format "Range: %d, Contains: %d, Capacity: %d, Type: %d" $v0($num) $v1($num) $v2($num) $v4($num)] }
      AMMO { set retval [format "Todam:%dd%d, Type: %d" $v0($num) $v1($num) $v2($num)] }
      QUIVER { set retval [format "Contains: %d, Capacity: %d, Ammo: %d" $v1($num) $v2($num) $v3($num)] }
      default { set retval [format "Values 0-4: %d %d %d %d %d" $v0($num) $v1($num) $v2($num) $v3($num) $v4($num)] }
  }
  return [concat $retval]
}

proc main {} {
  set indexfile [open "index.tcl" r]
  while {![eof $indexfile]} {
    gets $indexfile line
    set fln [lindex $line 0]
    if {$fln == "$"} { continue }
    if {$fln == ""} { continue }
    puts "Reading $fln"
    read_obj $fln
    puts "Writing $fln"
    write_obj $fln
  }
  close $indexfile
}

main
