#if !defined(_BUFFER_H_)
#define _BUFFER_H_

/*
 * #if 1 = return a pointer to the buffer structures
 * #if 0 = return only the data buffer (define this or all hell will break)
 */
#if 0
#define BUFFER_SNPRINTF	1
#endif

/*
 * #if 1 = Include original CircleMUD buffers too.
 * #if 0 = Use only new buffer system.
 */
#if 0
#define USE_CIRCLE_BUFFERS 1
#endif

/*
 * #if 1 = maintain a variable of how large a buffer the function requested.
 *      This will keep better track of buffer overruns when we give them a
 *      bigger buffer than requested.  An overrun with this on does not
 *      necessarily mean anything has been corrupted, but it does mean that
 *      it will happen and you have a serious problem. (recommended)
 * #if 0 = save sizeof(int) bytes per buffer structure and only check for
 *      overruns that corrupt memory past the buffer and do bad things.
 *
 * I'm thinking of removing this in favor of always being picky.
 */
#if 1
#define PICKY_BUFFERS   1
#endif
+/*
 * Some macros to imitate C++ class styles.  release_and_return is odd but it
 * must be that way to allow values.  release_buffer() automatically NULL's
 * pointer to prevent further use.  Do not use release_and_return unless you
* are sure you can remember to put {}'s around single line if statements,
 * otherwise use a release_my_buffers() and return pair. 
 */
#define get_buffer(a)		acquire_buffer((a), __FUNCTION__, __LINE__)
#define release_buffer(a)	do { detach_buffer((a), __FUNCTION__, __LINE__); (a) = NULL; } while (0)
#define release_my_buffers()	detach_my_buffers(__FUNCTION__, __LINE__)
#define release_and_return	release_my_buffers(); return

/*
 * Public functions for outside use.
 */
void init_buffers(void);
void release_all_buffers();
void detach_buffer(char *data, const char *func, const int line_n);
void detach_my_buffers(const char *func, const int line_n);
#if defined(BUFFER_SNPRINTF)
struct buf_data *acquire_buffer(sh_int size, const char *who, ush_int line);
#else
char *acquire_buffer(sh_int size, const char *who, ush_int line);
#endif
void show_buffers(struct char_data *ch);

#if defined(BUFFER_SNPRINTF) || defined(_BUFFER_C_)
/*
 * This is a private structure and is therefore not in buffer.h. No other
 * file must care what this structure looks like unless BUFFER_SNPRINTF
 * is defined for the new era of CircleMUD snprintfs.
 */
struct buf_data {
  bool used;            /* Is someone using this buffer?        */
  sh_int size;          /* How large is this buffer?            */
  ush_int line;         /* What source code line is using this. */
  sh_int life;          /* An idle counter to free unused ones. */
#if defined(PICKY_BUFFERS)
  sh_int req_size;      /* How much did the function request?   */
#endif
  char *data;           /* The buffer passed back to functions. */
  const char *who;      /* Name of the function using this.     */
  struct buf_data *next;        /* The next structure.          */
};
#endif

#endif

