/* ************************************************************************
*   File: config.c                                      Part of CircleMUD *
*  Usage: Configuration of various aspects of CircleMUD operation         *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */

#define __CONFIG_C__

#include "conf.h"
#include "sysdep.h"

#include "structs.h"

#define TRUE	1
#define YES	1
#define FALSE	0
#define NO	0

/*
 * Below are several constants which you can change to alter certain aspects
 * of the way CircleMUD acts.  Since this is a .c file, all you have to do
 * to change one of the constants (assuming you keep your object files around)
 * is change the constant in this file and type 'make'.  Make will recompile
 * this file and relink; you don't have to wait for the whole thing to
 * recompile as you do if you change a header file.
 *
 * I realize that it would be slightly more efficient to have lots of
 * #defines strewn about, so that, for example, the autowiz code isn't
 * compiled at all if you don't want to use autowiz.  However, the actual
 * code for the various options is quite small, as is the computational time
 * in checking the option you've selected at run-time, so I've decided the
 * convenience of having all your options in this one file outweighs the
 * efficency of doing it the other way.
 *
 */

/****************************************************************************/
/****************************************************************************/


/* GAME PLAY OPTIONS */

/*
 * pk_allowed sets the tone of the entire game.  If pk_allowed is set to
 * NO, then players will not be allowed to kill, summon, charm, or sleep
 * other players, as well as a variety of other "asshole player" protections.
 * However, if you decide you want to have an all-out knock-down drag-out
 * PK Mud, just set pk_allowed to YES - and anything goes.
 */
int pk_allowed = NO;

/* is playerthieving allowed? */
int pt_allowed = NO;

/* minimum level a player must be to shout/holler/gossip/auction */
int level_can_shout = 1;

/* number of movement points it costs to holler */
int holler_move_cost = 20;

/* exp change limits */
int max_exp_gain = 200000;	/* max gainable per kill-chgd 8/96 */
int max_exp_loss = 100000;	/* max losable per death */

/* number of tics (usually 75 seconds) before PC/NPC corpses decompose */
int max_npc_corpse_time = 5;
int max_pc_corpse_time = 10;

/* should items in death traps automatically be junked? */
int dts_are_dumps = NO;

/* "okay" etc. */
char *OK = "Okay.\r\n";
char *NOPERSON = "No one by that name here.\r\n";
char *NOEFFECT = "Nothing seems to happen.\r\n";

/****************************************************************************/
/****************************************************************************/


/* RENT/CRASHSAVE OPTIONS */

/*
 * Should the MUD allow you to 'rent' for free?  (i.e. if you just quit,
 * your objects are saved at no cost, as in Merc-type MUDs.
 */
int free_rent = YES;

/* maximum number of items players are allowed to rent */
int max_obj_save = 30;

/* maximum number of message in mailbox */
int max_mail_save = 20;

/* maximum number of items saved in a donation room */
int max_don_save = 20;

/* maximum number of items saved in a clan hall */
int max_clan_save = 15;

/* receptionist's surcharge on top of item costs */
int min_rent_cost = 100;

/*
 * Should the game automatically save people?  (i.e., save player data
 * every 4 kills (on average), and Crash-save as defined below.
 */
int auto_save = YES;

/*
 * if auto_save (above) is yes, how often (in minutes) should the MUD
 * Crash-save people's objects?   Also, this number indicates how often
 * the MUD will Crash-save players' houses.
 */
int autosave_time = 5;

/* Lifetime of crashfiles and forced-rent (idlesave) files in days */
int crash_file_timeout = 10;

/* Lifetime of normal rent files in days */
int rent_file_timeout = 30;


/****************************************************************************/
/****************************************************************************/


/* ROOM NUMBERS */

/* virtual number of room that newbies should enter at */
sh_int newbie_start_room = 4400;

/* virtual number of room that mortals should enter at */
sh_int mortal_start_room = 3001;

/* virtual number of room that immorts should enter at by default */
sh_int immort_start_room = 1204;

/* virtual number of room that frozen players should enter at */
sh_int frozen_start_room = 1202;

/*
 * virtual numbers of donation rooms.  note: you must change code in
 * do_drop of act.obj1.c if you change the number of non-NOWHERE
 * donation rooms.
 */
sh_int donation_room_1 = 3063;
sh_int donation_room_2 = NOWHERE;	/* unused - room for expansion */
sh_int donation_room_3 = NOWHERE;	/* unused - room for expansion */


/****************************************************************************/
/****************************************************************************/


/* GAME OPERATION OPTIONS */

/*
 * default port the game should run on if no port given on command-line
 * Note: If you're using the 'autorun' script, the port number there will
 * override this setting.  Change the PORT= line in autorun instead.
 */
int DFLT_PORT = 4000;

/* default directory to use as data directory */
char *DFLT_DIR = "lib";

/* maximum number of players allowed before game starts to turn people away */
int MAX_PLAYERS = 300;

/* maximum size of bug, typo and idea files (to prevent bombing) */
int max_filesize = 50000;

/* maximum number of password attempts before disconnection */
int max_bad_pws = 3;

/*************************************************************************
                             olc options
*************************************************************************/

/* maximum number of new objects allowed by oeditor */
int max_new_objects = 30; /*oeditmod*/

/* maximum number of new rooms allowed by reditor */
int max_new_rooms = 150; /*reditmod*/

/* zone file commenting option...set the following variable to FALSE
   to disable the saving of mob and object names to the zone file    */
int comment_zone_file = TRUE; /*zeditmod*/

/* maximum number of new mobs allowed by meditor */
int max_new_mobs = 30; /*meditmod*/


/*
 * Some nameservers are very slow and cause the game to lag terribly every
 * time someone logs in.  The lag is caused by the gethostbyaddr() function
 * which is responsible for resolving numeric IP addresses to alphabetic names.
 * Sometimes, nameservers can be so slow that the incredible lag caused by
 * gethostbyaddr() isn't worth the luxury of having names instead of numbers
 * for players' sitenames.
 *
 * If your nameserver is fast, set the variable below to NO.  If your
 * nameserver is slow, of it you would simply prefer to have numbers
 * instead of names for some other reason, set the variable to YES.
 *
 * You can experiment with the setting of nameserver_is_slow on-line using
 * the SLOWNS command from within the MUD.
 */

int nameserver_is_slow = NO;


char *MENU =
"\r\n"
"                        &+C==================================\r\n"
"                        &+W W e l c o m e   t o   N o M U D \r\n"
"                        &+C==================================\r\n"
"                         &+B[0] Exit from NoMUD.\r\n"
"                         &+C[1] Enter our WORLD.\r\n"
"                         &+c[2] Enter description.\r\n"
"                         &+W[3] Read our history.\r\n"
"                         &+c[4] Change password.\r\n"
"                         &+C[5] Delete this character.\r\n"
/* "                         &+B[6] Who's Online.\r\n" */
"                        &+C==================================\r\n"
"  &+W Make your choice: ";

char *GREETINGS =
"\r\n&+wW e l c o m e\r\n"
"                                    &+y|   |         |   |  |   |  ,--\\\r\n"
"       &+wt o                         &+y |\\  |         |\\ /|  |   |  |   \\\r\n"
"                     &+r ^            &+y | \\ |   ,-,   | V |  |   |  |   |\r\n"
"                     &+r/ \\            &+y|  \\|  <   >  |   |  \\   /  |   /\r\n"
"               &+r ^  &+c _|.|_   &+r^      &+y |   |   \\_/   |   |   \\_/   |__/\r\n"
"              &+c_|I|  |I .|  |.|_\r\n"
"              &+c\\II||~~| |~~||  /\r\n"
"               &+c~\\~|~~~~~~~|~/~                 &+y#####################\r\n"
"                 &+c\\|II I ..|/                      &+y|#|         |#|\r\n"
"            &+r/\\    &+c|II.    |    &+r/\\                &+y |#|         |#|\r\n"
"           &+r/  \\  &+c_|III .  |_ &+r /  \\                &+y|#|         |#|\r\n"
"           &+r /\\   &+c |II.    |    &+r/\\                 &+y|#|         |#|\r\n"
"           &+r/  \\ &+c _|III .  |_  &+r/  \\               &+y |#|         |#|\r\n"
"          &+c |-~| /(|I.I I  |)\\ |~-|                &+y|#|         |#|\r\n"
"        &+c _/(I | +-----------+ |. )\\_              &+y|#|         |#|\r\n"
"         &+c\\~-----/____-~-____\\-----~/              &+y|#|         |#|\r\n"
"          &+c|I.III|  /(===)\\  |  .. |               &+y|#|         |#|\r\n"
"          &+g/&+b~~~-----&+c_________&+b---~~~&+g\\           &+y    |#|         |#|\r\n"
"         &+g`&+b##########&+g!\\&+b-#####&+g%!!!!!| |\\         &+y#####################\r\n"
"        &+g_/&+b###########&+g!!\\&+b~~-_##&+g%!!!\\_/|\r\n"
"        &+g\\&+b##############&+g!!!!!/~~-_%!!!!\\       &+wNow NEW and IMPROVED!\r\n"
"         &+g~)&+b#################&+g!!!!!/~~--\\_\r\n"
"      &+g__ /&+b#####################&+g%%!!!!/ /  &+w Based on: CircleMUD 3.0\r\n"
"      &+g\\,~\\-_____&+b##############&+g%%%!!!!\\/        &+wby Jeremy Elson\r\n"
"      &+g/!!!!\\ \\ \\&+b~-_###########&+g%%%!!!!\\   &+wDikuMUD by Sebastion Hammer,\r\n"
"     &+g/&+b#####&+g!!!!!!!\\&+b~-_#######&+g%%%!!!!!!\\_   &+wMichael Seifert, Hans Stirfeldt,\r\n"
"    &+g/&+b#############&+g!!!\\&+b#########%%%!!!!!!\\  &+wTom Madsen, Katja Nyboe\r\n\r\n"
"&+yBy what name do you wish to be known?&+w ";

char *GREETINGS2 =
"\r\n\r\n"
"                  &+b::::    :::  ::::::::  ::::    ::::  :::    ::: :::::::::\r\n"
"                  &+b:&+B+&+b:&+B+&+b:   :&+B+&+b: :&+B+&+b:    :&+B+&+b: &+B+&+b:&+B+&+b:&+B+&+b: :&+B+&+b:&+B+&+b:&+B+ &+b:&+B+&+b:    :&+B+&+b: :&+B+&+b:   :&+B+&+b:\r\n"
"                  &+b:&+B+&+b:&+B+&+b:&+B+  +&+b:&+B+ +&+b:&+B+    +&+b:&+B+ +&+b:&+B+ +&+b:&+B+&+b:&+B+ +&+b:&+B+ +&+b:&+B+    +&+b:&+B+ +&+b:&+B+   +&+b:&+B+\r\n"
"                  &+B+&+c*&+B+ +&+b:&+B+ +&+c*&+B+ +&+c*&+B+    +&+b:&+B+ +&+c*&+B+  +&+b:&+B+  +&+c*&+B+ +&+c*&+B+    +&+b:&+B+ +&+c*&+B+   +&+b:&+B+\r\n"
"                  &+B+&+c*&+B+  +&+c*&+B+&+c*&+B+&+c* &+B+&+c*&+B+    +&+c*&+B+ +&+c*&+B+       +&+c*&+B+ +&+c*&+B+    +&+c*&+B+ +&+c*&+B+   +&+c*&+B+\r\n"
"             &+w ,,' &+c*&+B+&+c*   *&+B+&+c*&+B+&+c* *&+B+&+c*    *&+B+&+c* *&+B+&+c*       *&+B+&+c* *&+B+&+c*    *&+B+&+c* *&+B+&+c*   *&+B+&+c*\r\n"
"             &+w///  &+c***    ****  ********  ***       ***  ********  ********\r\n"
"  &+w_         //&+Y||\r\n"
" &+w(_)&+y@@@@@@@&+Y|<>|&+WZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ>\r\n"
"            &+w\\\\&+Y||                       &+L(Trisomy NoMUD)\r\n"
"             &+w\\\\\\\r\n"
"              &+w'',   &+cBased on: &+BCirclemud 3.0p10 &+cby &+BJeremy Elson\r\n"
"                              &+BDikumud Gamma &+cby &+BSebastion Hammer&+c,\r\n"
"                              &+BMichael Seifert&+c, &+BHans Sterfeldt&+c,\r\n"
"                              &+BTom Madsen&+c, and &+BKatja Nyboe\r\n\r\n"
"&+cBy what name do you wish to be known? &+B";


char *WELC_MESSG =
"\r\n"
"Welcome to NoMUD! Modifications being made daily, so please bear with us!."
"\r\n\r\n";

char *START_MESSG =
"Welcome.  This is your new NoMUD character!  You can now earn gold,\r\n"
"gain experience, find weapons and equipment, and much more -- while\r\n"
"meeting people from around the world!\r\n";

/****************************************************************************/
/****************************************************************************/


/* AUTOWIZ OPTIONS */

/* Should the game automatically create a new wizlist/immlist every time
   someone immorts, or is promoted to a higher (or lower) god level? */
int use_autowiz = NO;

/* If yes, what is the lowest level which should be on the wizlist?  (All
   immort levels below the level you specify will go on the immlist instead.) */
int min_wizlist_lev = LVL_GOD;
