/* ************************************************************************
*   File: interpreter.c                                 Part of CircleMUD *
*  Usage: parse user commands, search for specials, call ACMD functions   *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */

#define __INTERPRETER_C__

#include "conf.h"
#include "sysdep.h"


#include "structs.h"
#include "comm.h"
#include "interpreter.h"
#include "db.h"
#include "utils.h"
#include "spells.h"
#include "handler.h"
#include "mail.h"
#include "screen.h"
#include "saves.h"

int greetswitch = 1;

extern const struct title_type titles[NUM_CLASSES][LVL_SIMP + 1];
extern char *race_abbrevs[];
extern char *class_abbrevs[];
extern char *motd;
extern char *imotd;
extern char *background;
extern char *MENU;
extern char *WELC_MESSG;
extern char *START_MESSG;
extern struct char_data *character_list;
extern struct descriptor_data *descriptor_list;
extern struct player_index_element *player_table;
extern int top_of_p_table;
extern int mudrestrict;
extern struct index_data *mob_index;
extern struct index_data *obj_index;
extern struct room_data *world;
extern int newbie_zone;
extern struct wholist_entry *wholist;
extern int wholist_total;

/* external functions */
void echo_on(struct descriptor_data *d);
void echo_off(struct descriptor_data *d);
void do_start(struct char_data *ch);
void init_char(struct char_data *ch);
void roll_real_abils(struct char_data * ch);
int create_entry(char *name);
int special(struct char_data *ch, int cmd, char *arg);
int isbanned(char *hostname);
int Valid_Name(char *newname);
int valid_race(int race, int class);
void reset_zone(int zone);
void remove_player(long id, byte stomp);
void Board_last_msg(struct char_data *ch, time_t last_logon);
void update_wholist(long newid);


/* prototypes for all do_x functions. */
ACMD(do_action);
ACMD(do_advance);
ACMD(do_alias);
ACMD(do_assist);
ACMD(do_at);
ACMD(do_backstab);
ACMD(do_ban);
ACMD(do_bash);
ACMD(do_cast);
ACMD(do_charge);
ACMD(do_color);
ACMD(do_commands);
ACMD(do_consider);
ACMD(do_clanstat);
ACMD(do_date);
ACMD(do_dc);
ACMD(do_diagnose);
ACMD(do_display);
ACMD(do_dns);	/* dnsmod */
ACMD(do_doorbash);
ACMD(do_drink);
ACMD(do_drop);
ACMD(do_eat);
ACMD(do_echo);
ACMD(do_email);
ACMD(do_enter);
ACMD(do_equipment);
ACMD(do_examine);
ACMD(do_exit);
ACMD(do_exits);
ACMD(do_finger);
ACMD(do_flee);
ACMD(do_follow);
ACMD(do_force);
ACMD(do_gecho);
ACMD(do_gemote);
ACMD(do_gen_comm);
ACMD(do_gen_door);
ACMD(do_gen_ps);
ACMD(do_gen_tog);
ACMD(do_gen_write);
ACMD(do_get);
ACMD(do_give);
ACMD(do_gold);
ACMD(do_gossip);
ACMD(do_gos_emote);
ACMD(do_goto);
ACMD(do_grab);
ACMD(do_group);
ACMD(do_gsay);
ACMD(do_hcontrol);
ACMD(do_headbutt);
ACMD(do_help);
ACMD(do_hide);
ACMD(do_hit);
ACMD(do_homepage);
ACMD(do_house);
ACMD(do_ignore);
ACMD(do_info);
ACMD(do_insult);
ACMD(do_inventory);
ACMD(do_invis);
ACMD(do_join);
ACMD(do_jump);
ACMD(do_kick);
ACMD(do_kill);
ACMD(do_last);
ACMD(do_leave);
ACMD(do_levels);
ACMD(do_load);
ACMD(do_logmsg);
ACMD(do_look);
ACMD(do_move);
ACMD(do_not_here);
ACMD(do_nstrike);       /* dwix */
ACMD(do_nofinger);
ACMD(do_offer);
ACMD(do_olc);
ACMD(do_order);
ACMD(do_page);
ACMD(do_palm);
ACMD(do_poofset);
ACMD(do_pour);
ACMD(do_practice);
ACMD(do_purge);
ACMD(do_put);
ACMD(do_qcomm);
ACMD(do_quit);
ACMD(do_reboot);
ACMD(do_recall);
ACMD(do_remove);
ACMD(do_rent);
ACMD(do_reply);
ACMD(do_report);
ACMD(do_rescue);
ACMD(do_rest);
ACMD(do_restore);
ACMD(do_return);
ACMD(do_save);
ACMD(do_say);
ACMD(do_score);
ACMD(do_send); 
ACMD(do_set);
ACMD(do_show);
ACMD(do_shutdown);
ACMD(do_sit);
ACMD(do_skillset);
ACMD(do_sleep);
ACMD(do_sneak);
ACMD(do_snoop);
ACMD(do_soulstrike);
ACMD(do_spec_comm);
ACMD(do_split);
ACMD(do_stand);
ACMD(do_stat);
ACMD(do_steal);
ACMD(do_switch);
ACMD(do_syslog);
ACMD(do_tag);
ACMD(do_teleport);
ACMD(do_tell);
ACMD(do_time);
ACMD(do_title);
ACMD(do_toggle);
ACMD(do_track);
ACMD(do_trans);
ACMD(do_trip);
ACMD(do_trust);		/*corpsemod*/
ACMD(do_thing);
ACMD(do_unban);
ACMD(do_ungroup);
ACMD(do_use);
ACMD(do_users);
ACMD(do_visible);
ACMD(do_vnum);
ACMD(do_vstat);
ACMD(do_wake);
ACMD(do_wear);
ACMD(do_weather);
ACMD(do_where);
ACMD(do_who);
ACMD(do_why);
ACMD(do_wield);
ACMD(do_wimpy);
ACMD(do_wizlock);
ACMD(do_wiznet);
ACMD(do_wizutil);
ACMD(do_write);
ACMD(do_zreset);
/*     KAKO     */
ACMD(do_afk);
ACMD(do_poof);
ACMD(do_nogroup);
ACMD(do_clan);
ACMD(do_thunder);
ACMD(do_peace);
ACMD(do_scan);
ACMD(do_pkill);
ACMD(do_come);
ACMD(do_noalias);
ACMD(do_disarm);
ACMD(do_bite);
ACMD(do_label);
ACMD(do_mount);
ACMD(do_dismount);
ACMD(do_berserk);
ACMD(do_view);
ACMD(do_breathe);
ACMD(do_affects);
ACMD(do_lay);
ACMD(do_dazzle);
ACMD(do_notch);    /*rangemod*/
ACMD(do_shoot);    /*rangemod*/
ACMD(do_unnotch);  /*rangemod*/
ACMD(do_empty);    /*rangemod*/
ACMD(do_circle);
ACMD(do_pchan);		/*pchannels*/
ACMD(do_affset);
ACMD(do_stone);         /*stonemod*/
ACMD(do_portal);
ACMD(do_whatis);
ACMD(do_config);
ACMD(do_target);
ACMD(do_restring);
ACMD(do_copy);          /* .06 */
ACMD(do_medit);         /*meditmod*/
ACMD(do_mset);          /*meditmod*/
ACMD(do_mstat);         /*meditmod*/
ACMD(do_oedit);         /*oeditmod*/
ACMD(do_oload);         /*oeditmod*/
ACMD(do_oset);          /*oeditmod*/
ACMD(do_osave);         /*oeditmod*/
ACMD(do_ostat);         /*oeditmod*/
ACMD(do_remort);        /*remortcmd*/
ACMD(do_rset);          /*reditmod*/
ACMD(do_rstat);         /*reditmod*/
ACMD(do_redit);         /* .06 */
ACMD(do_zedit);         /*reditmod*/
ACMD(do_zflags);        /*zeditmod*/
ACMD(do_zset);          /*zeditmod*/
ACMD(do_zstat);         /*zeditmod*/
ACMD(do_zallow);        /*oeditmod*/
ACMD(do_zdeny);         /*oeditmod*/
ACMD(do_zload);         /*zeditmod*/
ACMD(do_zgive);         /*zeditmod*/
ACMD(do_zequip);        /*zeditmod*/
ACMD(do_zremove);       /*zeditmod*/
ACMD(do_zput);          /*zeditmod*/
ACMD(do_zdelete);       /*zeditmod*/
ACMD(do_zdoor);         /*zeditmod*/
ACMD(do_zlist);         /* .06 */
ACMD(do_forage);


/* This is the Master Command List(tm).

 * You can put new commands in, take commands out, change the order
 * they appear in, etc.  You can adjust the "priority" of commands
 * simply by changing the order they appear in the command list.
 * (For example, if you want "as" to mean "assist" instead of "ask",
 * just put "assist" above "ask" in the Master Command List(tm).
 *
 * In general, utility commands such as "at" should have high priority;
 * infrequently used and dangerously destructive commands should have low
 * priority.
 */

const struct command_info cmd_info[] = {
  { "RESERVED", 0, 0, 0, 0 },	/* this must be first -- for specprocs */

  /* directions must come before other commands but after RESERVED */
  { "north"    , POS_STANDING, do_move     , 0, SCMD_NORTH },
  { "east"     , POS_STANDING, do_move     , 0, SCMD_EAST },
  { "south"    , POS_STANDING, do_move     , 0, SCMD_SOUTH },
  { "west"     , POS_STANDING, do_move     , 0, SCMD_WEST },
  { "up"       , POS_STANDING, do_move     , 0, SCMD_UP },
  { "down"     , POS_STANDING, do_move     , 0, SCMD_DOWN },
  { "neast"    , POS_STANDING, do_move     , 0, SCMD_NORTHEAST },
  { "seast"    , POS_STANDING, do_move     , 0, SCMD_SOUTHEAST },
  { "swest"    , POS_STANDING, do_move     , 0, SCMD_SOUTHWEST },
  { "nwest"    , POS_STANDING, do_move     , 0, SCMD_NORTHWEST },

  /* now, the main list */
  { "at"       , POS_DEAD    , do_at       , LVL_IMMORT, 0 },
  { "ack"      , POS_RESTING , do_action   , 0, 0 },    
  { "advance"  , POS_DEAD    , do_advance  , LVL_IMPL, 0 },
  { "admire"   , POS_RESTING , do_action   , 0, 0 },
  { "afk"      , POS_DEAD    , do_afk      , 0, 0 },
  { "alias"    , POS_DEAD    , do_alias    , 0, 0 },
  { "allclan"  , POS_DEAD    , do_gen_tog  , LVL_SIMP, SCMD_ALLCLAN },
  { "accuse"   , POS_SITTING , do_action   , 0, 0 }, 
  { "applaud"  , POS_RESTING , do_action   , 0, 0 }, 
  { "apologize", POS_RESTING , do_action   , 0, 0 },
  { "assist"   , POS_FIGHTING, do_assist   , 1, 0 },
  { "ask"      , POS_RESTING , do_spec_comm, 0, SCMD_ASK },
  { "auction"  , POS_SLEEPING, do_gen_comm , 0, SCMD_AUCTION },
  { "autoexit" , POS_DEAD    , do_gen_tog  , 0, SCMD_AUTOEXIT },
  { "autoloot" , POS_DEAD    , do_gen_tog  , 0, SCMD_AUTOLOOT },
  { "aww"      , POS_RESTING , do_action   , 0, 0 },
  { "argh"     , POS_RESTING , do_action   , 0, 0 },
  { "autotick" , POS_DEAD    , do_gen_tog  , 0, SCMD_AUTOTICK },
  { "autosplit" , POS_DEAD   , do_gen_tog  , 0, SCMD_AUTOSPLIT },
  { "affects"  , POS_DEAD    , do_affects  , 0, 0 },
  { "affset"   , POS_DEAD    , do_affset   , LVL_IMPL, 0 },
  { "aeroplane", POS_RESTING , do_action   , 0, 0 }, /*Rowan*/  

  { "bounce"   , POS_STANDING, do_action   , 0, 0 }, 
  { "backstab" , POS_STANDING, do_backstab , 1, 0 },
  { "ban"      , POS_DEAD    , do_ban      , LVL_IMPL, 0 },
  { "balance"  , POS_STANDING, do_not_here , 1, 0 },
  { "ballad"   , POS_STANDING, do_action   , 0, 0 },  
  { "bash"     , POS_FIGHTING, do_bash     , 1, 0 },
  { "bark"     , POS_SITTING , do_action   , 0, 0 },
  { "bandb"    , POS_RESTING , do_action   , 0, 0 },
  { "bearhug"  , POS_STANDING, do_action   , 0, 0 },
  { "beg"      , POS_RESTING , do_action   , 0, 0 },
  { "beat"     , POS_RESTING , do_action   , 0, 0 },
  { "bhead"    , POS_RESTING , do_action   , 0, 0 },
  { "bpat"     , POS_RESTING , do_action   , 0, 0 },
  { "bite"     , POS_STANDING, do_bite     , 1, 0 },  
  { "bleed"    , POS_RESTING , do_action   , 0, 0 },
  { "blush"    , POS_RESTING , do_action   , 0, 0 },
  { "bow"      , POS_STANDING, do_action   , 0, 0 },
  { "brb"      , POS_RESTING , do_action   , 0, 0 },
  { "brief"    , POS_DEAD    , do_gen_tog  , 0, SCMD_BRIEF },
  { "bslam"    , POS_STANDING, do_action   , 0, 0 },
  { "burp"     , POS_RESTING , do_action   , 0, 0 },
  { "buy"      , POS_STANDING, do_not_here , 0, 0 },
  { "bug"      , POS_DEAD    , do_gen_write, 0, SCMD_BUG },
  { "butcher"  , POS_FIGHTING, do_kill     , LVL_IMPL, SCMD_BUTCHER },
  { "berserk"  , POS_FIGHTING, do_berserk  , 1, 0 },
  { "boggle"   , POS_RESTING , do_action   , 0, 0 },
  { "babble"   , POS_RESTING , do_action   , 0, 0 },
  { "bahead"   , POS_RESTING , do_action   , 0, 0 },
  { "beckon"   , POS_STANDING, do_action   , 0, 0 }, /*Rowan*/
  { "belch"    , POS_RESTING , do_action   , 0, 0 },
  { "breathe"  , POS_FIGHTING, do_breathe  , 0, 0 },
  { "bonk"     , POS_RESTING , do_action   , 0, 0 },
  { "boo"      , POS_STANDING, do_action   , 0, 0 },  /* Miz2 */
  { "boot"     , POS_RESTING, do_action    , 0, 0 }, /*Rowan*/
  { "bkiss"    , POS_FIGHTING, do_action   , 0, 0 },
  { "blink"    , POS_RESTING , do_action   , 0, 0 },
  { "blook"    , POS_RESTING , do_action   , 0, 0 },
  { "bingle"   , POS_STANDING, do_action   , 0, 0 }, /* Miz */
  { "blick"    , POS_STANDING, do_action   , 0, 0 }, /* Miz */
  { "bitch"    , POS_STANDING, do_action   , 0, 0 }, /*Rowan*/
  { "butter"   , POS_STANDING, do_action   , 0, 0 }, /*jabber*/
  { "bump"     , POS_STANDING, do_action   , 0, 0 }, /*jabber*/
  { "book"     , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "boredom"  , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "bat"      , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "boards"   , POS_DEAD    , do_gen_tog  , 0, SCMD_NOCHK },

  { "cast"     , POS_SLEEPING, do_cast     , 1, 0 },
  { "cackle"   , POS_RESTING , do_action   , 0, 0 },
  { "check"    , POS_STANDING, do_not_here , 1, 0 },
  { "cheer"    , POS_RESTING , do_action   , 0, 0 }, 
  { "chuckle"  , POS_RESTING , do_action   , 0, 0 },
  { "chortle"  , POS_RESTING , do_action   , 0, 0 },
  { "charge"   , POS_FIGHTING, do_charge   , 0, 0 },
  { "clan"     , POS_SLEEPING, do_clan     , 1, 0 }, 
  { "claneq"   , POS_SLEEPING, do_gen_ps   , 0, SCMD_CLANEQ},
  { "clap"     , POS_RESTING , do_action   , 0, 0 },
  { "clear"    , POS_DEAD    , do_gen_ps   , 0, SCMD_CLEAR },
  { "close"    , POS_SITTING , do_gen_door , 0, SCMD_CLOSE },
  { "cls"      , POS_DEAD    , do_gen_ps   , 0, SCMD_CLEAR },
  { "consider" , POS_RESTING , do_consider , 0, 0 },
  { "color"    , POS_DEAD    , do_color    , 0, 0 },
  { "comfort"  , POS_SLEEPING, do_action   , 0, 0 }, 
  { "comb"     , POS_RESTING , do_action   , 0, 0 },
  { "commands" , POS_DEAD    , do_commands , 0, SCMD_COMMANDS },
  { "compact"  , POS_DEAD    , do_gen_tog  , 0, SCMD_COMPACT },
  { "cough"    , POS_RESTING , do_action   , 0, 0 },
  { "cover"    , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "credits"  , POS_DEAD    , do_gen_ps   , 0, SCMD_CREDITS },
  { "cringe"   , POS_RESTING , do_action   , 0, 0 },
  { "cry"      , POS_RESTING , do_action   , 0, 0 },
  { "cross"    , POS_RESTING , do_action   , 0, 0 },
  { "cuddle"   , POS_SLEEPING , do_action  , 0, 0 },
  { "curse"    , POS_RESTING , do_action   , 0, 0 },
  { "curtsey"  , POS_STANDING, do_action   , 0, 0 }, 
  { "coerce"   , POS_DEAD    , do_force    , LVL_SIMP, SCMD_COERCE }, 
  { "come"     , POS_SLEEPING, do_come     , 1, 0 },
  { "cartwheel", POS_STANDING, do_action   , 0, 0 },
  { "copy"     , POS_DEAD    , do_copy     , LVL_GOD, 0 }, /* .06 */
  { "concentrate", POS_DEAD  , do_gen_tog  , 0, SCMD_CONCENTRATE },
  { "cgrin"    , POS_RESTING , do_action   , 0, 0 }, /*jabber*/
  { "code"     , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "clone"    , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "corner"   , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "cook"     , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  
  { "clanstat" , POS_DEAD    , do_clanstat , 0, 0 },
  { "cdonate"  , POS_RESTING , do_drop     , 0, SCMD_CDONATE },
  { "circle"   , POS_FIGHTING, do_circle   , 0, 0 },
  { "config"   , POS_DEAD    , do_config   , 0, 0 },

  { "dance"    , POS_STANDING, do_action   , 0, 0 },
  { "dkiss"    , POS_RESTING , do_action   , 0, 0 },
  { "date"     , POS_DEAD    , do_date     , 0, SCMD_DATE },
  { "daydream" , POS_SLEEPING, do_action   , 0, 0 },
  { "dtape"    , POS_RESTING , do_action   , 0, 0 },
  { "dc"       , POS_DEAD    , do_dc       , LVL_IMPL, 0 },
  { "deposit"  , POS_STANDING, do_not_here , 1, 0 },
  { "diagnose" , POS_RESTING , do_diagnose , 0, 0 },
  { "display"  , POS_DEAD    , do_display  , 0, 0 },
  { "dino"     , POS_STANDING, do_action   , 0, 0 }, 
  { "dial"     , POS_STANDING, do_not_here , 0, 0 },
  { "doh"      , POS_RESTING,  do_action   , 0, 0 }, /* Miz */   
  { "donate"   , POS_RESTING , do_drop     , 0, SCMD_DONATE },
  { "doorbash" , POS_STANDING, do_doorbash , 0, 0 }, 
  { "drink"    , POS_RESTING , do_drink    , 0, SCMD_DRINK },
  { "drop"     , POS_RESTING , do_drop     , 0, SCMD_DROP },
  { "drool"    , POS_RESTING , do_action   , 0, 0 },
  { "disarm"   , POS_FIGHTING, do_disarm   , 1, 0 },
  { "dismount" , POS_STANDING, do_dismount , 0, 0 },
  { "doughboy" , POS_FIGHTING, do_action   , 0, 0 },
  { "ddance"   , POS_STANDING, do_action   , 0, 0 }, /*jabber*/
  { "dgrin"    , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "droses"   , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "dlook"    , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "dazzle"   , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "dns"      , POS_DEAD    , do_dns      , LVL_SIMP, 0 },
  { "duck"     , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "dust"     , POS_FIGHTING, do_dazzle   , 0, 0 }, /* dazzle */

  { "eat"      , POS_RESTING , do_eat      , 0, SCMD_EAT },
  { "echo"     , POS_SLEEPING, do_echo     , LVL_IMMORT, SCMD_ECHO },
  { "emote"    , POS_RESTING , do_echo     , 1, SCMD_EMOTE },
  { ":"        , POS_RESTING, do_echo      , 1, SCMD_EMOTE },
  { "emotes"   , POS_RESTING , do_echo     , 1, SCMD_EMOTES },
  { "embrace"  , POS_STANDING, do_action   , 0, 0 },
  { "enter"    , POS_STANDING, do_enter    , 0, 0 },
  { "email"    , POS_SLEEPING, do_email    , 0, 0 },
  { "equipment", POS_SLEEPING, do_equipment, 0, 0 },
  { "exits"    , POS_RESTING , do_exits    , 0, 0 },
  { "examine"  , POS_SITTING , do_examine  , 0, 0 },
  { "explode"  , POS_RESTING , do_action   , 0, 0 },
  { "ebreathe" , POS_RESTING , do_action   , 0, 0 }, 
  { "eek"      , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "eww"      , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "eyewig"   , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "eears"    , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "eye"      , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "empty"    , POS_FIGHTING, do_empty    , 0, 0 }, /*rangemod*/

  { "force"    , POS_SLEEPING, do_force    , LVL_GRGOD, 0 },
  { "faint"    , POS_RESTING , do_action   , 0, 0 },
  { "fart"     , POS_RESTING , do_action   , 0, 0 },
  { "fang"     , POS_RESTING , do_action   , 0, 0 },
  { "fhair"    , POS_RESTING , do_action   , 0, 0 },
  { "fill"     , POS_STANDING, do_pour     , 0, SCMD_FILL },
  { "finger"   , POS_SLEEPING, do_finger   , 0, 0 },                     
  { "five"     , POS_STANDING, do_action   , 0, 0 },                     
  { "flee"     , POS_FIGHTING, do_flee     , 1, 0 },
  { "flip"     , POS_STANDING, do_action   , 0, 0 },
  { "flex"     , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "fkiss"    , POS_RESTING , do_action   , 0, 0 },
  { "flirt"    , POS_RESTING , do_action   , 0, 0 },
  { "follow"   , POS_RESTING , do_follow   , 0, 0 },
  { "fondle"   , POS_RESTING , do_action   , 0, 0 },
  { "french"   , POS_RESTING , do_action   , 0, 0 },
  { "freeze"   , POS_DEAD    , do_wizutil  , LVL_FREEZE, SCMD_FREEZE },
  { "frown"    , POS_RESTING , do_action   , 0, 0 },
  { "fume"     , POS_RESTING , do_action   , 0, 0 },
  { "frolic"   , POS_STANDING, do_action   , 0, 0 },
  { "flop"     , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  
  { "fmouth"   , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "footsie"  , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "froth"    , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "ftickle"  , POS_SLEEPING, do_action   , 0, 0 }, /*Rowan*/
  { "forage"   , POS_STANDING, do_forage   , 0, 0 },

  { "get"      , POS_RESTING , do_get      , 0, 0 },
  { "gasp"     , POS_RESTING , do_action   , 0, 0 },
  { "gaze"     , POS_RESTING , do_action   , 0, 0 },
  { "gecho"    , POS_DEAD    , do_gecho    , LVL_GRGOD, 0 },
  { "gemote"   , POS_SLEEPING, do_gossip   , 0, SCMD_GMOTE },
  { "give"     , POS_RESTING , do_give     , 0, 0 },
  { "giggle"   , POS_RESTING , do_action   , 0, 0 },
  { "glance"   , POS_RESTING , do_action   , 0, 0,},
  { "glare"    , POS_RESTING , do_action   , 0, 0 },
  { "goto"     , POS_SLEEPING, do_goto     , LVL_IMMORT, 0 },
  { "gold"     , POS_RESTING , do_gold     , 0, 0 },
  { "gossip"   , POS_SLEEPING, do_gossip   , 0, SCMD_GOSSIP },
  { "gos2"     , POS_SLEEPING, do_gos_emote, 0, 0 },
  { "gossip2"  , POS_SLEEPING, do_gos_emote, 0, 0 },
  { "group"    , POS_SLEEPING, do_group    , 1, 0 },
  { "grab"     , POS_RESTING , do_grab     , 0, 0 },
  { "grats"    , POS_SLEEPING, do_gen_comm , 0, SCMD_GRATZ },
  { "greet"    , POS_RESTING , do_action   , 0, 0 },
  { "grin"     , POS_RESTING , do_action   , 0, 0 },
  { "groan"    , POS_RESTING , do_action   , 0, 0 },
  { "grope"    , POS_RESTING , do_action   , 0, 0 },
  { "grovel"   , POS_RESTING , do_action   , 0, 0 },
  { "growl"    , POS_RESTING , do_action   , 0, 0 },
  { "grumble"  , POS_RESTING , do_action   , 0, 0 },
  { "gsay"     , POS_SLEEPING, do_gsay     , 0, 0 },
  { "gtell"    , POS_SLEEPING, do_gsay     , 0, 0 },
  { "gulp"     , POS_RESTING , do_action   , 0, 0 },
  { "gtongue"  , POS_RESTING , do_action   , 0, 0 },
  { "gpeace"   , POS_FIGHTING, do_action   , 0, 0 },
  { "gibber"   , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "gigem"    , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "grill"    , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  


  { "heal"     , POS_STANDING, do_not_here , 0, 0 },
  { "help"     , POS_DEAD    , do_help     , 0, 0 },
  { "handbook" , POS_DEAD    , do_gen_ps   , LVL_IMMORT, SCMD_HANDBOOK },
  { "handcuff" , POS_STANDING, do_action   , 0, 0 }, /*Rowan*/
  { "hcontrol" , POS_DEAD    , do_hcontrol , LVL_IMPL, 0 },
  { "headbutt" , POS_FIGHTING, do_headbutt , 0, 0 },
  { "hiccup"   , POS_RESTING , do_action   , 0, 0 },
  { "hide"     , POS_RESTING , do_hide     , 1, 0 },
  { "hit"      , POS_FIGHTING, do_hit      , 0, SCMD_HIT },
  { "hold"     , POS_RESTING , do_grab     , 0, 0 },
  { "holylight", POS_DEAD    , do_gen_tog  , LVL_IMMORT, SCMD_HOLYLIGHT },
  { "homepage" , POS_SLEEPING, do_homepage , 0, 0 },
  { "hop"      , POS_RESTING , do_action   , 0, 0 },
  { "house"    , POS_RESTING , do_house    , 0, 0 },
  { "hug"      , POS_RESTING , do_action   , 0, 0 },
  { "hum"      , POS_RESTING , do_action   , 0, 0 }, /* Miz */
  { "hunger"   , POS_RESTING , do_action   , 0, 0 },
  { "hysteria" , POS_STANDING, do_action   , 0, 0 }, 
  { "hbreath"  , POS_RESTING , do_action   , 0, 0 },
  { "howdy"    , POS_RESTING , do_action   , 0, 0 },
  { "howl"     , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "hogtie"   , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  
  { "heckle"   , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "hoot"     , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "hypnotize", POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "hlaugh"   , POS_SLEEPING, do_action   , 0, 0 }, /*Rowan*/
  { "hello"    , POS_SLEEPING, do_action   , 0, 0 }, /*Rowan*/
  { "holler"   , POS_DEAD    , do_gen_comm , 0, SCMD_HOLLER },

  { "inventory", POS_DEAD    , do_inventory, 0, 0 },
  { "idea"     , POS_DEAD    , do_gen_write, 0, SCMD_IDEA },
  { "imotd"    , POS_DEAD    , do_gen_ps   , LVL_IMMORT, SCMD_IMOTD },
  { "immlist"  , POS_DEAD    , do_gen_ps   , 0, SCMD_IMMLIST },
  { "info"     , POS_SLEEPING, do_gen_ps   , 0, SCMD_INFO },
  { "insult"   , POS_RESTING , do_insult   , 0, 0 },
  { "invis"    , POS_DEAD    , do_invis    , LVL_IMMORT, 0 },
  { "invstart" , POS_DEAD    , do_gen_tog  , LVL_IMMORT, SCMD_INVSTART },
  { "ignore"   , POS_DEAD    , do_ignore   , 0, 0 },
  { "icky"     , POS_RESTING , do_action   , 0, 0 },
  { "iblink"   , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "ismile"   , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "iwhistle" , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/

  { "jaw"      , POS_RESTING , do_action   , 0, 0 },
  { "join"     , POS_RESTING , do_join     , 0, 0 },
  { "junk"     , POS_RESTING , do_drop     , 0, SCMD_JUNK },
  { "jump"     , POS_STANDING, do_jump     , 1, 0 },
  { "jeans"    , POS_RESTING , do_action   , 0, 0 },
  { "juggle"   , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  

  { "kill"     , POS_FIGHTING, do_kill     , 0, 0 },
  { "kick"     , POS_FIGHTING, do_kick     , 1, 0 },
  { "kiss"     , POS_RESTING , do_action   , 0, 0 },
  { "kisshand" , POS_RESTING , do_action   , 0, 0 },
  { "kidnap"   , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "knock"    , POS_SLEEPING, do_action   , 0, 0 }, /*Rowan*/

  { "look"     , POS_RESTING , do_look     , 0, SCMD_LOOK },
  { "lag"      , POS_SLEEPING, do_action   , 0, 0 },
  { "laugh"    , POS_RESTING , do_action   , 0, 0 },
  { "last"     , POS_DEAD    , do_last     , LVL_IMMORT, 0 },
  { "leave"    , POS_STANDING, do_leave    , 0, 0 },
  { "levels"   , POS_DEAD    , do_levels   , 0, 0 },
  { "list"     , POS_STANDING, do_not_here , 0, 0 },
  { "lick"     , POS_RESTING , do_action   , 0, 0 },
  { "lip"      , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "limbo"    , POS_STANDING, do_action   , 0, 0 }, /* Miz */
  { "lock"     , POS_SITTING , do_gen_door , 0, SCMD_LOCK },
  { "load"     , POS_DEAD    , do_load     , LVL_GOD, 0 }, 
  { "logmsg"   , POS_DEAD    , do_logmsg   , LVL_IMMORT, 0 }, 
  { "love"     , POS_RESTING , do_action   , 0, 0 },
  { "lovebite" , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "lhold"    , POS_RESTING , do_action   , 0, 0 },
  { "lnose"    , POS_RESTING , do_action   , 0, 0 },
  { "lust"     , POS_RESTING , do_action   , 0, 0 },
  { "light"    , POS_DEAD    , do_gen_tog  , LVL_IMMORT, SCMD_LIT },
  { "label"    , POS_DEAD    , do_label    , 1, 0 },
  { "lightbulb", POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "lay"      , POS_RESTING , do_lay      , 0, 0 },
  { "leer"     , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "license"  , POS_DEAD    , do_gen_ps   , 0, SCMD_LICENSE }, 

  { "moan"     , POS_RESTING , do_action   , 0, 0 },
  { "motd"     , POS_DEAD    , do_gen_ps   , 0, SCMD_MOTD },
  { "mail"     , POS_STANDING, do_not_here , 0, 0 },
  { "massage"  , POS_RESTING , do_action   , 0, 0 },
  { "mute"     , POS_DEAD    , do_wizutil  , LVL_GRGOD, SCMD_SQUELCH },
  { "murder"   , POS_FIGHTING, do_hit      , 0, SCMD_MURDER },
  { "medit"    , POS_DEAD    , do_medit    , LVL_GOD, 0 }, /*meditmod*/
  { "mset"     , POS_DEAD    , do_mset     , LVL_GOD, 0 }, /*meditmod*/
  { "mstat"    , POS_DEAD    , do_mstat    , LVL_GOD, 0 }, /*meditmod*/
  { "mount"    , POS_STANDING, do_mount    , 1, 0 },
  { "moon"     , POS_FIGHTING, do_action   , 0, 0 },
  { "meow"     , POS_RESTING , do_action   , 0, 0 },
  { "melt"     , POS_RESTING , do_action   , 0, 0 },
  { "meditate" , POS_RESTING , do_action   , 0, 0 },   /* Miz */
  { "mgrin"    , POS_RESTING , do_action   , 0, 0 },   /* ??? */
  { "munch"    , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "murmur"   , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "mosh"     , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "mime"     , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  
  { "movie"    , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  
  { "mwhere"   , POS_RESTING , do_where    , LVL_IMMORT, SCMD_MWHERE },


/*  { "news"     , POS_SLEEPING, do_gen_ps   , 0, SCMD_NEWS }, */
  { "nibble"   , POS_RESTING , do_action   , 0, 0 },
  { "nod"      , POS_RESTING , do_action   , 0, 0 },
  { "noogie"   , POS_RESTING , do_action   , 0, 0 },
  { "noauction", POS_DEAD    , do_gen_tog  , 0, SCMD_NOAUCTION },
  { "nogossip" , POS_DEAD    , do_gen_tog  , 0, SCMD_NOGOSSIP },
  { "nograts"  , POS_DEAD    , do_gen_tog  , 0, SCMD_NOGRATZ },
  { "noclan"   , POS_DEAD    , do_gen_tog  , 0, SCMD_NOCLAN },
  { "nogroup"  , POS_DEAD    , do_nogroup  , LVL_IMPL, 0 },
  { "nohassle" , POS_DEAD    , do_gen_tog  , LVL_IMMORT, SCMD_NOHASSLE },
  { "norepeat" , POS_DEAD    , do_gen_tog  , 0, SCMD_NOREPEAT },
  { "noshout"  , POS_SLEEPING, do_gen_tog  , 1, SCMD_DEAF },
  { "nosummon" , POS_DEAD    , do_gen_tog  , 1, SCMD_NOSUMMON },
  { "notell"   , POS_DEAD    , do_gen_tog  , 1, SCMD_NOTELL },
  { "notitle"  , POS_DEAD    , do_wizutil  , LVL_IMPL, SCMD_NOTITLE },
  { "nowiz"    , POS_DEAD    , do_gen_tog  , LVL_IMMORT, SCMD_NOWIZ },
  { "nudge"    , POS_RESTING , do_action   , 0, 0 },
  { "nuzzle"   , POS_RESTING , do_action   , 0, 0 },
  { "nohit"    , POS_DEAD    , do_gen_tog  , LVL_IMMORT, SCMD_NOHIT },
  { "noalias"  , POS_DEAD    , do_noalias  , LVL_GOD, 0 }, 
  { "nopage"   , POS_DEAD    , do_gen_tog  , 1, SCMD_NOPAGE },
  { "nstrike"  , POS_FIGHTING, do_nstrike  , 1, 0 }, /* dwix */
  { "nag"      , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "nofinger" , POS_DEAD    , do_nofinger , 0, 0 },
  { "notch"    , POS_FIGHTING, do_notch    , 0, 0 },

  { "order"    , POS_RESTING , do_order    , 1, 0 },
  { "ogle"     , POS_RESTING , do_action   , 0, 0 },
  { "ohno"     , POS_RESTING , do_action   , 0, 0 },
  { "ogasp"    , POS_RESTING , do_action   , 0, 0 },
  { "offer"    , POS_STANDING, do_not_here , 1, 0 },
  { "open"     , POS_SITTING , do_gen_door , 0, SCMD_OPEN },
  { "oset"     , POS_DEAD    , do_oset     , LVL_GOD, 0 }, /*oeditmod*/
  { "osave"    , POS_DEAD    , do_osave    , LVL_GOD, 0 }, /*oeditmod*/
  { "ostat"    , POS_DEAD    , do_ostat    , LVL_GOD, 0 }, /*oeditmod*/
  { "oedit"    , POS_DEAD    , do_oedit    , LVL_GOD, 0 }, /*oeditmod*/
  { "oload"    , POS_DEAD    , do_oload    , LVL_GOD, 0 }, /*oeditmod*/

  { "put"      , POS_RESTING , do_put      , 0, 0 },
  { "peace"    , POS_DEAD    , do_peace    , LVL_IMMORT, 0 },
  { "pant"     , POS_RESTING , do_action   , 0, 0 },
  { "pat"      , POS_RESTING , do_action   , 0, 0 },
  { "page"     , POS_DEAD    , do_page     , 2, 0 },
  { "palm"     , POS_STANDING, do_palm     , 0, 0 },
  { "pardon"   , POS_DEAD    , do_wizutil  , LVL_IMPL, SCMD_PARDON },
  { "pace"     , POS_STANDING, do_action   , 0, 0 },
  { "panic"    , POS_RESTING , do_action   , 0, 0 },
  { "peek"     , POS_RESTING , do_look     , 0, SCMD_PEEK },
  { "peer"     , POS_RESTING , do_action   , 0, 0 },
  { "pick"     , POS_STANDING, do_gen_door , 1, SCMD_PICK },
  { "pinch"    , POS_RESTING , do_action   , 0, 0 },  /* Miz */
  { "pkiss"    , POS_RESTING , do_action   , 0, 0 },
  { "plhair"   , POS_RESTING , do_action   , 0, 0 },
  { "point"    , POS_RESTING , do_action   , 0, 0 },
  { "poke"     , POS_RESTING , do_action   , 0, 0 },
  { "policy"   , POS_DEAD    , do_gen_ps   , 0, SCMD_POLICIES },
  { "ponder"   , POS_RESTING , do_action   , 0, 0 },
  { "poof"     , POS_DEAD    , do_poof     , LVL_IMMORT, 0 },
  { "pie"      , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "poofin"   , POS_DEAD    , do_poofset  , LVL_IMMORT, SCMD_POOFIN },
  { "poofout"  , POS_DEAD    , do_poofset  , LVL_IMMORT, SCMD_POOFOUT },
  { "pour"     , POS_SITTING , do_pour     , 0, SCMD_POUR },
  { "pout"     , POS_RESTING , do_action   , 0, 0 },
  { "prompt"   , POS_DEAD    , do_display  , 0, 0 },
  { "propose"  , POS_STANDING, do_action   , 0, 0 },  /* Miz */
  { "practice" , POS_RESTING , do_practice , 1, 0 },
  { "pray"     , POS_SITTING , do_action   , 0, 0 },
  { "puke"     , POS_RESTING , do_action   , 0, 0 },
  { "pullhair" , POS_RESTING , do_action   , 0, 0 },
  { "punch"    , POS_RESTING , do_action   , 0, 0 },
  { "purr"     , POS_RESTING , do_action   , 0, 0 },
  { "purge"    , POS_DEAD    , do_purge    , LVL_GOD, 0 },
  { "pierce"   , POS_FIGHTING, do_action   , LVL_GOD, 0 },
  { "pound"    , POS_FIGHTING, do_action   , LVL_GOD, 0 },
  { "pkill"    , POS_DEAD    , do_pkill    , LVL_SIMP, 0 },
  { "pcake"    , POS_RESTING , do_action   , 0, 0 },
  { "pnose"    , POS_STANDING, do_action   , 0, 0 }, /*jab*/
  { "polka"    , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  
  { "paint"    , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  
  { "pounce"   , POS_STANDING, do_action   , 0, 0 }, /*jabber*/
  { "pchan"    , POS_DEAD    , do_pchan    , 0, 0 }, /*pchan*/
  { "psay"     , POS_DEAD    , do_gen_comm , 0, SCMD_PSAY },
  { "portal"   , POS_RESTING , do_portal   , LVL_GOD, 0 },

  { "quaff"    , POS_RESTING , do_use      , 0, SCMD_QUAFF },
  { "qecho"    , POS_DEAD    , do_qcomm    , LVL_IMMORT, SCMD_QECHO },
  { "quest"    , POS_DEAD    , do_gen_tog  , 0, SCMD_QUEST },
  { "qui"      , POS_DEAD    , do_quit     , 0, 0 },
  { "quit"     , POS_DEAD    , do_quit     , 0, SCMD_QUIT },
  { "qsay"     , POS_SLEEPING , do_qcomm    , 0, SCMD_QSAY },
  { "qkiss"    , POS_RESTING , do_action   , 0, 0 },

  { "reply"    , POS_SLEEPING, do_reply    , 0, 0 },
  { "raise"    , POS_RESTING , do_action   , 0, 0 },
  { "rest"     , POS_RESTING , do_rest     , 0, 0 },
  { "read"     , POS_RESTING , do_look     , 0, SCMD_READ },
  { "reload"   , POS_DEAD    , do_reboot   , LVL_IMPL, 0 },
  { "recite"   , POS_RESTING , do_use      , 0, SCMD_RECITE },
  { "recall"   , POS_FIGHTING, do_recall   , 0, 0 },
  { "receive"  , POS_STANDING, do_not_here , 1, 0 },
  { "remove"   , POS_RESTING , do_remove   , 0, 0 },
  { "rent"     , POS_STANDING, do_not_here , 1, 0 },
  { "report"   , POS_SLEEPING , do_report   , 0, 0 },
  { "reroll"   , POS_DEAD    , do_wizutil  , LVL_IMPL, SCMD_REROLL },
  { "rescue"   , POS_FIGHTING, do_rescue   , 1, 0 },
  { "restore"  , POS_DEAD    , do_restore  , LVL_GRGOD, 0 },
  { "return"   , POS_DEAD    , do_return   , 0, 0 },
  { "roll"     , POS_RESTING , do_action   , 0, 0 },
  { "rollover" , POS_RESTING , do_action   , 0, 0 },
  { "roomflags", POS_DEAD    , do_gen_tog  , LVL_IMMORT, SCMD_ROOMFLAGS },
  { "ruffle"   , POS_RESTING , do_action   , 0, 0 },
  { "rub"      , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/  
  { "rogue"    , POS_STANDING, do_action   , 0, 0 },  /*Rowan*/
  { "redit"    , POS_DEAD    , do_redit    , LVL_GOD, 0 }, /* .06 */
  { "rset"     , POS_DEAD    , do_rset     , LVL_GOD, 0 }, /*reditmod*/
  { "rstat"    , POS_DEAD    , do_rstat    , LVL_GOD, 0 }, /*reditmod*/
  { "relax"    , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "rcheck"   , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "remor"    , POS_STANDING, do_remort, LVL_DEMI, 0},
  { "remort"   , POS_STANDING, do_remort, LVL_DEMI, SCMD_REMORT}, 
  { "restring" , POS_STANDING, do_restring  , LVL_GRGOD, 0},

  { "say"      , POS_RESTING , do_say      , 0, 0 },
  { "'"        , POS_RESTING , do_say      , 0, 0 },
  { "save"     , POS_SLEEPING, do_save     , 0, 0 },
  { "score"    , POS_DEAD    , do_score    , 0, 0 },
  { "scratch"  , POS_RESTING , do_action   , 0, 0 },
  { "scream"   , POS_RESTING , do_action   , 0, 0 },
  { "sell"     , POS_STANDING, do_not_here , 0, 0 },
  { "send"     , POS_SLEEPING, do_send     , LVL_GRGOD, 0 },
  { "set"      , POS_DEAD    , do_set      , LVL_IMMORT, 0 },
  { "shout"    , POS_RESTING , do_gen_comm , 0, SCMD_SHOUT },
  { "shake"    , POS_RESTING , do_action   , 0, 0 },
  { "sheepish" , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "shiver"   , POS_RESTING , do_action   , 0, 0 },
  { "shoot"    , POS_FIGHTING, do_shoot    , 0, 0 }, /*rangemod*/
  { "show"     , POS_DEAD    , do_show     , LVL_IMMORT, 0 },
  { "shower"   , POS_RESTING , do_action   , 0, 0 },
  { "shrug"    , POS_RESTING , do_action   , 0, 0 },
  { "shutdow"  , POS_DEAD    , do_shutdown , LVL_SIMP, 0 },
  { "shutdown" , POS_DEAD    , do_shutdown , LVL_SIMP, SCMD_SHUTDOWN },
  { "skiss"    , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "skick"    , POS_RESTING , do_action   , 0, 0 },
  { "sigh"     , POS_RESTING , do_action   , 0, 0 },
  { "sing"     , POS_RESTING , do_action   , 0, 0 },
  { "sip"      , POS_RESTING , do_drink    , 0, SCMD_SIP },
  { "sit"      , POS_RESTING , do_sit      , 0, 0 },
  { "skillset" , POS_SLEEPING, do_skillset , LVL_IMPL, 0 },
  { "sleep"    , POS_SLEEPING, do_sleep    , 0, 0 },
  { "slam"     , POS_STANDING, do_action   , 0, 0 },
  { "slap"     , POS_RESTING , do_action   , 0, 0 },
  { "slowns"   , POS_DEAD    , do_gen_tog  , LVL_SIMP, SCMD_SLOWNS },
  { "smile"    , POS_RESTING , do_action   , 0, 0 },
  { "smirk"    , POS_RESTING , do_action   , 0, 0 },
  { "slook"    , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/ 
  { "smoke"    , POS_RESTING , do_action   , 0, 0 },
  { "snicker"  , POS_RESTING , do_action   , 0, 0 },
  { "snap"     , POS_RESTING , do_action   , 0, 0 },
  { "snarl"    , POS_RESTING , do_action   , 0, 0 },
  { "sneeze"   , POS_RESTING , do_action   , 0, 0 },
  { "sneak"    , POS_STANDING, do_sneak    , 1, 0 },
  { "sniff"    , POS_RESTING , do_action   , 0, 0 },
  { "snore"    , POS_SLEEPING, do_action   , 0, 0 },
  { "snort"    , POS_RESTING , do_action   , 0, 0 },
  { "snowball" , POS_STANDING, do_action   , LVL_IMMORT, 0 },
  { "snoop"    , POS_DEAD    , do_snoop    , LVL_GOD, 0 },
  { "snuggle"  , POS_SLEEPING , do_action   , 0, 0 },
  { "smack"    , POS_RESTING , do_action   , 0, 0 },
  { "spam"     , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "squirm"   , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "swat"     , POS_RESTING , do_action   , 0, 0 },
  { "swoon"    , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "socials"  , POS_DEAD    , do_commands , 0, SCMD_SOCIALS },
  { "soulstrike" , POS_FIGHTING, do_soulstrike , 15, 0 },
  { "split"    , POS_SITTING , do_split    , 1, 0 },
  { "spank"    , POS_RESTING , do_action   , 0, 0 },
  { "spit"     , POS_STANDING, do_action   , 0, 0 },
  { "squeeze"  , POS_RESTING , do_action   , 0, 0 },
  { "stand"    , POS_RESTING , do_stand    , 0, 0 },
  { "stare"    , POS_RESTING , do_action   , 0, 0 },
  { "stat"     , POS_DEAD    , do_stat     , LVL_IMMORT, 0 },
  { "steal"    , POS_STANDING, do_steal    , 1, 0 },
  { "steam"    , POS_RESTING , do_action   , 0, 0 },
  { "stroke"   , POS_RESTING , do_action   , 0, 0 },
  { "strut"    , POS_STANDING, do_action   , 0, 0 },
  { "sulk"     , POS_RESTING , do_action   , 0, 0 },
  { "swkiss"   , POS_RESTING , do_action   , 0, 0 },
  { "switch"   , POS_DEAD    , do_switch   , LVL_GOD, 0 },
  { "syslog"   , POS_DEAD    , do_syslog   , LVL_IMMORT, 0 },
  { "slash"    , POS_FIGHTING, do_action   , LVL_GOD, 0 },
  { "scan"     , POS_STANDING, do_scan     , 1, 0 },
  { "stress"   , POS_RESTING , do_action   , 0, 0 },
  { "stagger"  , POS_STANDING, do_action   , 0, 0 },
  { "skip"     , POS_STANDING, do_action   , 0, 0 },
  { "slip"     , POS_STANDING, do_action   , 0, 0 },
  { "shame"    , POS_RESTING , do_action   , 0, 0 },
  { "silly"    , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  
  { "slaugh"   , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "slobber"  , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "swing"    , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  
  { "serenade" , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  
  { "stone"    , POS_RESTING , do_stone    , LVL_GOD, 0 }, /*stonemod*/
  { "shackle"  , POS_SLEEPING, do_action   , 0, 0 }, /*Rowan*/
  { "sympathy" , POS_SLEEPING, do_action   , 0, 0 }, /*Rowan*/
  { "speedbuild", POS_DEAD   , do_gen_tog  , LVL_GOD, SCMD_SPDBLD},

  { "tell"     , POS_DEAD    , do_tell     , 0, 0 },
  { "tackle"   , POS_RESTING , do_action   , 0, 0 },
  { "tag"      , POS_RESTING , do_tag      , 0, 0 },
  { "take"     , POS_RESTING , do_get      , 0, 0 },
  { "tango"    , POS_STANDING, do_action   , 0, 0 },
  { "taunt"    , POS_RESTING , do_action   , 0, 0 },
  { "taste"    , POS_RESTING , do_eat      , 0, SCMD_TASTE },
  { "teleport" , POS_DEAD    , do_teleport , LVL_GRGOD, 0 },
  { "thank"    , POS_RESTING , do_action   , 0, 0 },
  { "think"    , POS_RESTING , do_action   , 0, 0 },
  { "thaw"     , POS_DEAD    , do_wizutil  , LVL_FREEZE, SCMD_THAW },
  { "thunder"  , POS_DEAD    , do_thunder  , LVL_IMPL, 0},
  { "thwap"    , POS_RESTING , do_action   , 0, 0 },
  { "thwack"   , POS_RESTING , do_action   , 0, 0 },
  { "title"    , POS_DEAD    , do_title    , 0, 0 },
  { "tickle"   , POS_RESTING , do_action   , 0, 0 },
  { "tie"      , POS_STANDING, do_action   , 0, 0 }, /*Rowan*/
  { "time"     , POS_DEAD    , do_time     , 0, 0 },
  { "timeout"  , POS_RESTING , do_action   , 0, 0 },
  { "touch"    , POS_RESTING , do_action   , 0, 0 },
  { "tongue"   , POS_RESTING , do_action   , 0, 0 },
  { "toggle"   , POS_DEAD    , do_toggle   , 0, 0 },
  { "track"    , POS_STANDING, do_track    , 0, 0 },
  { "trace"    , POS_RESTING , do_action   , 0, 0 },
  { "transfer" , POS_SLEEPING, do_trans    , LVL_GOD, 0 },
  { "trip"     , POS_FIGHTING, do_trip     , 0, 0 },
/*  { "trust"    , POS_SLEEPING, do_trust    , 110, 0 }, *corpsemod*/
  { "twiddle"  , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "typo"     , POS_RESTING , do_action   , 0, 0 },
  { "twirl"    , POS_STANDING, do_action   , 0, 0 },
  { "tug"      , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "toe"      , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "tuck"     , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "thing"    , POS_DEAD    , do_thing    , 110, 0}, /* do NOT use! */  
  { "train"    , POS_STANDING, do_not_here , 0, 0},
  { "tkiss"    , POS_RESTING , do_action   , 0, 0},
  { "tip"      , POS_RESTING,  do_action   , 0, 0}, /*Rowan*/
  { "tantrum"  , POS_RESTING,  do_action   , 0, 0}, /*Rowan*/
  { "toast"    , POS_RESTING,  do_action   , 0, 0}, /*Rowan*/
  { "target"   , POS_STANDING, do_target   , LVL_GRGOD, 0}, /* targetmod */

  { "unlock"   , POS_SITTING , do_gen_door , 0, SCMD_UNLOCK },
  { "ungroup"  , POS_DEAD    , do_ungroup  , 0, 0 },
  { "unban"    , POS_DEAD    , do_unban    , LVL_IMPL, 0 },
  { "unaffect" , POS_DEAD    , do_wizutil  , LVL_IMPL, SCMD_UNAFFECT },
  { "uptime"   , POS_DEAD    , do_date     , 0, SCMD_UPTIME },
  { "use"      , POS_SITTING , do_use      , 1, SCMD_USE },
  { "users"    , POS_DEAD    , do_users    , LVL_IMMORT, 0 },
  { "unnotch"  , POS_FIGHTING, do_unnotch  , 0, 0 }, /*rangemod*/
  { "ungiggle" , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/

  { "value"    , POS_STANDING, do_not_here , 0, 0 },
  { "version"  , POS_DEAD    , do_gen_ps   , 0, SCMD_VERSION },
  { "visible"  , POS_RESTING , do_visible  , 1, 0 },
  { "vnum"     , POS_DEAD    , do_vnum     , LVL_IMMORT, 0 },
  { "vstat"    , POS_DEAD    , do_vstat    , LVL_IMMORT, 0 },
  { "view"     , POS_DEAD    , do_view     , 0, 0 },
  { "valium"   , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/
  { "violin"   , POS_RESTING , do_action   , 0, 0 }, /*Rowan*/

  { "wake"     , POS_SLEEPING, do_wake     , 0, 0 },
  { "wave"     , POS_RESTING , do_action   , 0, 0 },
  { "warcry"   , POS_RESTING , do_action   , 0, 0 },
  { "waltz"    , POS_STANDING, do_action   , 0, 0 }, /*Rowan*/
  { "wear"     , POS_RESTING , do_wear     , 0, 0 },
  { "wedgie"   , POS_RESTING , do_action   , 0, 0 },
  { "weather"  , POS_RESTING , do_weather  , 0, 0 },
  { "who"      , POS_DEAD    , do_who      , 0, 0 },
  { "why"      , POS_DEAD    , do_why      , 0, 0 },
  { "whoami"   , POS_DEAD    , do_gen_ps   , 0, SCMD_WHOAMI },
  { "where"    , POS_RESTING , do_where    , 1, 0 },
  { "whisper"  , POS_RESTING , do_spec_comm, 0, SCMD_WHISPER },
  { "whine"    , POS_RESTING , do_action   , 0, 0 },
  { "whistle"  , POS_RESTING , do_action   , 0, 0 },
  { "wield"    , POS_RESTING , do_wield    , 0, 0 },
  { "wiggle"   , POS_STANDING, do_action   , 0, 0 },
  { "wimpy"    , POS_DEAD    , do_wimpy    , 0, 0 },
  { "wink"     , POS_RESTING , do_action   , 0, 0 },
  { "wipe"     , POS_RESTING , do_action   , 0, 0 },
  { "withdraw" , POS_STANDING, do_not_here , 1, 0 },
  { "wiznet"   , POS_DEAD    , do_wiznet   , LVL_IMMORT, 0 },
  { ";"        , POS_DEAD    , do_wiznet   , LVL_IMMORT, 0 },
  { "wizhelp"  , POS_SLEEPING, do_commands , LVL_IMMORT, SCMD_WIZHELP },
  { "wizlist"  , POS_DEAD    , do_gen_ps   , 0, SCMD_WIZLIST },
  { "wizlock"  , POS_DEAD    , do_wizlock  , LVL_SIMP, 0 },
  { "worship"  , POS_RESTING , do_action   , 0, 0 },
  { "write"    , POS_STANDING, do_write    , 1, 0 },
  { "wetwil"   , POS_STANDING, do_action   , 0, 0 },
  { "whoop"    , POS_STANDING, do_action   , 0, 0 }, /*jabber*/  
  { "wince"    , POS_RESTING , do_action   , 0, 0 }, /*jabber*/  
  { "whatis"   , POS_DEAD    , do_whatis   , 0, 0 },

  { "yawn"     , POS_RESTING , do_action   , 0, 0 },
  { "yahoo"    , POS_RESTING , do_action   , 0, 0 },
  { "yeehaw"   , POS_RESTING , do_action   , 0, 0 },
  { "yodel"    , POS_RESTING , do_action   , 0, 0 },
  { "yabba"    , POS_RESTING , do_action   , 0, 0 },
  { "yelp"     , POS_RESTING , do_action   , 0, 0 },

  { "zreset"   , POS_DEAD    , do_zreset   , LVL_GRGOD, 0 },
  { "zedit"    , POS_DEAD    , do_zedit    , LVL_GOD, 0 },   /*reditmod*/
  { "zflags"   , POS_DEAD    , do_zflags   , LVL_GOD, 0 },   /*zeditmod*/
  { "zset"     , POS_DEAD    , do_zset     , LVL_GOD, 0 },   /*zeditmod*/
  { "zstat"    , POS_DEAD    , do_zstat    , LVL_GOD, 0 },   /*zeditmod*/
  { "zallow"   , POS_DEAD    , do_zallow   , LVL_IMPL, 0 },  /*oeditmod*/
  { "zdeny"    , POS_DEAD    , do_zdeny    , LVL_IMPL, 0 },  /*oeditmod*/
  { "zdelete"  , POS_DEAD    , do_zdelete  , LVL_GOD, 0 },   /*zeditmod*/
  { "zdoor"    , POS_DEAD    , do_zdoor    , LVL_GOD, 0 },   /*zeditmod*/
  { "zequip"   , POS_DEAD    , do_zequip   , LVL_GOD, 0 },   /*zeditmod*/
  { "zgive"    , POS_DEAD    , do_zgive    , LVL_GOD, 0 },   /*zeditmod*/
  { "zlist"    , POS_DEAD    , do_zlist    , LVL_GOD, 0 },   /* .06 */
  { "zload"    , POS_DEAD    , do_zload    , LVL_GOD, 0 },   /*zeditmod*/
  { "zput"     , POS_DEAD    , do_zput     , LVL_GOD, 0 },   /*zeditmod*/
  { "zremove"  , POS_DEAD    , do_zremove  , LVL_GOD, 0 },   /*zeditmod*/
  { "zip"      , POS_RESTING , do_action   , 0, 0 },
  { "zerbert"  , POS_STANDING, do_action   , 0, 0}, /*jabber*/

  { "\n", 0, 0, 0, 0 } };	/* this must be last */


char *fill[] =
{
  "in",
  "from",
  "with",
  "the",
  "on",
  "at",
  "to",
  "\n"
};

char *reserved[] =
{
  "self",
  "me",
  "all",
  "room",
  "someone",
  "something",
  "\n"
};

/*
 * This is the actual command interpreter called from game_loop() in comm.c
 * It makes sure you are the proper level and position to execute the command,
 * then calls the appropriate function.
 */
void command_interpreter(struct char_data *ch, char *argument)
{
  int cmd, length;
  extern int no_specials;
  char *line;

  REMOVE_BIT(AFF_FLAGS(ch), AFF_HIDE);
  if (IS_AFFECTED(ch, AFF_CHARM) && !ch->master)
    REMOVE_BIT(AFF_FLAGS(ch), AFF_CHARM);
  if (IS_SET(AFF2_FLAGS(ch), AFF2_BLINK) && 
      !affected_by_spell(ch, SPELL_BLINK))
    REMOVE_BIT(AFF2_FLAGS(ch), AFF2_BLINK);
  if (ch->char_specials.blinkon)
    return;

  /* just drop to next line for hitting CR */
  skip_spaces(&argument);
  if (!*argument)
    return;

  /*
   * special case to handle one-character, non-alphanumeric commands;
   * requested by many people so "'hi" or ";godnet test" is possible.
   * Patch sent by Eric Green and Stefan Wasilewski.
   */
  if (!isalpha(*argument)) {
    arg[0] = argument[0];
    arg[1] = '\0';
    line = argument + 1;
  } else
    line = any_one_arg(argument, arg);

  /* otherwise, find the command */
  for (length = strlen(arg), cmd = 0; *cmd_info[cmd].command != '\n'; cmd++)
    if (!strncmp(cmd_info[cmd].command, arg, length))
      if (((ch->desc && ch->desc->original) ? GET_LEVEL(ch->desc->original) : 
           GET_LEVEL(ch)) >= cmd_info[cmd].minimum_level || GET_IDNUM(ch) == 1)
	break;

  if (*cmd_info[cmd].command == '\n')
    send_to_char("Huh?!?\r\n", ch);
  else if (PLR_FLAGGED(ch, PLR_FROZEN) && GET_LEVEL(ch) < LVL_IMPL)
    send_to_char("You try, but the mind-numbing cold prevents you...\r\n", ch);
  else if (cmd_info[cmd].command_pointer == NULL)
    send_to_char("Sorry, that command hasn't been implemented yet.\r\n", ch);
/*  else if (IS_NPC(ch) && cmd_info[cmd].minimum_level >= LVL_IMMORT)
    send_to_char("You can't use immortal commands while switched.\r\n", ch); */
  else if (GET_POS(ch) < cmd_info[cmd].minimum_position)
    switch (GET_POS(ch)) {
    case POS_DEAD:
      send_to_char("Lie still; you are DEAD!!! :-(\r\n", ch);
      break;
    case POS_INCAP:
    case POS_MORTALLYW:
      send_to_char("You are in a pretty bad shape, unable to do anything!\r\n", ch);
      break;
    case POS_STUNNED:
      send_to_char("All you can do right now is think about the stars!\r\n", ch);
      break;
    case POS_SLEEPING:
      send_to_char("In your dreams, or what?\r\n", ch);
      break;
    case POS_RESTING:
      send_to_char("Nah... You feel too relaxed to do that..\r\n", ch);
      break;
    case POS_SITTING:
      send_to_char("Maybe you should get on your feet first?\r\n", ch);
      break;
    case POS_FIGHTING:
      send_to_char("No way!  You're fighting for your life!\r\n", ch);
      break;
  } else if (no_specials || !special(ch, cmd, line))
    ((*cmd_info[cmd].command_pointer) (ch, line, cmd, cmd_info[cmd].subcmd));
}

/**************************************************************************
 * Routines to handle aliasing                                             *
  **************************************************************************/


struct alias *find_alias(struct alias *alias_list, char *str)
{
  while (alias_list != NULL) {
    if (*str == *alias_list->alias)	/* hey, every little bit counts :-) */
      if (!strcmp(str, alias_list->alias))
	return alias_list;

    alias_list = alias_list->next;
  }

  return NULL;
}


void free_alias(struct alias *a)
{
  if (a->alias)
    free(a->alias);
  if (a->replacement)
    free(a->replacement);
  free(a);
}


/* The interface to the outside world: do_alias */
ACMD(do_alias)
{
  char *repl;
  struct alias *a, *temp;

  if (IS_NPC(ch))
    return;

  repl = any_one_arg(argument, arg);

  if (!*arg) {			/* no argument specified -- list currently defined aliases */
    send_to_char("Currently defined aliases:\r\n", ch);
    if ((a = GET_ALIASES(ch)) == NULL)
      send_to_char(" None.\r\n", ch);
    else {
      while (a != NULL) {
	sprintf(buf, "%-15s %s\r\n", a->alias, a->replacement);
	send_to_char(buf, ch);
	a = a->next;
      }
    }
  } else {			/* otherwise, add or remove aliases */
    /* is this an alias we've already defined? */
    if ((a = find_alias(GET_ALIASES(ch), arg)) != NULL) {
      REMOVE_FROM_LIST(a, GET_ALIASES(ch), next);
      free_alias(a);
    }
    /* if no replacement string is specified, assume we want to delete */
    if (!*repl) {
      if (a == NULL)
	send_to_char("No such alias.\r\n", ch);
      else
	send_to_char("Alias deleted.\r\n", ch);
    } else {			/* otherwise, either add or redefine an alias */
      if (!str_cmp(arg, "alias")) {
	send_to_char("You can't alias 'alias'.\r\n", ch);
	return;
      }
      CREATE(a, struct alias, 1);
      a->alias = str_dup(arg);
      delete_doubledollar(repl);
      a->replacement = str_dup(repl);
      if (strchr(repl, ALIAS_SEP_CHAR) || strchr(repl, ALIAS_VAR_CHAR))
	a->type = ALIAS_COMPLEX;
      else
	a->type = ALIAS_SIMPLE;
      a->next = GET_ALIASES(ch);
      GET_ALIASES(ch) = a;
      send_to_char("Alias added.\r\n", ch);
    }
  }
}

/*
 * Valid numeric replacements are only &1 .. &9 (makes parsing a little
 * easier, and it's not that much of a limitation anyway.)  Also valid
 * is "&*", which stands for the entire original line after the alias.
 * ";" is used to delimit commands.
 */
#define NUM_TOKENS       9

void perform_complex_alias(struct txt_q *input_q, char *orig, struct alias *a)
{
  struct txt_q temp_queue;
  char *tokens[NUM_TOKENS], *temp, *write_point;
  int num_of_tokens = 0, num;

  /* First, parse the original string */
  temp = strtok(strcpy(buf2, orig), " ");
  while (temp != NULL && num_of_tokens < NUM_TOKENS) {
    tokens[num_of_tokens++] = temp;
    temp = strtok(NULL, " ");
  }

  /* initialize */
  write_point = buf;
  temp_queue.head = temp_queue.tail = NULL;

  /* now parse the alias */
  for (temp = a->replacement; *temp; temp++) {
    if (*temp == ALIAS_SEP_CHAR) {
      *write_point = '\0';
      buf[MAX_INPUT_LENGTH - 1] = '\0';
      write_to_q(buf, &temp_queue, 1);
      write_point = buf;
    } else if (*temp == ALIAS_VAR_CHAR) {
      temp++;
      if ((num = *temp - '1') < num_of_tokens && num >= 0) {
	strcpy(write_point, tokens[num]);
	write_point += strlen(tokens[num]);
      } else if (*temp == ALIAS_GLOB_CHAR) {
	strcpy(write_point, orig);
	write_point += strlen(orig);
      } else if ((*(write_point++) = *temp) == '$')	/* redouble $ for act safety */
	*(write_point++) = '$';
    } else
      *(write_point++) = *temp;
  }

  *write_point = '\0';
  buf[MAX_INPUT_LENGTH - 1] = '\0';
  write_to_q(buf, &temp_queue, 1);

  /* push our temp_queue on to the _front_ of the input queue */
  if (input_q->head == NULL)
    *input_q = temp_queue;
  else {
    temp_queue.tail->next = input_q->head;
    input_q->head = temp_queue.head;
  }
}


/*
 * Given a character and a string, perform alias replacement on it.
 *
 * Return values:
 *   0: String was modified in place; call command_interpreter immediately.
 *   1: String was _not_ modified in place; rather, the expanded aliases
 *      have been placed at the front of the character's input queue.
 */
int perform_alias(struct descriptor_data *d, char *orig)
{
  char first_arg[MAX_INPUT_LENGTH], *ptr;
  struct alias *a, *tmp;

  /* bail out immediately if the guy doesn't have any aliases */
  if ((tmp = GET_ALIASES(d->character)) == NULL)
    return 0;

  /* find the alias we're supposed to match */
  ptr = any_one_arg(orig, first_arg);

  /* bail out if it's null */
  if (!*first_arg)
    return 0;

  /* if the first arg is not an alias, return without doing anything */
  if ((a = find_alias(tmp, first_arg)) == NULL)
    return 0;

  if (a->type == ALIAS_SIMPLE) {
    strcpy(orig, a->replacement);
    return 0;
  } else {
    perform_complex_alias(&d->input, ptr, a);
    return 1;
  }
}



/***************************************************************************
 * Various other parsing utilities                                         *
 **************************************************************************/

/*
 * searches an array of strings for a target string.  "exact" can be
 * 0 or non-0, depending on whether or not the match must be exact for
 * it to be returned.  Returns -1 if not found; 0..n otherwise.  Array
 * must be terminated with a '\n' so it knows to stop searching.
 */
int search_block(char *arg, char **list, bool exact)
{
  register int i, l;

  /* Make into lower case, and get length of string */
  for (l = 0; *(arg + l); l++)
    *(arg + l) = LOWER(*(arg + l));

  if (exact) {
    for (i = 0; **(list + i) != '\n'; i++)
      if (!strcmp(arg, *(list + i)))
	return (i);
  } else {
    if (!l)
      l = 1;			/* Avoid "" to match the first available
				 * string */
    for (i = 0; **(list + i) != '\n'; i++)
      if (!strncmp(arg, *(list + i), l))
	return (i);
  }

  return -1;
}


int is_number(char *str)
{
  while (*str)
    if (!isdigit(*(str++)))
      return 0;

  return 1;
}


void skip_spaces(char **string)
{
  for (; **string && isspace(**string); (*string)++);
}


char *delete_doubledollar(char *string)
{
  char *read, *write;

  if ((write = strchr(string, '$')) == NULL)
    return string;

  read = write;

  while (*read)
    if ((*(write++) = *(read++)) == '$')
      if (*read == '$')
	read++;

  *write = '\0';

  return string;
}


int fill_word(char *argument)
{
  return (search_block(argument, fill, TRUE) >= 0);
}


int reserved_word(char *argument)
{
  return (search_block(argument, reserved, TRUE) >= 0);
}


/*
 * copy the first non-fill-word, space-delimited argument of 'argument'
 * to 'first_arg'; return a pointer to the remainder of the string.
 */
char *one_argument(char *argument, char *first_arg)
{
  char *begin = first_arg;

  do {
    skip_spaces(&argument);

    first_arg = begin;
    while (*argument && !isspace(*argument)) {
      *(first_arg++) = LOWER(*argument);
      argument++;
    }

    *first_arg = '\0';
  } while (fill_word(begin));

  return argument;
}


/*
 * one_word is like one_argument, except that words in quotes ("") are
 * considered one word.
 */
char *one_word(char *argument, char *first_arg)
{
  char *begin = first_arg;

  do {
    skip_spaces(&argument);

    first_arg = begin;

    if (*argument == '\"') {
      argument++;
      while (*argument && *argument != '\"') {
        *(first_arg++) = LOWER(*argument);
        argument++;
      }
      argument++;
    } else {
      while (*argument && !isspace(*argument)) {
        *(first_arg++) = LOWER(*argument);
        argument++;
      }
    }

    *first_arg = '\0';
  } while (fill_word(begin));

  return argument;
}


/* same as one_argument except that it doesn't ignore fill words */
char *any_one_arg(char *argument, char *first_arg)
{
  skip_spaces(&argument);

  while (*argument && !isspace(*argument)) {
    *(first_arg++) = LOWER(*argument);
    argument++;
  }

  *first_arg = '\0';

  return argument;
}


/*
 * Same as one_argument except that it takes two args and returns the rest;
 * ignores fill words
 */
char *two_arguments(char *argument, char *first_arg, char *second_arg)
{
  return one_argument(one_argument(argument, first_arg), second_arg); /* :-) */
}



/*
 * determine if a given string is an abbreviation of another
 * (now works symmetrically -- JE 7/25/94)
 *
 * that was dumb.  it shouldn't be symmetrical.  JE 5/1/95
 * 
 * returnss 1 if arg1 is an abbreviation of arg2
 */
int is_abbrev(char *arg1, char *arg2)
{
  if (!*arg1)
    return 0;

  for (; *arg1 && *arg2; arg1++, arg2++)
    if (LOWER(*arg1) != LOWER(*arg2))
      return 0;

  if (!*arg1)
    return 1;
  else
    return 0;
}



/* return first space-delimited token in arg1; remainder of string in arg2 */
void half_chop(char *string, char *arg1, char *arg2)
{
  char *temp;

  temp = any_one_arg(string, arg1);
  skip_spaces(&temp);
  strcpy(arg2, temp);
}



/* Used in specprocs, mostly.  (Exactly) matches "command" to cmd number */
int find_command(char *command)
{
  int cmd;

  for (cmd = 0; *cmd_info[cmd].command != '\n'; cmd++)
    if (!strcmp(cmd_info[cmd].command, command))
      return cmd;

  return -1;
}


int special(struct char_data *ch, int cmd, char *arg)
{
  register struct obj_data *i;
  register struct char_data *k;
  int j;

  /* special in room? */
  if (GET_ROOM_SPEC(ch->in_room) != NULL)
    if (GET_ROOM_SPEC(ch->in_room) (ch, world + ch->in_room, cmd, arg))
      return 1;

  /* special in equipment list? */
  for (j = 0; j < NUM_WEARS; j++)
    if (GET_EQ(ch, j) && GET_OBJ_SPEC(GET_EQ(ch, j)) != NULL)
      if (GET_OBJ_SPEC(GET_EQ(ch, j)) (ch, GET_EQ(ch, j), cmd, arg))
	return 1;

  /* special in inventory? */
  for (i = ch->carrying; i; i = i->next_content)
    if (GET_OBJ_SPEC(i) != NULL)
      if (GET_OBJ_SPEC(i) (ch, i, cmd, arg))
	return 1;

  /* special in mobile present? */
  for (k = world[ch->in_room].people; k; k = k->next_in_room)
    if (GET_MOB_SPEC(k) != NULL)
      if (GET_MOB_SPEC(k) (ch, k, cmd, arg))
	return 1;

  /* special in object present? */
  for (i = world[ch->in_room].contents; i; i = i->next_content)
    if (GET_OBJ_SPEC(i) != NULL)
      if (GET_OBJ_SPEC(i) (ch, i, cmd, arg))
	return 1;

  return 0;
}



/* *************************************************************************
*  Stuff for controlling the non-playing sockets (get name, pwd etc)       *
************************************************************************* */


/* locate entry in p_table with entry->name == name. -1 mrks failed search */
int find_name(char *name)
{
  int i;

  for (i = 0; i <= top_of_p_table; i++) {
    if (!player_table[i].name)
      continue;
    if (!str_cmp((player_table + i)->name, name))
      return i;
  }

  return -1;
}


int _parse_name(char *arg, char *name)
{
  int i;

  /* skip whitespaces and non-alpha characters at beginning of name */
  for (; isspace(*arg) || !isalpha(*arg); arg++);

  for (i = 0; (*name = *arg); arg++, i++, name++)
    if (!isalpha(*arg) && *arg != '-' && *arg != '\'')
      return 1;

  if (!i)
    return 1;

  return 0;
}


#define RECON		1
#define USURP		2
#define UNSWITCH	3

int perform_dupe_check(struct descriptor_data *d)
{
  struct descriptor_data *k, *next_k, *i;
  struct char_data *target = NULL, *ch, *next_ch;
  int mode = 0;

  int id = GET_IDNUM(d->character);

  /*
   * Now that this descriptor has successfully logged in, disconnect all
   * other descriptors controlling a character with the same ID number.
   */

  for (k = descriptor_list; k; k = next_k) {
    next_k = k->next;

    if (k == d)
      continue;

    if (k->original && (GET_IDNUM(k->original) == id)) {    /* switched char */
      SEND_TO_Q("\r\nMultiple login detected -- disconnecting.\r\n", k);
      STATE(k) = CON_CLOSE;
      if (!target) {
	target = k->original;
	mode = UNSWITCH;
      }
      if (k->character)
	k->character->desc = NULL;
      k->character = NULL;
      k->original = NULL;
    } else if (k->character && (GET_IDNUM(k->character) == id)) {
      if (!target && STATE(k) == CON_PLAYING) {
	SEND_TO_Q("\r\nThis body has been usurped!\r\n", k);
	target = k->character;
	mode = USURP;
      }
      k->character->desc = NULL;
      k->character = NULL;
      k->original = NULL;
      SEND_TO_Q("\r\nMultiple login detected -- disconnecting.\r\n", k);
      STATE(k) = CON_CLOSE;
    }
  }

 /*
  * now, go through the character list, deleting all characters that
  * are not already marked for deletion from the above step (i.e., in the
  * CON_HANGUP state), and have not already been selected as a target for
  * switching into.  In addition, if we haven't already found a target,
  * choose one if one is available (while still deleting the other
  * duplicates, though theoretically none should be able to exist).
  */

  if (isbanned(d->host) == BAN_MULTI)
    for (i = descriptor_list; i; i = i->next) {
     if (d==i) continue;
     if (STATE(i)) continue;
     if (!str_cmp(i->host, d->host)) {
       printf(buf, "Request for new char %s denied from [%s] (siteban)",
              GET_NAME(d->character), d->host);
       mudlog(buf, NRM, LVL_GOD, TRUE);
       SEND_TO_Q("&+cSorry, your site is only allowed 1 login at a time.\r\n", d);
       STATE(d) = CON_CLOSE;
       return 1;
     }
    }

  for (ch = character_list; ch; ch = next_ch) {
    next_ch = ch->next;

    if (IS_NPC(ch))
      continue;
    if (GET_IDNUM(ch) != id)
      continue;

    /* ignore chars with descriptors (already handled by above step) */
    if (ch->desc)
      continue;

    /* don't extract the target char we've found one already */
    if (ch == target)
      continue;

    /* we don't already have a target and found a candidate for switching */
    if (!target) {
      target = ch;
      mode = RECON;
      continue;
    }

    /* we've found a duplicate - blow him away, dumping his eq in limbo. */
    if (ch->in_room != NOWHERE)
      char_from_room(ch);
    char_to_room(ch, 1);
    extract_char(ch);
  }

  /* no target for swicthing into was found - allow login to continue */
  if (!target)
    return 0;

  /* Okay, we've found a target.  Connect d to target. */
  free_char(d->character); /* get rid of the old char */
  d->character = target;
  d->character->desc = d;
  d->original = NULL;
  d->character->char_specials.timer = 0;
  REMOVE_BIT(PLR_FLAGS(d->character), PLR_MAILING | PLR_WRITING);
  STATE(d) = CON_PLAYING;
  SET_BIT(PLR_FLAGS(d->character), PLR_PLAYING);

  switch (mode) {
  case RECON:
    SEND_TO_Q("Reconnecting.\r\n", d);
    act("$n has reconnected.", TRUE, d->character, 0, 0, TO_ROOM);
    if (GET_INVIS_LEV(d->character))
      sprintf(buf, "%s [%s] has reconnected. (i%d)", GET_NAME(d->character), 
              d->host, GET_INVIS_LEV(d->character));
    else
      sprintf(buf, "%s [%s] has reconnected.", GET_NAME(d->character), d->host);
    mudlog(buf, NRM, MAX(LVL_IMMORT, GET_INVIS_LEV(d->character)), TRUE);
    break;
  case USURP:
    SEND_TO_Q("You take over your own body, already in use!\r\n", d);
    act("$n suddenly keels over in pain, surrounded by a white aura...\r\n"
	"$n's body has been taken over by a new spirit!",
	TRUE, d->character, 0, 0, TO_ROOM);
    sprintf(buf, "%s has re-logged in ... disconnecting old socket.",
	    GET_NAME(d->character));
    mudlog(buf, NRM, MAX(LVL_IMMORT, GET_INVIS_LEV(d->character)), TRUE);
    break;
  case UNSWITCH:
    SEND_TO_Q("Reconnecting to unswitched char.", d);
    sprintf(buf, "%s [%s] has reconnected.", GET_NAME(d->character), d->host);
    mudlog(buf, NRM, MAX(LVL_IMMORT, GET_INVIS_LEV(d->character)), TRUE);
    break;
  }

  return 1;
}



/* deal with newcomers and other non-playing sockets */
void nanny(struct descriptor_data *d, char *arg)
{
  char buf[128], buf2[128];
  int player_i, load_result, numppl;
  char tmp_name[MAX_INPUT_LENGTH];
  struct char_file_u tmp_store;
  struct descriptor_data *i;
  struct char_data *tch;
  extern struct descriptor_data *descriptor_list;
  extern sh_int r_mortal_start_room;
  extern sh_int r_newbie_start_room;
  extern sh_int r_immort_start_room;
  extern sh_int r_frozen_start_room;
/*  extern const char *class_menu[];*/
  extern const char *race_menu;
  extern const char *race_info;
  extern int max_bad_pws;
  sh_int load_room;
  /*struct mail_index_element *mail_e;*/
  extern char *GREETINGS;
  extern char *GREETINGS2;
  time_t llog;

  int load_char(char *name, struct char_file_u *char_element,
	struct char_data *ch);
  int parse_class(char arg);
  int parse_race(char arg);

  skip_spaces(&arg);

  switch (STATE(d)) {
  case CON_GET_NAME:		/* wait for input of name */
    if (!*arg)
      close_socket(d);
    else {
      if ((_parse_name(arg, tmp_name)) || strlen(tmp_name) < 2 ||
	  strlen(tmp_name) > MAX_NAME_LENGTH ||
	  fill_word(strcpy(buf, tmp_name)) || reserved_word(buf)) {
	SEND_TO_Q("&+cInvalid name, please try another.\r\n"
		  "Name: ", d);
	return;
      }
      reset_char(d->character);
      if ((player_i = load_char(tmp_name, &tmp_store, d->character)) > -1) {
	store_to_char(&tmp_store, d->character);
	GET_PFILEPOS(d->character) = player_i;

      if (PLR_FLAGGED(d->character, PLR_BANNED)) {
        SEND_TO_Q("Your character is banned.\r\n", d);
        STATE(d) = CON_CLOSE;
        return;
      }
    if (PLR_FLAGGED(d->character, PLR_DELETED) && PLR_FLAGGED(d->character, PLR_NODELETE))
       REMOVE_BIT(PLR_FLAGS(d->character), PLR_DELETED);
    if (player_i < 0 || (PLR_FLAGGED(d->character, PLR_DELETED) &&
      GET_IDNUM(d->character) != 1)) {
	  free_char(d->character);
	  CREATE(d->character, struct char_data, 1);
	  clear_char(d->character);
	  CREATE(d->character->player_specials, struct player_special_data, 1);
	  d->character->desc = d;
	  CREATE(d->character->player.name, char, strlen(tmp_name) + 1);
	  strcpy(d->character->player.name, CAP(tmp_name));
	  GET_PFILEPOS(d->character) = player_i;
	  sprintf(buf, "&+cDid I get that right, %s (Y/N)? &+B", tmp_name);
	  SEND_TO_Q(buf, d);
	  STATE(d) = CON_NAME_CNFRM;
	} else {
	  /* undo it just in case they are set */
	  REMOVE_BIT(PLR_FLAGS(d->character),
		     PLR_WRITING | PLR_MAILING);

	  echo_off(d);
	  SEND_TO_Q("&+cPassword: ", d);
	  d->idle_tics = 0;
	  STATE(d) = CON_PASSWORD;
	}
      } else {
	/* player unknown -- make new character */

	if (!Valid_Name(tmp_name)) {
	  SEND_TO_Q("Invalid name, please try another.\r\n", d);
	  SEND_TO_Q("Name: ", d);
	  return;
	}
	CREATE(d->character->player.name, char, strlen(tmp_name) + 1);
	strcpy(d->character->player.name, CAP(tmp_name));

	sprintf(buf, "&+cDid I get that right, %s (Y/N)? &+B", tmp_name);
	SEND_TO_Q(buf, d);
	STATE(d) = CON_NAME_CNFRM;
      }
    }
    break;
  case CON_NAME_CNFRM:		/* wait for conf. of new name    */
    if (UPPER(*arg) == 'Y') {
      if (isbanned(d->host) == BAN_MULTI)
        for (i = descriptor_list; i; i = i->next) {
         if (d==i) continue;
         if (STATE(i)) continue;
         if (!str_cmp(i->host, d->host)) {
 	  sprintf(buf, "Request for new char %s denied from [%s] (siteban)",
	   	  GET_NAME(d->character), d->host);
	  mudlog(buf, NRM, LVL_GOD, TRUE);
          SEND_TO_Q("&+cSorry, your site is only allowed 1 login at a time.\r\n", d);
          STATE(d) = CON_CLOSE;
          return;
         }
        } 
      if ((isbanned(d->host) >= BAN_NEW) && isbanned(d->host) != BAN_MULTI) {
        if (isbanned(d->host) != BAN_SILENT) {
	  sprintf(buf, "Request for new char %s denied from [%s] (siteban)",
	  	  GET_NAME(d->character), d->host);
	  mudlog(buf, NRM, LVL_GOD, TRUE);
	}
	SEND_TO_Q("%+cSorry, new characters are not allowed from your site!\r\n", d);
	STATE(d) = CON_CLOSE;
	return;
      }
      if (mudrestrict) {
	SEND_TO_Q("&+cSorry, new players can't be created at the moment.\r\n", d);
	sprintf(buf, "Request for new char %s denied from %s (wizlock)",
		GET_NAME(d->character), d->host);
	mudlog(buf, NRM, LVL_GOD, TRUE);
	STATE(d) = CON_CLOSE;
	return;
      }
      echo_off(d);
      SEND_TO_Q("&+CNew character.\r\n", d);
      sprintf(buf, "&+cGive me a password for %s: ", GET_NAME(d->character));
      SEND_TO_Q(buf, d);
      STATE(d) = CON_NEWPASSWD;
    } else if (*arg == 'n' || *arg == 'N') {
      SEND_TO_Q("&+cOkay, what IS it, then? &+B", d);
      free(d->character->player.name);
      d->character->player.name = NULL;
      STATE(d) = CON_GET_NAME;
    } else {
      SEND_TO_Q("&+cPlease type Yes or No: &+B", d);
    }
    break;
  case CON_PASSWORD:		/* get pwd for known player      */
    /*
     * To really prevent duping correctly, the player's record should
     * be reloaded from disk at this point (after the password has been
     * typed).  However I'm afraid that trying to load a character over
     * an already loaded character is going to cause some problem down the
     * road that I can't see at the moment.  So to compensate, I'm going to
     * (1) add a 15 or 20-second time limit for entering a password, and (2)
     * re-add the code to cut off duplicates when a player quits.  JE 6 Feb 96
     */

    echo_on(d);    /* turn echo back on */

    if (!*arg)
      close_socket(d);
    else {
      if (strncmp(CRYPT(arg, GET_PASSWD(d->character)), GET_PASSWD(d->character), MAX_PWD_LENGTH)) {
	sprintf(buf, "Bad PW: %s [%s]", GET_NAME(d->character), d->host);
	mudlog(buf, BRF, LVL_GOD, TRUE);
	GET_BAD_PWS(d->character)++;
	save_char(d->character, NOWHERE);
	if (++(d->bad_pws) >= max_bad_pws) {	/* 3 strikes and you're out. */
	  SEND_TO_Q("&+RWrong password... disconnecting.\r\n", d);
	  STATE(d) = CON_CLOSE;
	} else {
	  echo_off(d);
	  SEND_TO_Q("&+RWrong password.\r\n&+cPassword: ", d);
	}
	return;
      }
      load_result = GET_BAD_PWS(d->character);
      GET_BAD_PWS(d->character) = 0;

     if ( (isbanned(d->host) == BAN_SELECT &&
	  !PLR_FLAGGED(d->character, PLR_SITEOK)) ||
          PLR_FLAGGED(d->character, PLR_BANNED) ) {
	SEND_TO_Q("&+cSorry, this char has not been cleared for login from your site!\r\n", d);
	STATE(d) = CON_CLOSE;
	sprintf(buf, "Connection attempt for %s denied from %s",
		GET_NAME(d->character), d->host);
	mudlog(buf, NRM, LVL_GOD, TRUE);
	return;
      }
      if (GET_LEVEL(d->character) < mudrestrict) {
	SEND_TO_Q("&+WThe game is temporarily restricted.. try again later.\r\n", d);
	STATE(d) = CON_CLOSE;
	sprintf(buf, "Request for login denied for %s [%s] (wizlock)",
		GET_NAME(d->character), d->host);
	mudlog(buf, NRM, LVL_GOD, TRUE);
	return;
      }
      /* check and make sure no other copies of this player are logged in */
      if (perform_dupe_check(d))
	return;
      if (isbanned(d->host) == BAN_MULTI)
        for (i = descriptor_list; i; i = i->next) {
         if (d==i) continue;
         if (STATE(i)) continue;
         if (!str_cmp(i->host, d->host)) {
 	  sprintf(buf, "Request for 2nd char %s denied from [%s] {%s} (siteban)",
	   	  GET_NAME(d->character), d->host, i->host);
	  mudlog(buf, NRM, LVL_GOD, TRUE);
          SEND_TO_Q("&+cSorry, your site is only allowed 1 login at a time.\r\n", d);
          STATE(d) = CON_CLOSE;
          return;
         }
        } 

      if (GET_LEVEL(d->character) >= LVL_IMMORT)
	SEND_TO_Q(imotd, d);
      else
	SEND_TO_Q(motd, d);

      if (PLR_FLAGGED(d->character, PLR_INVSTART))
	GET_INVIS_LEV(d->character) = GET_LEVEL(d->character);
      if (PLR_FLAGGED(d->character, PLR_ELDER))
        GET_INVIS_LEV(d->character) = GET_LEVEL(d->character);

      sprintf(buf, "%s [%s] has connected.", GET_NAME(d->character), d->host);

      if(d->dns_is_cached) /* dnsmod */
	strcat(buf, " (cache)");

      mudlog(buf, BRF, MAX(LVL_IMMORT, GET_INVIS_LEV(d->character)), TRUE);

      if (load_result) {
	sprintf(buf, "\r\n\r\n\007\007\007"
		"%s%d LOGIN FAILURE%s SINCE LAST SUCCESSFUL LOGIN.%s\r\n",
		CCRED(d->character, C_SPR), load_result,
		(load_result > 1) ? "S" : "", CCNRM(d->character, C_SPR));
	SEND_TO_Q(buf, d);
	GET_BAD_PWS(d->character) = 0;
      }
      SEND_TO_Q("\r\n\n&+c*** PRESS RETURN: ", d);
      STATE(d) = CON_RMOTD;
    }
    break;

  case CON_NEWPASSWD:
  case CON_CHPWD_GETNEW:
    if (!*arg || strlen(arg) > MAX_PWD_LENGTH || strlen(arg) < 3 ||
	!str_cmp(arg, GET_NAME(d->character))) {
      SEND_TO_Q("\r\n&+CIllegal password.\r\n", d);
      SEND_TO_Q("&+cPassword: ", d);
      return;
    }
    strncpy(GET_PASSWD(d->character), CRYPT(arg, GET_NAME(d->character)), MAX_PWD_LENGTH);
    *(GET_PASSWD(d->character) + MAX_PWD_LENGTH) = '\0';

    SEND_TO_Q("\r\n&+cPlease retype password: ", d);
    if (STATE(d) == CON_NEWPASSWD)
      STATE(d) = CON_CNFPASSWD;
    else
      STATE(d) = CON_CHPWD_VRFY;

    break;

  case CON_CNFPASSWD:
  case CON_CHPWD_VRFY:
    if (strncmp(CRYPT(arg, GET_PASSWD(d->character)), GET_PASSWD(d->character),
		MAX_PWD_LENGTH)) {
      SEND_TO_Q("\r\n&+cPasswords don't match... start over.\r\n", d);
      SEND_TO_Q("&+cPassword: ", d);
      if (STATE(d) == CON_CNFPASSWD)
	STATE(d) = CON_NEWPASSWD;
      else
	STATE(d) = CON_CHPWD_GETNEW;
      return;
    }
    echo_on(d);

    if (STATE(d) == CON_CNFPASSWD) {
      SEND_TO_Q("&+cWhat is your sex (M/F)? &+B", d);
      STATE(d) = CON_QSEX;
    } else {
      save_char(d->character, NOWHERE);
      echo_on(d);
      SEND_TO_Q("\r\n&+cDone.\n\r", d);
      SEND_TO_Q(MENU, d);
      STATE(d) = CON_MENU;
    }

    break;

  case CON_QSEX:		/* query sex of new user         */
    switch (*arg) {
    case 'm':
    case 'M':
      d->character->player.sex = SEX_MALE;
      break;
    case 'f':
    case 'F':
      d->character->player.sex = SEX_FEMALE;
      break;
    default:
      SEND_TO_Q("&+cThat is not a sex..\r\n"
		"What IS your sex? &+B", d);
      return;
      break;
    }

     /* KAKO */
    /*SEND_TO_Q(race_info, d);*/
    SEND_TO_Q(race_menu, d);
    /*SEND_TO_Q("\r\n&+cRace: &+B", d);*/
    STATE(d) = CON_QRACE;
    break;

  case CON_QRACE:
    if(*arg == '?') {
      SEND_TO_Q(race_info, d);
      return;
    }
    if ((GET_RACE(d->character) = parse_race(*arg)) == RACE_UNDEFINED) {
      /*SEND_TO_Q("\r\n&+cThat's not a race.\r\nRace: &+B", d);*/
      SEND_TO_Q(race_menu, d);
      return;
    }

    GET_CLASS(d->character) = CLASS_NEWBIE; /* dwix */
/*  SEND_TO_Q(class_menu[(int)GET_RACE(d->character)], d);
    SEND_TO_Q("\r\n&+cClass: &+B", d);
    STATE(d) = CON_QCLASS;
    break;

  case CON_QCLASS:
**    KAKO    **
    if ((GET_CLASS(d->character) = parse_class(*arg)) == CLASS_UNDEFINED) {
      SEND_TO_Q("\r\n&+cThat's not a class.\r\nClass: &+B", d);
      return;
    }
    if (!valid_race((int)GET_RACE(d->character), (int)GET_CLASS(d->character))) {
      SEND_TO_Q("\r\n&+cYour race cannot be that class.\r\nClass: &+B", d);
      return;
    } */

    roll_real_abils(d->character);
    SEND_TO_Q("&+cYour stats:\r\n", d);
    sprintf(buf, "STR: %d/%d, INT: %d, WIS: %d, DEX: %d, CON: %d, CHA: %d\r\n", 
	GET_STR(d->character), GET_ADD(d->character), GET_INT(d->character),
	GET_WIS(d->character), GET_DEX(d->character), GET_CON(d->character),
	GET_CHA(d->character));
    SEND_TO_Q(buf, d);
    SEND_TO_Q("Do you wish to reroll?(Y/N) &+B", d);
    STATE(d) = CON_QROLLS;
    break;

  case CON_QROLLS:
    if (UPPER(*arg) == 'Y') {
     roll_real_abils(d->character);
     SEND_TO_Q("&+cYour stats:\r\n", d);
     sprintf(buf, "STR: %d/%d, INT: %d, WIS: %d, DEX: %d, CON: %d, CHA: %d\r\n", 
	 GET_STR(d->character), GET_ADD(d->character), GET_INT(d->character),
	 GET_WIS(d->character), GET_DEX(d->character), GET_CON(d->character),
	 GET_CHA(d->character));
     SEND_TO_Q(buf, d);
     SEND_TO_Q("Do you wish to reroll?(Y/N) &+B", d);
     STATE(d) = CON_QROLLS;
     return;
    }      

      /* End of KAKO's Stuff */
    if (GET_PFILEPOS(d->character) < 0)
      GET_PFILEPOS(d->character) = create_entry(GET_NAME(d->character));
    init_char(d->character);
    remove_player(GET_IDNUM(d->character), FALSE);
    save_char(d->character, NOWHERE);
    save_player_index();
    SEND_TO_Q(motd, d);
    SEND_TO_Q("\r\n\n&+c*** PRESS RETURN: ", d);
    STATE(d) = CON_RMOTD;

    sprintf(buf, "%s [%s] new player.", GET_NAME(d->character), d->host);
    mudlog(buf, NRM, LVL_IMMORT, TRUE);
    GET_CLAN(d->character) = CLAN_NONE;
    reset_zone(newbie_zone);
    load_room = r_newbie_start_room;
    break;

  case CON_RMOTD:		/* read CR after printing motd   */
    SEND_TO_Q(MENU, d);
    STATE(d) = CON_MENU;
    break;

  case CON_MENU:		/* get selection from main menu  */
    switch (*arg) {
    case '0':
      close_socket(d);
      break;

    case '1':
      reset_char(d->character);
      if (PLR_FLAGGED(d->character, PLR_INVSTART))
	GET_INVIS_LEV(d->character) = GET_LEVEL(d->character);
      load_result = PLR_FLAGGED(d->character, PLR_PLAYING);
      /*if ((load_result = Crash_load(d->character)))
	d->character->in_room = NOWHERE;*/
	
      if(!load_rent(d->character))
	sprintf(buf2, "%s entering game with no equipment.", GET_NAME(d->character));
      else
	sprintf(buf2, "%s unrenting and entering the game.", GET_NAME(d->character));
      if (GET_INVIS_LEV(d->character)) {
        sprintf(buf, " (i%d)", GET_INVIS_LEV(d->character));
        strcat(buf2, buf);
      }
      mudlog(buf2, NRM, MAX(LVL_IMMORT, GET_INVIS_LEV(d->character)), TRUE);
      llog = tmp_store.last_logon;
      save_char(d->character, NOWHERE);
      send_to_char(WELC_MESSG, d->character);
      d->character->next = character_list;
      character_list = d->character;

      if ((load_room = GET_LOADROOM(d->character)) != NOWHERE)
	load_room = real_room(load_room);

      /* If char was saved with NOWHERE, or real_room above failed... */
      if (load_room == NOWHERE) {
	if (GET_LEVEL(d->character) >= LVL_IMMORT) {
	  load_room = r_immort_start_room;
	} else {
	  load_room = r_mortal_start_room;
	}
      }

      if (d->character->player.pagesize < 3)
        d->character->player.pagesize = 24;
      if (PLR_FLAGGED(d->character, PLR_FROZEN))
	load_room = r_frozen_start_room;
      if (GET_LEVEL(d->character) < LVL_IMMORT && load_result == 1) {
        if (load_room != r_frozen_start_room) 
  	  load_room = r_mortal_start_room; 
      }
      char_to_room(d->character, load_room);
      act("$n has entered the game.", TRUE, d->character, 0, 0, TO_ROOM);
      if ( (load_result == 1) /* && (GET_HIT(d->character) > 1) */) {
        GET_HIT(d->character) = GET_MAX_HIT(d->character);
        GET_MANA(d->character) = GET_MAX_MANA(d->character);
        GET_MOVE(d->character) = GET_MAX_MOVE(d->character);
        send_to_char("You have been fully healed by someone!\r\n", 
                      d->character);
      }
      STATE(d) = CON_PLAYING;
      SET_BIT(PLR_FLAGS(d->character), PLR_PLAYING);
      d->character->quitting = FALSE;
      if (!GET_LEVEL(d->character)) {
	char_from_room(d->character);
	char_to_room(d->character, r_newbie_start_room);
	do_start(d->character);
	send_to_char(START_MESSG, d->character);
        send_to_char("&+YPlease type POLICY for mud rules.\r\n", d->character);
	look_at_room(d->character, 0);
      }
      else
	look_at_room(d->character, 0);
      if(load_mail(d->character))
	check_mail_status(d->character);
/*      if((mail_e = find_mail(GET_IDNUM(d->character)))) {
	if(IS_SET(mail_e->flags, MI_HAS_NEW))
	  send_to_char("&+GYou have new mail waiting.\r\n", d->character);
	if(IS_SET(mail_e->flags, MI_FULL))
	  send_to_char("&+RYour mailbox is full!  Better clean it out.\r\n",
	    d->character);
	else if(IS_SET(mail_e->flags, MI_BIG))
	  send_to_char("&+YYour mailbox is almost full!\r\n", d->character);
	load_mail(GET_IDNUM(d->character));
      }
*/
      if (PRF2_FLAGGED(d->character, PRF2_BD_CHK))
        Board_last_msg(d->character, tmp_store.last_logon);
      /*if (load_result == 2) {   * rented items lost *
	send_to_char("\r\n\007You could not afford your rent!\r\n"
	     "Your possesions have been donated to the Salvation Army!\r\n",
		     d->character);
      }*/
      d->prompt_mode = 1;
      if (IS_BARD(d->character) && GET_CHA(d->character)>GET_CON(d->character)) {
        numppl = GET_CHA(d->character);
        GET_CHA(d->character) = GET_CON(d->character);
        GET_CON(d->character) = numppl;
      }

      if(GET_RACE(d->character) == RACE_GARGOYLE && weather_info.sunlight
	== SUN_DARK) {
	GET_STR(d->character) += 2;
	GET_DEX(d->character) += 2;
	GET_CON(d->character) += 2;
      }

      if (!PLR_FLAGGED(d->character, PLR_LOADROOM))
	SET_BIT(PLR_FLAGS(d->character), PLR_LOADROOM);
	/* debugmod - GtG */
      if (GET_LEVEL(d->character) > LVL_SIMP) {
        sprintf(buf, "SYSERROR: %s is level %d", GET_NAME(d->character),
                 GET_LEVEL(d->character));
        mudlog(buf, BRF, LVL_IMPL, FALSE);
        GET_LEVEL(d->character) = LVL_DEMI;
      }
       if (GET_INVIS_LEV(d->character) > GET_LEVEL(d->character))
         GET_INVIS_LEV(d->character) = 0;
      /* end of debugmod - GtG */
      if (PLR_FLAGGED(d->character, PLR_AFK)) 
        REMOVE_BIT(PLR_FLAGS(d->character), PLR_AFK);
      update_wholist(d->character->char_specials.saved.idnum);
      break;

    case '2':
      SEND_TO_Q("&+cEnter the text you'd like others to see when they look at you.\r\n", d);
      SEND_TO_Q("&+c(-s saves -h for help)\r\n", d);
      if (d->character->player.description) {
	SEND_TO_Q("Current description:\r\n", d);
	SEND_TO_Q(d->character->player.description, d);
	/* free(d->character->player.description); 
	d->character->player.description = NULL; */
	d->backstr = str_dup(d->character->player.description);
      }
      d->str = &d->character->player.description;
      d->max_str = EXDSCR_LENGTH;
      STATE(d) = CON_EXDESC;
      break;

    case '3':
      SEND_TO_Q("&+c", d);
      page_string(d, background, 0);
      STATE(d) = CON_RMOTD;
      break;

    case '4':
      echo_off(d);
      SEND_TO_Q("\r\n&+cEnter your old password: ", d);
      STATE(d) = CON_CHPWD_GETOLD;
      break;

    case '5':
      echo_off(d);
      SEND_TO_Q("\r\n&+cEnter your password for verification: ", d);
      STATE(d) = CON_DELCNF1;
      break;
    
    case 'G':
      *buf = '\0'; numppl = 0;
      if (!d) {
        sprintf(buf, "SYSERR: no descriptor d in main menu opt 6 (1)\r\n");
        mudlog(buf, BRF, LVL_SIMP, TRUE);
        break;
      }
      for (i=descriptor_list; i; i = i->next)  {
        if (i->connected)
          continue;
        if (i->original)
          tch = i->original;
        else if (!(tch = i->character))
          continue;
        if (GET_LEVEL(d->character) < GET_INVIS_LEV(tch))
          continue;
        if (!IS_IMMORTAL(d->character) && (IS_AFFECTED(tch, AFF_HIDE) ||
            IS_AFFECTED(tch, AFF_INVISIBLE)))
          continue;
        if (GET_LEVEL(tch)>=LVL_IMMORT) 
          sprintf(buf2, " Immortal ");
        else
          sprintf(buf2, "%3d %s-%s ", GET_LEVEL(tch), RACE_ABBR(tch), 
                 CLASS_ABBR(tch));
        sprintf(buf, "%s%s[%s] %s %s\r\n", buf, 
                IS_IMMORTAL(tch) ? "&+g" : "&+m", buf2, 
                GET_NAME(tch), PLR_FLAGGED(tch, PLR_AFK) ? "&+R(AFK)" : "");
        numppl++;
      }
      if (!d) {
        sprintf(buf, "SYSERR: no descriptor d in main menu opt 6 (2)\r\n");
        mudlog(buf, BRF, LVL_SIMP, TRUE);
        break;
      }
      SEND_TO_Q("Who's on NoMUD:\r\n", d);
      if (numppl) 
        SEND_TO_Q(buf, d);
      else 
        SEND_TO_Q("&+y[ mob ] the beastly fido\r\n", d);
      SEND_TO_Q("\r\n&+w*** PRESS RETURN: ", d);
      STATE(d) = CON_RMOTD;
      break; 
    default:
      SEND_TO_Q("\r\n&+CThat's not a menu choice!\r\n", d);
      SEND_TO_Q(MENU, d);
      break;
    }

    break;

  case CON_CHPWD_GETOLD:
    if (strncmp(CRYPT(arg, GET_PASSWD(d->character)), GET_PASSWD(d->character), MAX_PWD_LENGTH)) {
      echo_on(d);
      SEND_TO_Q("\r\n&+RIncorrect password.\r\n", d);
      SEND_TO_Q(MENU, d);
      STATE(d) = CON_MENU;
      return;
    } else {
      SEND_TO_Q("\r\n&+cEnter a new password: ", d);
      STATE(d) = CON_CHPWD_GETNEW;
      return;
    }
    break;

  case CON_DELCNF1:
    echo_on(d);
    if (strncmp(CRYPT(arg, GET_PASSWD(d->character)), GET_PASSWD(d->character), MAX_PWD_LENGTH)) {
      SEND_TO_Q("\r\n&+RIncorrect password.\r\n", d);
      SEND_TO_Q(MENU, d);
      STATE(d) = CON_MENU;
    } else {
      SEND_TO_Q("\r\n&+RYOU ARE ABOUT TO DELETE THIS CHARACTER PERMANENTLY.\r\n"
		"ARE YOU ABSOLUTELY SURE?\r\n\r\n"
		"Please type \"yes\" to confirm: ", d);
      STATE(d) = CON_DELCNF2;
    }
    break;

  case CON_DELCNF2:
    if (!strcmp(arg, "yes") || !strcmp(arg, "YES")) {
      if (PLR_FLAGGED(d->character, PLR_FROZEN)) {
	SEND_TO_Q("&+cYou try to kill yourself, but the ice stops you.\r\n", d);
	SEND_TO_Q("Character not deleted.\r\n\r\n", d);
	STATE(d) = CON_CLOSE;
	return;
      }
      if (GET_LEVEL(d->character) < LVL_GRGOD)
	SET_BIT(PLR_FLAGS(d->character), PLR_DELETED);
      save_char(d->character, NOWHERE);
      Crash_delete_file(GET_NAME(d->character));
      get_filename(GET_NAME(d->character), buf, SAVES_FILE);
      remove(buf);
      sprintf(buf, "Character '%s' deleted!\r\n"
	      "Goodbye.\r\n", GET_NAME(d->character));
      SEND_TO_Q(buf, d);
      sprintf(buf, "%s (lev %d) has self-deleted.", GET_NAME(d->character),
	      GET_LEVEL(d->character));
      mudlog(buf, NRM, LVL_GOD, TRUE);
      STATE(d) = CON_CLOSE;
      return;
    } else {
      SEND_TO_Q("\r\nCharacter not deleted.\r\n", d);
      SEND_TO_Q(MENU, d);
      STATE(d) = CON_MENU;
    }
    break;

  case CON_CLOSE:
    close_socket(d);
    break;

  case CON_MAIL_SUBJ:
    d->subj = str_dup(arg);
    STATE(d) = CON_PLAYING;
    SET_BIT(PLR_FLAGS(d->character), PLR_PLAYING);
    send_to_char("Write your message.  (-s saves -h for help)\r\n",
      d->character);
    SET_BIT(PLR_FLAGS(d->character), PLR_MAILING | PLR_WRITING);
    break;

  case CON_QANSI:
    if (d->character == NULL) {
      CREATE(d->character, struct char_data, 1);
      clear_char(d->character);
      CREATE(d->character->player_specials, struct player_special_data, 1);
      d->character->desc = d;
    }
    if(LOWER(*arg) != 'n')
      SET_BIT(PRF_FLAGS(d->character), PRF_COLOR_1 | PRF_COLOR_2);

    if (greetswitch == 1) {
      SEND_TO_Q(GREETINGS, d);
      greetswitch = 2;
    } else {
      SEND_TO_Q(GREETINGS2, d);
      greetswitch = 1;
    }

    STATE(d) = CON_GET_NAME;
    break;

  default:
    nmlog("SYSERR: Nanny: illegal state of con'ness; closing connection");
    close_socket(d);
    break;
  }
}



/* check player for a special parser function pointer and call it if
   it exists  *1.0* */ /*menumod*/
int check_spec_parser(struct descriptor_data *d, char *inp)
{
  struct char_player_data *player;

  if(!d->character)
    return 0;

  player = &d->character->player;

  if(!player->parser)
    return 0;

  return( (player->parser) (d->character, player->parse_me, inp,
			    player->parse_data)			  );
}

void update_wholist(long newid)
{
  int found = FALSE;  
  struct wholist_entry *nnode = NULL, *current;
  
  for (current = wholist; current; current = current->next)
    if (current->idnum==newid) {
      found = TRUE;
      break;
    }
  if (!found) {
    CREATE(nnode, struct wholist_entry, 1);
    nnode->idnum = newid;
    nnode->next = wholist;
    wholist = nnode;
    wholist_total++;
  }
}
