/* ************************************************************************
*   File: magic.c                                       Part of CircleMUD *
*  Usage: low-level functions for magic; spell template code              *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */


#include "conf.h"
#include "sysdep.h"

#include "structs.h"
#include "utils.h"
#include "comm.h"
#include "spells.h"
#include "handler.h"
#include "db.h"

extern struct room_data *world;
extern struct obj_data *object_list;
extern struct char_data *character_list;
extern struct index_data *obj_index;

extern struct weather_data weather_info;
extern struct descriptor_data *descriptor_list;
extern struct zone_data *zone_table;

extern int mini_mud;
extern int pk_allowed;

extern struct default_mobile_stats *mob_defaults;
extern char weapon_verbs[];
extern int *max_ac_applys;
extern struct apply_mod_defaults *apmd;

void clearMemory(struct char_data * ch);
void act(char *str, int i, struct char_data * c, struct obj_data * o,
	      void *vict_obj, int j);

void damage(struct char_data * ch, struct char_data * victim,
	         int damage, int weapontype);

void weight_change_object(struct obj_data * obj, int weight);
void add_follower(struct char_data * ch, struct char_data * leader);
int dice(int number, int size);
extern struct spell_info_type spell_info[];


struct char_data *read_mobile(int, int);


/*
 * Saving throws for:
 * Newbie Mage Cleric Thief Warrior Pal Bard Ranger AP Monk
 *   PARA, ROD, PETRI, BREATH, SPELL
 *     Levels 0-100  Entered by Trebor 8/96
 */

const byte saving_throws[NUM_CLASSES][5][101] = {

  {                             /* Newbies */
             {99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  /*  0 - 10 */
/* PARA */    99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 11 - 20 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 21 - 30 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 31 - 40 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 41 - 50 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 51 - 60 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 61 - 70 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 71 - 80 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 81 - 90 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99},    /* 91 - 100 */

             {99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  /*  0 - 10 */
/* ROD */     99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 11 - 20 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 21 - 30 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 31 - 40 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 41 - 50 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 51 - 60 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 61 - 70 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 71 - 80 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 81 - 90 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99},    /* 91 - 100 */

             {99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,    /*  0 - 10 */
/* PETRI */   99, 99, 99, 99, 99, 99, 99, 99, 99, 99,         /* 11 - 20 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,         /* 21 - 30 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,         /* 31 - 40 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,         /* 41 - 50 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,         /* 51 - 60 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,         /* 61 - 70 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,         /* 71 - 80 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,         /* 81 - 90 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99},        /* 91 - 100 */

             {99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  /*  0 - 10 */
/* BREATH */  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 11 - 20 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 21 - 30 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 31 - 40 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 41 - 50 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 51 - 60 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 61 - 70 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 71 - 80 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 81 - 90 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99},    /* 91 - 100 */

             {99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  /*  0 - 10 */
/* SPELL */   99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 11 - 20 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 21 - 30 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 31 - 40 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 41 - 50 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 51 - 60 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 61 - 70 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 71 - 80 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99,      /* 81 - 90 */
              99, 99, 99, 99, 99, 99, 99, 99, 99, 99}     /* 91 - 100 */
},

{                             /* Mages */
              {90, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70,  /* 0 - 10 */
/* PARA */    69, 68, 67, 66, 65, 64, 63, 62, 61, 60,      /* 11 - 20 */
              59, 58, 57, 56, 55, 54, 53, 52, 51, 50,      /* 21 - 30 */
              49, 48, 47, 46, 45, 44, 43, 42, 41, 40,      /* 31 - 40 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,      /* 41 - 50 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 51 - 60 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 82, 79, 76, 73, 70, 67, 64, 61, 58, 55,   /* 0 - 10 */
/* ROD */     54, 53, 52, 51, 50, 49, 48, 47, 46, 45,      /* 11 - 20 */
              44, 43, 42, 41, 40, 39, 38, 37, 36, 35,      /* 21 - 30 */
              34, 33, 32, 31, 30, 29, 28, 27, 26, 25,      /* 31 - 40 */
              24, 23, 23, 21, 20, 19, 18, 17, 16, 15,      /* 41 - 50 */
              14, 13, 12, 11, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 9, 8, 7, 6, 5, 5, 5, 5, 5,               /* 71 - 80 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5,               /* 81 - 90 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5},             /* 91 - 100 */

             {90, 83, 81, 79, 77, 75, 73, 71, 69, 67, 65,  /* 0 - 10 */
/* PETRI */   64, 63, 62, 61, 60, 59, 58, 57, 56, 55,      /* 11 - 20 */
              54, 53, 52, 51, 50, 49, 48, 47, 46, 45,      /* 21 - 30 */
              44, 43, 42, 41, 40, 39, 38, 37, 36, 35,      /* 31 - 40 */
              34, 34, 33, 33, 32, 32, 31, 31, 30, 30,      /* 41 - 50 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 51 - 60 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 84, 83, 82, 81, 80, 79, 78, 77, 76, 75,  /*  0 - 10 */
/* BREATH */  74, 73, 72, 71, 70, 69, 68, 67, 66, 65,      /* 11 - 20 */
              64, 63, 62, 61, 60, 59, 58, 57, 56, 55,      /* 21 - 30 */
              54, 53, 52, 51, 50, 49, 48, 47, 46, 45,      /* 31 - 40 */
              44, 43, 42, 41, 40, 39, 38, 37, 36, 35,      /* 41 - 50 */
              34, 34, 33, 33, 32, 32, 31, 31, 30, 30,      /* 51 - 60 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 61 - 70 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 82, 80, 77, 75, 72, 70, 67, 65, 62, 60,  /*  0 - 10 */
/* SPELL */   59, 58, 57, 56, 55, 54, 53, 52, 51, 50,      /* 11 - 20 */
              49, 48, 47, 46, 45, 44, 43, 42, 41, 40,      /* 21 - 30 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,      /* 31 - 40 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 41 - 50 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 9, 8, 7, 6, 5, 5, 5, 5, 5,               /* 81 - 90 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5}              /* 91 - 100 */
  },

  {                             /* Clerics */
             {90, 80, 75, 70, 65, 60, 55, 50, 49, 48, 47,  /* 0 - 10 */
/* PARA */    46, 45, 43, 41, 39, 38, 36, 35, 34, 33,      /* 11 - 20 */
              32, 31, 30, 30, 29, 28, 27, 26, 26, 25,      /* 21 - 30 */
              24, 23, 22, 22, 21, 21, 20, 20, 20, 20,      /* 31 - 40 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 41 - 50 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 9, 8, 7, 6, 5, 5, 5, 5, 5,               /* 71 - 80 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5,               /* 81 - 90 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5},             /* 91 - 100 */

             {90, 80, 78, 76, 74, 72, 70, 69, 68, 67, 66,  /*  0 - 10 */
/* ROD */     65, 64, 63, 62, 61, 60, 59, 58, 57, 56,      /* 11 - 20 */
              55, 54, 53, 52, 51, 50, 49, 48, 47, 46,      /* 21 - 30 */
              45, 44, 43, 42, 41, 40, 39, 38, 37, 36,      /* 31 - 40 */
              35, 34, 33, 32, 31, 30, 29, 28, 27, 26,      /* 41 - 50 */
              25, 24, 23, 22, 21, 21, 20, 20, 20, 20,      /* 51 - 60 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 78, 75, 73, 70, 68, 65, 64, 63, 62, 61,  /* 0 - 10 */
/*PETRI */    60, 59, 58, 57, 56, 55, 54, 53, 52, 51,      /* 11 - 20 */
              50, 49, 48, 47, 46, 45, 44, 43, 42, 41,      /* 21 - 30 */
              40, 39, 38, 37, 36, 35, 34, 33, 32, 30,      /* 31 - 40 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 41 - 50 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

            {90, 85, 84, 83, 82, 81, 80, 79, 78, 77, 76,   /*  0 - 10 */
/*BREATH */   75, 74, 73, 72, 71, 70, 69, 68, 67, 66,      /* 11 - 20 */
              65, 64, 63, 62, 61, 60, 59, 58, 57, 56,      /* 21 - 30 */
              55, 54, 53, 52, 51, 50, 49, 48, 47, 46,      /* 31 - 40 */
              45, 44, 43, 42, 41, 40, 39, 38, 37, 36,      /* 41 - 50 */
              35, 34, 33, 33, 32, 32, 31, 31, 30, 30,      /* 51 - 60 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 61 - 70 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71,  /* 0 - 10 */
/* SPELL */   70, 69, 68, 67, 66, 65, 64, 63, 62, 61,      /* 11 - 20 */
              60, 59, 58, 57, 56, 55, 54, 53, 52, 51,      /* 21 - 30 */
              50, 49, 48, 47, 46, 45, 44, 43, 42, 40,      /* 31 - 40 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,      /* 41 - 50 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 51 - 60 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5}      /* 91 - 100 */
  },

  {                             /* Thieves */
             {90, 79, 77, 75, 73, 71, 69, 67, 66, 65, 64,  /*  0 - 10 */
/* PARA */    63, 63, 62, 61, 61, 60, 59, 59, 58, 57,      /* 11 - 20 */
              57, 56, 55, 55, 54, 53, 53, 52, 51, 51,      /* 21 - 30 */
              50, 49, 49, 48, 47, 47, 46, 45, 45, 44,      /* 31 - 40 */
              44, 44, 43, 43, 42, 42, 41, 41, 40, 40,      /* 41 - 50 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,      /* 51 - 60 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 61 - 70 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

              {90, 80, 79, 77, 76, 74, 73, 71, 70, 68, 67,  /* 0 - 10 */
/* ROD */     66, 65, 64, 63, 62, 60, 59, 57, 56, 55,       /* 11 - 20 */
              54, 53, 51, 50, 49, 47, 46, 45, 44, 42,       /* 21 - 30 */
              41, 40, 39, 38, 37, 35, 34, 33, 32, 30,       /* 31 - 40 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,       /* 41 - 50 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,       /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,       /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,       /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,       /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},      /* 91 - 100 */

              {90, 81, 78, 75, 72, 69, 66, 63, 60, 59, 58,  /* 0 - 10 */
/* PETRI */   58, 57, 57, 56, 56, 55, 54, 54, 53, 53,       /* 11 - 20 */
              52, 51, 51, 50, 49, 49, 48, 48, 47, 46,       /* 21 - 30 */
              46, 45, 45, 44, 43, 43, 42, 41, 41, 40,       /* 31 - 40 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,       /* 41 - 50 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,       /* 51 - 60 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,       /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,       /* 71 - 80 */
              10, 9, 8, 7, 6, 5, 5, 5, 5, 5,                /* 81 - 90 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5},              /* 91 - 100 */

              {90, 87, 86, 85, 84, 83, 82, 81, 80, 79, 79,  /*  0 - 10 */
/* BREATH */  78, 78, 77, 76, 76, 75, 74, 74, 73, 72,       /* 11 - 20 */
              72, 71, 71, 70, 69, 69, 68, 68, 67, 66,       /* 21 - 30 */
              66, 65, 64, 64, 63, 62, 62, 61, 61, 60,       /* 31 - 40 */
              59, 58, 57, 56, 55, 54, 53, 52, 51, 50,       /* 41 - 50 */
              49, 48, 47, 46, 45, 44, 43, 42, 41, 40,       /* 51 - 60 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,       /* 61 - 70 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,       /* 71 - 80 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,       /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},      /* 91 - 100 */

              {90, 83, 82, 81, 79, 78, 77, 76, 75, 74, 73,  /* 0 - 10 */
/* SPELL */   71, 70, 69, 67, 66, 65, 64, 63, 61, 60,       /* 11 - 20 */
              59, 57, 56, 55, 54, 53, 51, 50, 49, 47,       /* 21 - 30 */
              46, 45, 44, 43, 42, 40, 39, 38, 36, 35,       /* 31 - 40 */
              34, 33, 32, 31, 30, 29, 28, 27, 26, 25,       /* 41 - 50 */
              24, 23, 22, 21, 20, 19, 18, 17, 16, 15,       /* 51 - 60 */
              14, 13, 12, 11, 10, 10, 10, 10, 10, 10,       /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,       /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,       /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5}        /* 91 - 100 */
  },

  {                             /* Warriors */
             {90, 76, 74, 72, 70, 68, 66, 64, 62, 60, 58,  /*  0 - 10 */
/* PARA */    56, 54, 52, 50, 48, 47, 45, 43, 41, 40,      /* 11 - 20 */
              38, 37, 36, 35, 34, 33, 32, 31, 30, 29,      /* 21 - 30 */
              28, 27, 26, 25, 24, 23, 22, 21, 20, 19,      /* 31 - 40 */
              18, 17, 16, 15, 14, 13, 12, 11, 10, 10,      /* 41 - 50 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 83, 82, 81, 80, 79, 77, 76, 75, 73, 71,  /* 0 - 10 */
/* ROD */     69, 67, 65, 63, 61, 59, 57, 55, 53, 51,      /* 11 - 20 */
              49, 47, 45, 43, 41, 39, 37, 35, 34, 33,      /* 21 - 30 */
              32, 31, 30, 29, 28, 27, 26, 25, 24, 23,      /* 31 - 40 */
              22, 21, 20, 19, 18, 17, 16, 15, 14, 13,      /* 41 - 50 */
              12, 11, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 78, 77, 76, 75, 74, 72, 70, 68, 66, 64,  /*  0 - 10 */
/* PETRI */   62, 60, 59, 57, 56, 54, 52, 50, 48, 46,      /* 11 - 20 */
              44, 42, 40, 38, 36, 34, 32, 30, 29, 28,      /* 21 - 30 */
              27, 26, 25, 24, 23, 22, 21, 20, 19, 18,      /* 31 - 40 */
              17, 16, 15, 14, 13, 12, 11, 10, 10, 10,      /* 41 - 50 */
              12, 11, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 88, 87, 86, 85, 84, 82, 80, 78, 76, 74,  /*  0 - 10 */
/* BREATH */  72, 70, 68, 66, 64, 62, 60, 57, 54, 51,      /* 11 - 20 */
              48, 45, 42, 39, 36, 33, 30, 27, 25, 23,      /* 21 - 30 */
              21, 20, 19, 18, 17, 16, 15, 14, 13, 12,      /* 31 - 40 */
              11, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 41 - 50 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 9, 8, 7, 6, 5, 5, 5, 5, 5,               /* 71 - 80 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5,               /* 81 - 90 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5},             /* 91 - 100 */

             {90, 88, 87, 86, 85, 84, 82, 80, 78, 76, 74,  /* 0 - 10 */
/* SPELL */   72, 70, 69, 68, 66, 64, 62, 60, 58, 56,      /* 11 - 20 */
              54, 52, 50, 48, 46, 44, 42, 40, 39, 38,      /* 21 - 30 */
              37, 36, 35, 34, 33, 32, 31, 30, 29, 28,      /* 31 - 40 */
              27, 26, 25, 24, 23, 22, 21, 20, 19, 18,      /* 41 - 50 */
              17, 16, 15, 14, 13, 12, 11, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5}      /* 91 - 100 */
  },

  {                            /* Paladin */
             {90, 80, 75, 70, 65, 60, 55, 50, 49, 48, 47,  /*  0 - 10 */
/* PARA */    46, 45, 43, 41, 39, 38, 36, 35, 34, 33,      /* 11 - 20 */
              32, 31, 30, 30, 29, 28, 27, 26, 26, 25,      /* 21 - 30 */
              24, 23, 22, 22, 21, 21, 20, 20, 20, 20,      /* 31 - 40 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 41 - 50 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 9, 8, 7, 6, 5, 5, 5, 5, 5,               /* 71 - 80 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5,               /* 81 - 90 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5},             /* 91 - 100 */

             {90, 80, 78, 76, 74, 72, 70, 69, 68, 67, 66,  /* 0 - 10 */
/* ROD */     65, 64, 63, 62, 61, 60, 59, 58, 57, 56,      /* 11 - 20 */
              55, 54, 53, 52, 51, 50, 49, 48, 47, 46,      /* 21 - 30 */
              45, 44, 43, 42, 41, 40, 39, 38, 37, 36,      /* 31 - 40 */
              35, 34, 33, 32, 31, 30, 29, 28, 27, 26,      /* 41 - 50 */
              25, 24, 23, 22, 21, 21, 20, 20, 20, 20,      /* 51 - 60 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 78, 77, 76, 75, 74, 72, 70, 68, 66, 64,  /*  0 - 10 */
/* PETRI */   62, 60, 59, 57, 56, 54, 52, 50, 48, 46,      /* 11 - 20 */
              44, 42, 40, 38, 36, 34, 32, 30, 29, 28,      /* 21 - 30 */
              27, 26, 25, 24, 23, 22, 21, 20, 19, 18,      /* 31 - 40 */
              17, 16, 15, 14, 13, 12, 11, 10, 10, 10,      /* 41 - 50 */
              12, 11, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 88, 87, 86, 85, 84, 82, 80, 78, 76, 74,  /*  0 - 10 */
/* BREATH */  72, 70, 68, 66, 64, 62, 60, 57, 54, 51,      /* 11 - 20 */
              48, 45, 42, 39, 36, 33, 30, 27, 25, 23,      /* 21 - 30 */
              21, 20, 19, 18, 17, 16, 15, 14, 13, 12,      /* 31 - 40 */
              11, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 41 - 50 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 9, 8, 7, 6, 5, 5, 5, 5, 5,               /* 71 - 80 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5,               /* 81 - 90 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5},             /* 91 - 100 */

             {90, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71,  /* 0 - 10 */
/* SPELL */   70, 69, 68, 67, 66, 65, 64, 63, 62, 61,      /* 11 - 20 */
              60, 59, 58, 57, 56, 55, 54, 53, 52, 51,      /* 21 - 30 */
              50, 49, 48, 47, 46, 45, 44, 43, 42, 40,      /* 31 - 40 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,      /* 41 - 50 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 51 - 60 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5}      /* 91 - 100 */
  },

  {                             /* Bards */
             {90, 76, 74, 72, 70, 68, 66, 64, 62, 60, 58,  /*  0 - 10 */
/* PARA */    56, 54, 52, 50, 48, 47, 45, 43, 41, 40,      /* 11 - 20 */
              38, 37, 36, 35, 34, 33, 32, 31, 30, 29,      /* 21 - 30 */
              28, 27, 26, 25, 24, 23, 22, 21, 20, 19,      /* 31 - 40 */
              18, 17, 16, 15, 14, 13, 12, 11, 10, 10,      /* 41 - 50 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 83, 82, 81, 80, 79, 77, 76, 75, 73, 71,  /* 0 - 10 */
/* ROD */     69, 67, 65, 63, 61, 59, 57, 55, 53, 51,      /* 11 - 20 */
              49, 47, 45, 43, 41, 39, 37, 35, 34, 33,      /* 21 - 30 */
              32, 31, 30, 29, 28, 27, 26, 25, 24, 23,      /* 31 - 40 */
              22, 21, 20, 19, 18, 17, 16, 15, 14, 13,      /* 41 - 50 */
              12, 11, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 78, 77, 76, 75, 74, 72, 70, 68, 66, 64,  /*  0 - 10 */
/* PETRI */   62, 60, 59, 57, 56, 54, 52, 50, 48, 46,      /* 11 - 20 */
              44, 42, 40, 38, 36, 34, 32, 30, 29, 28,      /* 21 - 30 */
              27, 26, 25, 24, 23, 22, 21, 20, 19, 18,      /* 31 - 40 */
              17, 16, 15, 14, 13, 12, 11, 10, 10, 10,      /* 41 - 50 */
              12, 11, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 87, 86, 85, 84, 83, 82, 81, 80, 79, 79,  /*  0 - 10 */
/* BREATH */  78, 78, 77, 76, 76, 75, 74, 74, 73, 72,       /* 11 - 20 */
              72, 71, 71, 70, 69, 69, 68, 68, 67, 66,       /* 21 - 30 */
              66, 65, 64, 64, 63, 62, 62, 61, 61, 60,       /* 31 - 40 */
              59, 58, 57, 56, 55, 54, 53, 52, 51, 50,       /* 41 - 50 */
              49, 48, 47, 46, 45, 44, 43, 42, 41, 40,       /* 51 - 60 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,       /* 61 - 70 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,       /* 71 - 80 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,       /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},      /* 91 - 100 */

             {90, 88, 87, 86, 85, 84, 82, 80, 78, 76, 74,  /* 0 - 10 */
/* SPELL */   72, 70, 69, 68, 66, 64, 62, 60, 58, 56,      /* 11 - 20 */
              54, 52, 50, 48, 46, 44, 42, 40, 39, 38,      /* 21 - 30 */
              37, 36, 35, 34, 33, 32, 31, 30, 29, 28,      /* 31 - 40 */
              27, 26, 25, 24, 23, 22, 21, 20, 19, 18,      /* 41 - 50 */
              17, 16, 15, 14, 13, 12, 11, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5}      /* 91 - 100 */
  },

  {                         /* Anti-Paladins */
             {90, 79, 77, 75, 73, 71, 69, 67, 66, 65, 64,  /*  0 - 10 */
/* PARA */    63, 63, 62, 61, 61, 60, 59, 59, 58, 57,      /* 11 - 20 */
              57, 56, 55, 55, 54, 53, 53, 52, 51, 51,      /* 21 - 30 */
              50, 49, 49, 48, 47, 47, 46, 45, 45, 44,      /* 31 - 40 */
              44, 44, 43, 43, 42, 42, 41, 41, 40, 40,      /* 41 - 50 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,      /* 51 - 60 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 61 - 70 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 80, 79, 77, 76, 74, 73, 71, 70, 68, 67,  /* 0 - 10 */
/* ROD */     66, 65, 64, 63, 62, 60, 59, 57, 56, 55,      /* 11 - 20 */
              54, 53, 51, 50, 49, 47, 46, 45, 44, 42,      /* 21 - 30 */
              41, 40, 39, 38, 37, 35, 34, 33, 32, 30,      /* 31 - 40 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 41 - 50 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 78, 77, 76, 75, 74, 72, 70, 68, 66, 64,  /*  0 - 10 */
/* PETRI */   62, 60, 59, 57, 56, 54, 52, 50, 48, 46,      /* 11 - 20 */
              44, 42, 40, 38, 36, 34, 32, 30, 29, 28,      /* 21 - 30 */
              27, 26, 25, 24, 23, 22, 21, 20, 19, 18,      /* 31 - 40 */
              17, 16, 15, 14, 13, 12, 11, 10, 10, 10,      /* 41 - 50 */
              12, 11, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 87, 86, 85, 84, 83, 82, 81, 80, 79, 79,  /*  0 - 10 */
/* BREATH */  78, 78, 77, 76, 76, 75, 74, 74, 73, 72,      /* 11 - 20 */
              72, 71, 71, 70, 69, 69, 68, 68, 67, 66,      /* 21 - 30 */
              66, 65, 64, 64, 63, 62, 62, 61, 61, 60,      /* 31 - 40 */
              59, 58, 57, 56, 55, 54, 53, 52, 51, 50,      /* 41 - 50 */
              49, 48, 47, 46, 45, 44, 43, 42, 41, 40,      /* 51 - 60 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,      /* 61 - 70 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 71 - 80 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 83, 82, 81, 79, 78, 77, 76, 75, 74, 73,  /* 0 - 10 */
/* SPELL */   71, 70, 69, 67, 66, 65, 64, 63, 61, 60,      /* 11 - 20 */
              59, 57, 56, 55, 54, 53, 51, 50, 49, 47,      /* 21 - 30 */
              46, 46, 45, 45, 44, 44, 43, 43, 42, 42,      /* 31 - 40 */
              41, 41, 40, 40, 39, 39, 38, 38, 37, 37,      /* 41 - 50 */
              36, 36, 35, 35, 34, 34, 33, 33, 32, 32,      /* 51 - 60 */
              31, 31, 30, 30, 29, 29, 28, 28, 27, 27,      /* 61 - 70 */
              26, 26, 25, 25, 24, 24, 23, 23, 22, 22,      /* 71 - 80 */
              21, 21, 20, 20, 19, 19, 18, 18, 17, 17,      /* 81 - 90 */
              16, 16, 15, 14, 13, 12, 11, 10, 10, 5}      /* 91 - 100 */
  },

  {                             /* Rangers */
             {90, 76, 74, 72, 70, 68, 66, 64, 62, 60, 58,  /*  0 - 10 */
/* PARA */    56, 54, 52, 50, 48, 47, 45, 43, 41, 40,      /* 11 - 20 */
              38, 37, 36, 35, 34, 33, 32, 31, 30, 29,      /* 21 - 30 */
              28, 27, 26, 25, 24, 23, 22, 21, 20, 19,      /* 31 - 40 */
              18, 17, 16, 15, 14, 13, 12, 11, 10, 10,      /* 41 - 50 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 83, 82, 81, 80, 79, 77, 76, 75, 73, 71,  /* 0 - 10 */
/* ROD */     69, 67, 65, 63, 61, 59, 57, 55, 53, 51,      /* 11 - 20 */
              49, 47, 45, 43, 41, 39, 37, 35, 34, 33,      /* 21 - 30 */
              32, 31, 30, 29, 28, 27, 26, 25, 24, 23,      /* 31 - 40 */
              22, 21, 20, 19, 18, 17, 16, 15, 14, 13,      /* 41 - 50 */
              12, 11, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 78, 77, 76, 75, 74, 72, 70, 68, 66, 64,  /*  0 - 10 */
/* PETRI */   62, 60, 59, 57, 56, 54, 52, 50, 48, 46,      /* 11 - 20 */
              44, 42, 40, 38, 36, 34, 32, 30, 29, 28,      /* 21 - 30 */
              27, 26, 25, 24, 23, 22, 21, 20, 19, 18,      /* 31 - 40 */
              17, 16, 15, 14, 13, 12, 11, 10, 10, 10,         /* 41 - 50 */
              12, 11, 10, 10, 10, 10, 10, 10, 10, 10,         /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,         /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,         /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,         /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},         /* 91 - 100 */

             {90, 88, 87, 86, 85, 84, 82, 80, 78, 76, 74,  /*  0 - 10 */
/* BREATH */  72, 70, 68, 66, 64, 62, 60, 57, 54, 51,      /* 11 - 20 */
              48, 45, 42, 39, 36, 33, 30, 27, 25, 23,      /* 21 - 30 */
              21, 20, 19, 18, 17, 16, 15, 14, 13, 12,      /* 31 - 40 */
              11, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 41 - 50 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 9, 8, 7, 6, 5, 5, 5, 5, 5,               /* 71 - 80 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5,               /* 81 - 90 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5},             /* 91 - 100 */

             {90, 82, 80, 77, 75, 72, 70, 67, 65, 62, 60,  /*  0 - 10 */
/* SPELL */   59, 58, 57, 56, 55, 54, 53, 52, 51, 50,      /* 11 - 20 */
              49, 48, 47, 46, 45, 44, 43, 42, 41, 40,      /* 21 - 30 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,      /* 31 - 40 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 41 - 50 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 51 - 60 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 9, 8, 7, 6, 5, 5, 5, 5, 5,               /* 81 - 90 */
               5, 5, 5, 5, 5, 5, 5, 5, 5, 5}              /* 91 - 100 */
  },

  {                             /* Monks */
             {90, 79, 77, 75, 73, 71, 69, 67, 66, 65, 64,  /*  0 - 10 */
/* PARA */    63, 63, 62, 61, 61, 60, 59, 59, 58, 57,      /* 11 - 20 */
              57, 56, 55, 55, 54, 53, 53, 52, 51, 51,      /* 21 - 30 */
              50, 49, 49, 48, 47, 47, 46, 45, 45, 44,      /* 31 - 40 */
              44, 44, 43, 43, 42, 42, 41, 41, 40, 40,      /* 41 - 50 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,      /* 51 - 60 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 61 - 70 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 80, 78, 76, 74, 72, 70, 69, 68, 67, 66,  /* 0 - 10 */
/* ROD */     65, 64, 63, 62, 61, 60, 59, 58, 57, 56,      /* 11 - 20 */
              55, 54, 53, 52, 51, 50, 49, 48, 47, 46,      /* 21 - 30 */
              45, 44, 43, 42, 41, 40, 39, 38, 37, 36,      /* 31 - 40 */
              35, 34, 33, 32, 31, 30, 29, 28, 27, 26,      /* 41 - 50 */
              25, 24, 23, 22, 21, 21, 20, 20, 20, 20,      /* 51 - 60 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,         /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,         /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,         /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},         /* 91 - 100 */

             {90, 83, 81, 79, 77, 75, 73, 71, 69, 67, 65,  /* 0 - 10 */
/* PETRI */   64, 63, 62, 61, 60, 59, 58, 57, 56, 55,      /* 11 - 20 */
              54, 53, 52, 51, 50, 49, 48, 47, 46, 45,      /* 21 - 30 */
              44, 43, 42, 41, 40, 39, 38, 37, 36, 35,      /* 31 - 40 */
              34, 34, 33, 33, 32, 32, 31, 31, 30, 30,      /* 41 - 50 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 51 - 60 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 61 - 70 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 71 - 80 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 87, 86, 85, 84, 83, 82, 81, 80, 79, 79,  /*  0 - 10 */
/* BREATH */  78, 78, 77, 76, 76, 75, 74, 74, 73, 72,      /* 11 - 20 */
              72, 71, 71, 70, 69, 69, 68, 68, 67, 66,      /* 21 - 30 */
              66, 65, 64, 64, 63, 62, 62, 61, 61, 60,      /* 31 - 40 */
              59, 58, 57, 56, 55, 54, 53, 52, 51, 50,      /* 41 - 50 */
              49, 48, 47, 46, 45, 44, 43, 42, 41, 40,      /* 51 - 60 */
              39, 38, 37, 36, 35, 34, 33, 32, 31, 30,      /* 61 - 70 */
              29, 28, 27, 26, 25, 24, 23, 22, 21, 20,      /* 71 - 80 */
              19, 18, 17, 16, 15, 14, 13, 12, 11, 10,      /* 81 - 90 */
              10, 10, 10, 10, 10, 10, 10, 10, 10, 5},     /* 91 - 100 */

             {90, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71,  /* 0 - 10 */
/* SPELL */   70, 69, 68, 67, 66, 65, 64, 63, 62, 61,      /* 11 - 20 */
              60, 59, 58, 57, 56, 55, 54, 53, 52, 51,      /* 21 - 30 */
              50, 50, 49, 49, 48, 48, 47, 47, 46, 46,      /* 31 - 40 */
              45, 45, 44, 44, 43, 43, 42, 42, 41, 41,      /* 41 - 50 */
              40, 40, 39, 39, 38, 38, 37, 37, 36, 36,      /* 51 - 60 */
              35, 35, 34, 34, 33, 33, 32, 32, 31, 31,      /* 61 - 70 */
              30, 30, 29, 29, 28, 28, 27, 27, 26, 26,      /* 71 - 80 */
              25, 25, 24, 24, 23, 23, 22, 22, 21, 21,      /* 81 - 90 */
              20, 19, 18, 16, 15, 14, 13, 12, 11, 5}      /* 91 - 100 */
  }

};


int mag_savingthrow(struct char_data * ch, int type, int bonus)
{
  int save;

  /* negative apply_saving_throw values make saving throws better! */

  if (IS_NPC(ch)) /* NPCs use warrior tables according to some book */
    save = saving_throws[CLASS_WARRIOR][type][(int) GET_LEVEL(ch)];
  else
    save = saving_throws[(int) GET_CLASS(ch)][type][(int) GET_LEVEL(ch)];

  save += GET_SAVE(ch, type);
  save += bonus;
  
  if (IS_SET(AFF2_FLAGS(ch), AFF2_HOLY_AURA))
    save -= 20;

  /* throwing a 0 is always a failure */
  if (MAX(1, save) < number(0, 99))
    return TRUE;
  else
    return FALSE;
}


/* affect_update: called from comm.c (causes spells to wear off) */
void affect_update(void)
{
  static struct affected_type *af, *next;
  static struct char_data *i;
  extern char *spell_wear_off_msg[];

  for (i = character_list; i; i = i->next)
    for (af = i->affected; af; af = next) {
      next = af->next;
      if (af->duration >= 1)
	af->duration--;
      else if (af->duration == -1)	/* No action */
	af->duration = -1;	/* GODs only! unlimited */
      else {
	if ((af->type > 0) && (af->type <= MAX_SPELLS))
	  if (!af->next || (af->next->type != af->type) ||
	      (af->next->duration > 0))
	    if (*spell_wear_off_msg[af->type]) {
	      send_to_char(spell_wear_off_msg[af->type], i);
	      send_to_char("\r\n", i);
	    }
	affect_remove(i, af);
      }
    }
}


/*
 *  mag_materials:
 *  Checks for up to 3 vnums (spell reagents) in the player's inventory.
 *
 * No spells implemented in Circle 3.0 use mag_materials, but you can use
 * it to implement your own spells which require ingredients (i.e., some
 * heal spell which requires a rare herb or some such.)
 */
int mag_materials(struct char_data * ch, int item0, int item1, int item2,
		      int extract, int verbose)
{
  struct obj_data *tobj;
  struct obj_data *obj0 = NULL, *obj1 = NULL, *obj2 = NULL;

  for (tobj = ch->carrying; tobj; tobj = tobj->next_content) {
    if ((item0 > 0) && (GET_OBJ_VNUM(tobj) == item0)) {
      obj0 = tobj;
      item0 = -1;
    } else if ((item1 > 0) && (GET_OBJ_VNUM(tobj) == item1)) {
      obj1 = tobj;
      item1 = -1;
    } else if ((item2 > 0) && (GET_OBJ_VNUM(tobj) == item2)) {
      obj2 = tobj;
      item2 = -1;
    }
  }
  if ((item0 > 0) || (item1 > 0) || (item2 > 0)) {
    if (verbose) {
      switch (number(0, 2)) {
      case 0:
	send_to_char("A wart sprouts on your nose.\r\n", ch);
	break;
      case 1:
	send_to_char("Your hair falls out in clumps.\r\n", ch);
	break;
      case 2:
	send_to_char("A huge corn develops on your big toe.\r\n", ch);
	break;
      }
    }
    return (FALSE);
  }
  if (extract) {
    if (item0 < 0) {
      obj_from_char(obj0);
      extract_obj(obj0);
    }
    if (item1 < 0) {
      obj_from_char(obj1);
      extract_obj(obj1);
    }
    if (item2 < 0) {
      obj_from_char(obj2);
      extract_obj(obj2);
    }
  }
  if (verbose) {
    send_to_char("A puff of smoke rises from your pack.\r\n", ch);
    act("A puff of smoke rises from $n's pack.", TRUE, ch, NULL, NULL, TO_ROOM);
  }
  return (TRUE);
}




/*
 * Every spell that does damage comes through here.  This calculates the
 * amount of damage, adds in any modifiers, determines what the saves are,
 * tests for save and calls damage().
 */

void mag_damage(int level, struct char_data * ch, struct char_data * victim,
		     int spellnum, int savetype)
{
  int is_mage = 0, is_cleric = 0;
  int dam = 0;

  if (victim == NULL || ch == NULL)
    return;

  is_mage = (GET_CLASS(ch) == CLASS_MAGIC_USER);
  is_cleric = (GET_CLASS(ch) == CLASS_CLERIC);

  switch (spellnum) {
    /* Mostly mages */
  case SPELL_MAGIC_MISSILE:     /* magic missile has level-dep dam */
    if (is_mage)
      dam = dice(GET_LEVEL(ch), 6);
    else
      dam = dice(GET_LEVEL(ch), 4);
    break;
  case SPELL_CHILL_TOUCH:	/* chill touch also has an affect */
    if (is_mage)
      dam = dice(1, 8) + 1;
    else
      dam = dice(1, 6) + 1;
    break;
  case SPELL_BURNING_HANDS:
    if (is_mage)
      dam = dice(3, 8) + 3;
    else
      dam = dice(3, 6) + 3;
    break;
  case SPELL_SHOCKING_GRASP:
    if (is_mage)
      dam = dice(5, 8) + 5;
    else
      dam = dice(5, 6) + 5;
    break;
  case SPELL_LIGHTNING_BOLT:
    if (is_mage)
      dam = dice(7, 8) + 7;
    else
      dam = dice(7, 6) + 7;
    break;
  case SPELL_COLOR_SPRAY:
    if (is_mage)
      dam = dice(9, 8) + 9;
    else
      dam = dice(9, 6) + 9;
    break;
  case SPELL_FIREBALL:
    if (is_mage)
      dam = dice(11, 8) + 11;
    else
      dam = dice(11, 6) + 11;
    break;
  case SPELL_ENERGY_BLAST:
    if (GET_MANA(ch) > 200) {
      dam = 300;
      GET_MANA(ch) -= 200;
}
    else {
      dam = GET_MANA(ch);
      GET_MANA(ch) = 0;
}
    break;
  case SPELL_MANA_BOLT:
    if (GET_MANA(ch) > 500) {
      dam = 1000;
      GET_MANA(ch) -= 500;
}
    else {
      dam = 2 * GET_MANA(ch);
      GET_MANA(ch) = 0;
}
    break;

    /* Mostly clerics */
  case SPELL_DISPEL_EVIL:
    dam = dice(6, 8) + 6;
    if (IS_EVIL(ch)) {
      victim = ch;
      dam = GET_HIT(ch) - 1;
    } else if (IS_GOOD(victim)) {
      act("The gods protect $N.", FALSE, ch, 0, victim, TO_CHAR);
      dam = 0;
      return;
    }
    break;
  case SPELL_DISPEL_GOOD:
    dam = dice(6, 8) + 6;
    if (IS_GOOD(ch)) {
      victim = ch;
      dam = GET_HIT(ch) - 1;
    } else if (IS_EVIL(victim)) {
      act("The gods protect $N.", FALSE, ch, 0, victim, TO_CHAR);
      dam = 0;
      return;
    }
    break;


  case SPELL_CALL_LIGHTNING:
    dam = dice(7, 8) + 7;
    break;

  case SPELL_HARM:
    dam = dice(8, 8) + 8;
    break;

  case SPELL_ENERGY_DRAIN:
    if (GET_LEVEL(victim) <= 2)
      dam = 100;
    else
      dam = dice(1, 10);
    break;

    /* Area spells */
  case SPELL_EARTHQUAKE:
    dam = dice(2, 8) + level;
    break;
  case SPELL_VAMPIRIC_TOUCH:
    dam = dice(5, 5) + 75;
    break;
  case SPELL_MANA_WAVE:
    dam = (GET_MANA(ch) * 1.5);
    if (dam > 32000)
      dam = 32000;
    break;
  case SPELL_FIRE_STORM:
    dam = (GET_MANA(ch) * 2);
    if (dam > 32000)
      dam = 32000;
    break;
  case SPELL_DEATH_WIND:
    dam = (GET_MANA(ch) * 3);
    if (dam > 32000)
      dam = 32000;
    break;
  case SPELL_TURN_UNDEAD:
    if (GET_CLASS(ch) == CLASS_PALADIN)
      level -= 5;
    dam = dice (level, 6);
    break;
  case SPELL_SANDSTORM:
    dam = dice(5,5) + 50;
    mag_affects(GET_LEVEL(ch), ch, victim, SPELL_BLINDNESS, savetype);
    break;
  } /* switch(spellnum) */

  /* Reversal spell... if success, reverse the spell! - GtG */
  if (IS_AFFECTED(victim, AFF_REVERSAL) && number(1,101)<=50) {
   act("The spell bounces off $n and strikes $N!", FALSE, victim, 0, ch, TO_ROOM);
   act("The spell bounces off you and strikes $N, leaving a tingly sensation.",
       FALSE, victim, 0, ch, TO_CHAR);
   act("The spell bounces off $n and strikes you!", FALSE, victim, 0, ch, TO_VICT);
   damage(victim, ch, dam, spellnum);
   return;
  }

  /* divide damage by two if victim makes his saving throw */
  if (mag_savingthrow(victim, savetype, 0))
    dam >>= 1;

  /* and finally, inflict the damage */
  damage(ch, victim, dam, spellnum);
}


/*
 * Every spell that does an affect comes through here.  This determines
 * the effect, whether it is added or replacement, whether it is legal or
 * not, etc.
 *
 * affect_join(vict, aff, add_dur, avg_dur, add_mod, avg_mod)
*/

#define MAX_SPELL_AFFECTS 5	/* change if more needed */

void mag_affects(int level, struct char_data * ch, struct char_data * victim,
		      int spellnum, int savetype)
{
  struct affected_type af[MAX_SPELL_AFFECTS];
  int is_mage = FALSE, is_cleric = FALSE;
  int accum_affect = FALSE, accum_duration = FALSE;
  char *to_vict = NULL, *to_room = NULL;
  int i, tloop;


  if (victim == NULL || ch == NULL)
    return;

  is_mage = (GET_CLASS(ch) == CLASS_MAGIC_USER);
  is_cleric = (GET_CLASS(ch) == CLASS_CLERIC);

  for (i = 0; i < MAX_SPELL_AFFECTS; i++) {
    af[i].type = spellnum;
    af[i].bitvector = 0;
    af[i].bitvector2 = 0;
    af[i].modifier = 0;
    af[i].location = APPLY_NONE;
  }

  switch (spellnum) {

  case SPELL_CHILL_TOUCH:
    af[0].location = APPLY_STR;
    if (mag_savingthrow(victim, savetype, 0))
      af[0].duration = 1;
    else
      af[0].duration = 4;
    af[0].modifier = -1;
    accum_duration = TRUE;
    to_vict = "You feel your strength wither!";
    break;

  case SPELL_ARMOR:
    af[0].location = APPLY_AC;
    af[0].modifier = -20;
    af[0].duration = 24;
    accum_duration = TRUE;
    to_vict = "You feel someone protecting you.";
    break;

  case SPELL_BLESS:
    af[0].location = APPLY_HITROLL;
    af[0].modifier = 2;
    af[0].duration = 6;

    af[1].location = APPLY_SAVING_SPELL;
    af[1].modifier = -1;
    af[1].duration = 6;

    accum_duration = TRUE;
    to_vict = "You feel righteous.";
    break;

  case SPELL_BLINDNESS:
    if (MOB_FLAGGED(victim,MOB_NOBLIND) || mag_savingthrow(victim, savetype, 0)) {
      send_to_char("You fail.\r\n", ch);
      return;
    }

    af[0].location = APPLY_HITROLL;
    af[0].modifier = -4;
    af[0].duration = 2;
    af[0].bitvector = AFF_BLIND;

    af[1].location = APPLY_AC;
    af[1].modifier = 40;
    af[1].duration = 2;
    af[1].bitvector = AFF_BLIND;

    to_room = "$n seems to be blinded!";
    to_vict = "You have been blinded!";
    break;

  case SPELL_CURSE:
    if (mag_savingthrow(victim, savetype, 0)) {
      send_to_char(NOEFFECT, ch);
      return;
    }

    af[0].location = APPLY_HITROLL;
    af[0].duration = 1 + (GET_LEVEL(ch) >> 1);
    af[0].modifier = -1;
    af[0].bitvector = AFF_CURSE;

    af[1].location = APPLY_DAMROLL;
    af[1].duration = 1 + (GET_LEVEL(ch) >> 1);
    af[1].modifier = -1;
    af[1].bitvector = AFF_CURSE;

    accum_duration = TRUE;
    accum_affect = TRUE;
    to_room = "$n briefly glows red!";
    to_vict = "You feel very uncomfortable.";
    break;

  case SPELL_DETECT_ALIGN:
    if (IS_PALADIN(victim) || IS_APALADIN(victim) || 
	(IS_MONK(victim) && GET_LEVEL(victim) >= 6))
    /* || GET_RACE(ch) == RACE_TIEFLING)*/
      af[0].duration = -1;
    else af[0].duration = 12 + level;
    af[0].bitvector = AFF_DETECT_ALIGN;
    accum_duration = TRUE;
    to_vict = "Your eyes tingle.";
    break;

  case SPELL_DETECT_INVIS:
    if (IS_BARD(victim) || (IS_MONK(victim) && GET_LEVEL(victim) >= 8))
/* || GET_RACE(ch) == RACE_TIEFLING)*/ 
      af[0].duration = -1;
    else af[0].duration = 12 + level;
    af[0].bitvector = AFF_DETECT_INVIS;
    accum_duration = TRUE;
    to_vict = "Your eyes tingle.";
    break;

  case SPELL_DETECT_MAGIC:
    if (IS_FAIRY(victim) || (IS_MONK(victim) && GET_LEVEL(victim) >= 6))
/* || GET_RACE(ch) == RACE_TIEFLING)*/
      af[0].duration = -1;
    else af[0].duration = 12 + level;
    af[0].bitvector = AFF_DETECT_MAGIC;
    accum_duration = TRUE;
    to_vict = "Your eyes tingle.";
    break;

  case SPELL_INFRAVISION:
    if (IS_ELF(victim) || IS_DWARF(victim) || IS_HOBBIT(victim) || 
	IS_VAMPIRE(victim) || IS_TIEFLING(victim) || 
	(IS_MONK(victim) && GET_LEVEL(victim) >= 30))
      af[0].duration = -1;
    else af[0].duration = 12 + level;
    af[0].bitvector = AFF_INFRAVISION;
    accum_duration = TRUE;
    to_vict = "Your eyes glow red.";
    to_room = "$n's eyes glow red.";
    break;

  case SPELL_INVISIBLE:
    if (!victim)
      victim = ch;

    af[0].duration = 12 + (GET_LEVEL(ch) >> 2);
    af[0].modifier = -40;
    af[0].location = APPLY_AC;
    af[0].bitvector = AFF_INVISIBLE;
    accum_duration = TRUE;
    to_vict = "You vanish.";
    to_room = "$n slowly fades out of existence.";
    break;

  case SPELL_POISON:
    if (IS_SET(AFF_FLAGS(victim), AFF_NOPOISON) || mag_savingthrow(victim, savetype, 0)) {
      send_to_char(NOEFFECT, ch);
      return;
    }

    af[0].location = APPLY_STR;
    af[0].duration = GET_LEVEL(ch);
    af[0].modifier = -2;
    af[0].bitvector = AFF_POISON;
    to_vict = "You feel very sick.";
    to_room = "$n gets violently ill!";
    break;

  case SPELL_PROT_FROM_EVIL:
    if (GET_CLASS(victim) == CLASS_PALADIN) af[0].duration = -1;
    else af[0].duration = 24;
    af[0].bitvector = AFF_PROTECT_EVIL;
    accum_duration = TRUE;
    to_vict = "You feel invulnerable!";
    break;

  case SPELL_SANCTUARY:
  /*  if (IS_SET(AFF2_FLAGS(victim), AFF2_DIVINE_PROT)) {
      send_to_char ("You cannot use this spell; you already have Divine Protection.\r\n", victim);
      return;
    } */
    if (IS_MONK(victim) && GET_LEVEL(victim) >= 65)
	af[0].duration = -1;
    else af[0].duration = 4;
    af[0].bitvector = AFF_SANCTUARY;

    accum_duration = TRUE;
    to_vict = "A white aura momentarily surrounds you.";
    to_room = "$n is surrounded by a white aura.";
    break;

  case SPELL_SLEEP:
    if (!pk_allowed && !IS_NPC(ch) && !IS_NPC(victim) && 
        !ROOM_FLAGGED(victim->in_room, ROOM_CRIMEOK))
      return;
    if (MOB_FLAGGED(victim, MOB_NOSLEEP))
      return;
    if (mag_savingthrow(victim, savetype, 0))
      return;

    af[0].duration = 4 + (GET_LEVEL(ch) >> 2);
    af[0].bitvector = AFF_SLEEP;

    if (GET_POS(victim) > POS_SLEEPING) {
      act("You feel very sleepy...  Zzzz......", FALSE, victim, 0, 0, TO_CHAR);
      act("$n goes to sleep.", TRUE, victim, 0, 0, TO_ROOM);
      GET_POS(victim) = POS_SLEEPING;
    }
    break;

  case SPELL_STRENGTH:
    af[0].location = APPLY_STR;
    af[0].duration = (GET_LEVEL(ch) >> 1) + 4;
    af[0].modifier = 1 + (level > 18);
    accum_duration = TRUE;
    accum_affect = TRUE;
    to_vict = "You feel stronger!";
    break;

  case SPELL_SENSE_LIFE:
    to_vict = "Your feel your awareness improve.";
    if (IS_RANGER(victim) || (IS_MONK(victim) && GET_LEVEL(victim) >=50)
         || IS_ELF(victim))
      /* || GET_RACE(ch) == RACE_TIEFLING)*/
      af[0].duration = -1;
    else af[0].duration = GET_LEVEL(ch);
    af[0].bitvector = AFF_SENSE_LIFE;
    accum_duration = TRUE;
    break;

  case SPELL_WATERWALK:
    /* if (GET_RACE(ch) == RACE_TIEFLING) af[0].duration = -1; */
    if (IS_MONK(victim) && GET_LEVEL(victim) >= 20)
    af[0].duration = -1;
    else af[0].duration = 24;
    af[0].bitvector = AFF_WATERWALK;
    accum_duration = TRUE;
    to_vict = "You feel webbing between your toes.";
    break;
  case SPELL_FLIGHT:
    af[0].type = SPELL_FLIGHT;
    if (GET_RACE(victim) == RACE_FAIRY || GET_RACE(victim) == RACE_DRAGON)/* ||
        GET_RACE(victim) == RACE_TIEFLING)*/ af[0].duration = -1;
    else af[0].duration = 24;
    af[0].bitvector = AFF_FLYING;
    to_vict = "You begin to float slightly above the ground.";
    break;

  case SPELL_FAERIE_FIRE:
   world[ch->in_room].light++;
   af[0].bitvector = AFF_LIT;
   if (GET_LEVEL(victim) >= LVL_IMMORT) af[0].duration = -1;
   else af[0].duration = GET_LEVEL(ch);
   af[0].type = SPELL_FAERIE_FIRE;
   to_vict = "You begin to glow softly.";
   to_room = "$n begins to glow softly.";
   break;

  case SPELL_BLUR:
   af[0].type = SPELL_BLUR;
   if (IS_FAIRY(victim))
     af[0].duration = -1;
   else af[0].duration = (GET_LEVEL(ch) / 2);
   af[0].bitvector = AFF_BLUR;
   to_vict = "You can no longer focus on yourself.";
   to_room = "$n gets hazy and blurs out of clear sight.";
   break;
  case SPELL_HASTE:
   if (IS_AFFECTED(victim, AFF_SLOW))
    affect_from_char(victim, AFF_SLOW);
   else {
     to_vict = "You suddenly feel a lot quicker!";
     to_room = "$n speeds up!";
     af[0].type = SPELL_HASTE;
     if (IS_FAIRY(victim) && GET_LEVEL(victim) >= 50)
       af[0].duration = -1;
     else af[0].duration = (GET_LEVEL(ch) >> 4);
     af[0].bitvector = AFF_HASTE;
   }
   break;
  case SPELL_WEB:
   if (mag_savingthrow(victim, savetype, 0)) {
    to_vict = "You miss $n with your web.";
    to_room = "$N tries to catch $n with $S web but misses!";
    break;
   }
   af[0].type = SPELL_WEB;
   af[0].duration = 3;
   af[0].bitvector = AFF_WEB;
   act("$N catches you in $S web! You can't move!", TRUE, victim, 0, ch, TO_CHAR);
   to_vict = "You web $n.";
   to_room = "$N creates a web and traps $n!";
   break;
  case SPELL_SLOW:
    if (mag_savingthrow(victim, savetype, 0)) {
      send_to_char("You fail.\r\n", ch);
      return;
   }
   if (IS_AFFECTED(victim, AFF_HASTE)) 
    affect_from_char(victim, AFF_HASTE);
   else {
     af[0].type = SPELL_SLOW;
     af[0].duration = (GET_LEVEL(ch) >> 4);
     af[0].bitvector = AFF_SLOW;
     to_vict = "You suddenly feel a lot slower!";
     to_room = "$n slows down!";
   }
   break;

  case SPELL_SHIELD:
    af[0].location = APPLY_AC;
    af[0].modifier = -30;
    af[0].duration = 24;
    accum_duration = TRUE;
    to_vict = "A shimmering force-shield envelops you.";
    break;

 case SPELL_STONESKIN:
    af[0].location = APPLY_AC;
    af[0].modifier = -30;
    af[0].duration = 24;
    accum_duration = TRUE;
    to_vict = "Your skin turns tough as stone!";
    break;

 case SPELL_REVERSAL:
    af[0].type = SPELL_REVERSAL;
    af[0].bitvector = AFF_REVERSAL;
    af[0].duration = 1;
    accum_duration = TRUE;
    to_vict = "You feel rubbery.";
    break;

  case SPELL_HOLY_AURA:
    af[0].type = SPELL_HOLY_AURA;
    af[0].location = APPLY_AC;
    af[0].modifier = -20;
    af[0].duration = 10;
    af[1].type = SPELL_HOLY_AURA;
    af[1].bitvector2 = AFF2_HOLY_AURA;
    af[1].duration = 10;
    af[2].type = SPELL_HOLY_AURA;
    af[2].location = APPLY_HITROLL;
    af[2].modifier = 2;
    af[2].duration = 10;
    af[3].type = SPELL_HOLY_AURA;
    af[3].bitvector = AFF_PROTECT_EVIL;
    af[3].duration = 10;
    to_vict = "You feel empowered.";
    break;

    case SPELL_DIVINE_PROT:
   /*   if (IS_AFFECTED(victim, AFF_SANCTUARY)) {
        send_to_char ("You cannot use this spell; you already have Sanctuary.\r\n", victim);
        return;
      } */
      af[0].type = SPELL_DIVINE_PROT;
      af[0].bitvector2 = AFF2_DIVINE_PROT;
      af[0].duration = 8;
      to_vict = "A bright yellow aura surrounds you.";
      break;
    case SPELL_BLINK:
      af[0].type = SPELL_BLINK;
      af[0].bitvector2 = AFF2_BLINK;
      af[0].duration = 5;
      to_vict = "Your existence becomes questionable.";
      break;
  }
  /*
   * If this is a mob that has this affect set in its mob file, do not
   * perform the affect.  This prevents people from un-sancting mobs
   * by sancting them and waiting for it to fade, for example.
   */
   for (tloop = 0; tloop < MAX_SPELL_AFFECTS; tloop++) {
     if ((IS_AFFECTED(victim, af[tloop].bitvector) || IS_SET(AFF2_FLAGS(victim), af[tloop].bitvector2)) &&
       !affected_by_spell(victim, spellnum)) {
	send_to_char(NOEFFECT, ch);
	send_to_char("Your permanent effect cancels out this spell.", victim);
	return;
     }
   }

  /*
   * If the victim is already affected by this spell, and the spell does
   * not have an accumulative effect, then fail the spell.
   */
  if (affected_by_spell(victim,spellnum) && !(accum_duration||accum_affect)) {
    send_to_char(NOEFFECT, ch);
    return;
  }

  for (i = 0; i < MAX_SPELL_AFFECTS; i++)
    if (af[i].bitvector || (af[i].location != APPLY_NONE) || af[i].bitvector2)
      affect_join(victim, af+i, accum_duration, FALSE, accum_affect, FALSE);

  if (to_vict != NULL)
    act(to_vict, FALSE, victim, 0, ch, TO_CHAR);
  if (to_room != NULL)
    act(to_room, TRUE, victim, 0, ch, TO_ROOM);
}


/*
 * This function is used to provide services to mag_groups.  This function
 * is the one you should change to add new group spells.
 */

void perform_mag_groups(int level, struct char_data * ch,
			struct char_data * tch, int spellnum, int savetype)
{
  switch (spellnum) {
    case SPELL_GROUP_HEAL:
    mag_points(level, ch, tch, SPELL_HEAL, savetype);
    break;
  case SPELL_GROUP_ARMOR:
    mag_affects(level, ch, tch, SPELL_ARMOR, savetype);
    break;
  case SPELL_GROUP_RECALL:
    spell_recall(level, ch, tch, NULL, "", 0);
    break;
  case SPELL_GROUP_BLESS:
    mag_affects(level, ch, tch, SPELL_BLESS, savetype);
    break;
  case SPELL_HOLY_AURA:
    mag_affects(level, ch, tch, SPELL_HOLY_AURA, savetype);
    break;
  }
}


/*
 * Every spell that affects the group should run through here
 * perform_mag_groups contains the switch statement to send us to the right
 * magic.
 *
 * group spells affect everyone grouped with the caster who is in the room,
 * caster last.
 *
 * To add new group spells, you shouldn't have to change anything in
 * mag_groups -- just add a new case to perform_mag_groups.
 */

void mag_groups(int level, struct char_data * ch, int spellnum, int savetype)
{
  struct char_data *tch, *k;
  struct follow_type *f, *f_next;

  if (ch == NULL)
    return;

  if (!IS_AFFECTED(ch, AFF_GROUP))
    return;
  if (ch->master != NULL)
    k = ch->master;
  else
    k = ch;
  for (f = k->followers; f; f = f_next) {
    f_next = f->next;
    tch = f->follower;
    if (tch->in_room != ch->in_room)
      continue;
    if (!IS_AFFECTED(tch, AFF_GROUP))
      continue;
    if (ch == tch)
      continue;
    perform_mag_groups(level, ch, tch, spellnum, savetype);
  }

  if ((k != ch) && IS_AFFECTED(k, AFF_GROUP))
    perform_mag_groups(level, ch, k, spellnum, savetype);
  perform_mag_groups(level, ch, ch, spellnum, savetype);
}


/*
 * mass spells affect every creature in the room except the caster.
 *
 * No spells of this class currently implemented as of Circle 3.0.
 */

void mag_masses(int level, struct char_data * ch, int spellnum, int savetype)
{
  struct char_data *tch, *tch_next;

  for (tch = world[ch->in_room].people; tch; tch = tch_next) {
    tch_next = tch->next_in_room;
    if (tch == ch)
      continue;

    switch (spellnum) {
    }
  }
}


/*
 * Every spell that affects an area (room) runs through here.  These are
 * generally offensive spells.  This calls mag_damage to do the actual
 * damage -- all spells listed here must also have a case in mag_damage()
 * in order for them to work.
 *
 *  area spells have limited targets within the room.
*/

void mag_areas(byte level, struct char_data * ch, int spellnum, int savetype)
{
  struct char_data *tch, *next_tch;
  char *to_char = NULL;
  char *to_room = NULL;

  if (ch == NULL)
    return;

  /*
   * to add spells to this fn, just add the message here plus an entry
   * in mag_damage for the damaging part of the spell.
   */
  switch (spellnum) {
  case SPELL_EARTHQUAKE:
    to_char = "You gesture and the earth begins to shake all around you!";
    to_room ="$n gracefully gestures and the earth begins to shake violently!";
    break;
  case SPELL_MANA_WAVE:
    to_char = "You gesture and start a wave of pure magical energy!";
    to_room ="$n gracefully gestures and a wave of magical energy rips through!";
    break;
  case SPELL_FIRE_STORM:
    to_char = "You call upon a storm of fire all around you!";
    to_room ="$n calls upon a storm or fire to strike all around!";
    break;
  case SPELL_DEATH_WIND:
    to_char = "You summon a wind of pure death energy!";
    to_room ="$n calls upon a wind of killing power!";
    break;
  case SPELL_TURN_UNDEAD:
    to_char = "You present your holy symbol to the undead minions!";
    to_room ="$n presents a holy symbol to the undead minions!";
    break;
  case SPELL_SANDSTORM:
    to_char = "You raise up a mighty sandstorm!";
    to_room = "$n raises up a mighty standstorm!";
    break;
  }

  if (to_char != NULL)
    act(to_char, FALSE, ch, 0, 0, TO_CHAR);
  if (to_room != NULL)
    act(to_room, FALSE, ch, 0, 0, TO_ROOM);
  

  for (tch = world[ch->in_room].people; tch; tch = next_tch) {
    next_tch = tch->next_in_room;

    /*
     * The skips: 1: the caster
     *            2: immortals
     *            3: if no pk on this mud, skips over all players
     *            4: pets (charmed NPCs)
     * players can only hit players in CRIMEOK rooms 4) players can only hit
     * charmed mobs in CRIMEOK rooms
     */

    if (tch == ch)
      continue;
    if (!IS_NPC(tch) && GET_LEVEL(tch) >= LVL_IMMORT)
      continue;
    if (!pk_allowed && !IS_NPC(ch) && !IS_NPC(tch))
      continue;
    if (!IS_NPC(ch) && IS_NPC(tch) && IS_AFFECTED(tch, AFF_CHARM))
      continue;

    switch (spellnum) {
    case SPELL_MANA_WAVE:
      if (number(1, 2) == 1)
        break;
      mag_damage(GET_LEVEL(ch), ch, tch, spellnum, 1);
      break;
    case SPELL_TURN_UNDEAD:
      if (GET_CLASS(tch) == CLASS_UNDEAD)
        mag_damage(GET_LEVEL(ch), ch, tch, spellnum, 1);
      break;
    default:
      mag_damage(GET_LEVEL(ch), ch, tch, spellnum, 1);
    }
  }
  switch (spellnum) {
    case SPELL_MANA_WAVE:
      GET_MANA(ch) = 0;
      break;
    case SPELL_FIRE_STORM:
      GET_MANA(ch) = 0;
      break;
    case SPELL_DEATH_WIND:
      GET_MANA(ch) = 0;
      break;
    default:
      break;
  }
}


/*
 *  Every spell which summons/gates/conjours a mob comes through here.
 *
 *  None of these spells are currently implemented in Circle 3.0; these
 *  were taken as examples from the JediMUD code.  Summons can be used
 *  for spells like clone, ariel servant, etc.
 */

static char *mag_summon_msgs[] = {
  "\r\n",
  "$n makes a strange magical gesture; you feel a strong breeze!\r\n",
  "$n animates a corpse!\r\n",
  "$N appears from a cloud of thick blue smoke!\r\n",
  "$N appears from a cloud of thick green smoke!\r\n",
  "$N appears from a cloud of thick red smoke!\r\n",
  "$N disappears in a thick black cloud!\r\n"
  "As $n makes a strange magical gesture, you feel a strong breeze.\r\n",
  "As $n makes a strange magical gesture, you feel a searing heat.\r\n",
  "As $n makes a strange magical gesture, you feel a sudden chill.\r\n",
  "As $n makes a strange magical gesture, you feel the dust swirl.\r\n",
  "$n magically divides!\r\n",
  "$n animates a corpse!\r\n"
};

static char *mag_summon_fail_msgs[] = {
  "\r\n",
  "There are no such creatures.\r\n",
  "Uh oh...\r\n",
  "Oh dear.\r\n",
  "Oh shit!\r\n",
  "The elements resist!\r\n",
  "You failed.\r\n",
  "There is no corpse!\r\n"
};

#define MOB_MONSUM_I		130
#define MOB_MONSUM_II		140
#define MOB_MONSUM_III		150
#define MOB_GATE_I		160
#define MOB_GATE_II		170
#define MOB_GATE_III		180
#define MOB_ELEMENTAL_BASE	110
#define MOB_CLONE		69
#define MOB_ZOMBIE		101
#define MOB_AERIALSERVANT	109


void mag_summons(int level, struct char_data * ch, struct obj_data * obj,
		      int spellnum, int savetype)
{
  struct char_data *mob = NULL;
  struct obj_data *tobj, *next_obj;
  int pfail = 0;
  int msg = 0, fmsg = 0;
  int num = 1;
  int a, i;
  int mob_num = 0;
  int handle_corpse = 0;

  if (ch == NULL)
    return;

  switch (spellnum) {
  case SPELL_ANIMATE_DEAD:
    if ((obj == NULL) || (GET_OBJ_TYPE(obj) != ITEM_CONTAINER) ||
	(!GET_OBJ_VAL(obj, 3))) {
      act(mag_summon_fail_msgs[7], FALSE, ch, 0, 0, TO_CHAR);
      return;
    }
    handle_corpse = 1;
    msg = 12;
    mob_num = MOB_ZOMBIE;
    a = number(0, 5);
    if (a)
      mob_num++;
    pfail = 8;
    break;

  default:
    return;
  }

  if (IS_AFFECTED(ch, AFF_CHARM)) {
    send_to_char("You are too giddy to have any followers!\r\n", ch);
    return;
  }
  if (number(0, 101) < pfail) {
    send_to_char(mag_summon_fail_msgs[fmsg], ch);
    return;
  }
  for (i = 0; i < num; i++) {
    mob = read_mobile(mob_num, VIRTUALRM);
    char_to_room(mob, ch->in_room);
    IS_CARRYING_W(mob) = 0;
    IS_CARRYING_N(mob) = 0;
    SET_BIT(AFF_FLAGS(mob), AFF_CHARM);
    add_follower(mob, ch);
    act(mag_summon_msgs[fmsg], FALSE, ch, 0, mob, TO_ROOM);
    if (spellnum == SPELL_CLONE) {
      strcpy(GET_NAME(mob), GET_NAME(ch));
      strcpy(mob->player.short_descr, GET_NAME(ch));
    }
  }
  if (handle_corpse) {
    for (tobj = obj->contains; tobj; tobj = next_obj) {
      next_obj = tobj->next_content;
      obj_from_obj(tobj);
      obj_to_char(tobj, mob);
    }
    extract_obj(obj);
  }
}


void mag_points(int level, struct char_data * ch, struct char_data * victim,
		     int spellnum, int savetype)
{
  int hit = 0;
  int move = 0;
  int mana = 0;

  if (victim == NULL)
    return;

  switch (spellnum) {
  case SPELL_CURE_LIGHT:
    hit = dice(4, 4) + 1 + (level >> 1);
    send_to_char("You feel better.\r\n", victim);
    break;
  case SPELL_CURE_CRITIC:
    hit = dice(4, 50) + 50 + (level >> 1);
    send_to_char("You feel a lot better!\r\n", victim);
    break;
  case SPELL_HEAL:
    hit = dice(4, 75) + 75 + (level >> 1);
    send_to_char("A warm feeling floods your body.\r\n", victim);
    break;
  case SPELL_VIGORIZE:
    move = (GET_LEVEL(victim) / 20) * 20 + 20;
    send_to_char("You suddenly have a get-up-and-go feeling.\r\n", victim);
    break;
  case SPELL_MANA_REGEN:
    mana = 30 + dice(3, 8);
    send_to_char("You feel the burn of magical energy coursing through your body.\r\n", victim);
    break;
  case SPELL_VAMPIRIC_TOUCH:
    GET_HIT(ch) = MIN(GET_MAX_HIT(ch), GET_HIT(ch) + (dice(5, 2) + 35));
    send_to_char("You suck the life from your victim.\r\n", ch);
    break;
  case SPELL_CURE_SERIOUS:
    hit = dice(4, 25) + 25 + (level >> 1);
    send_to_char("You feel a lot better!\r\n", victim);
    break;
  }
  GET_HIT(victim) = MIN(GET_MAX_HIT(victim), GET_HIT(victim) + hit);
  GET_MOVE(victim) = MIN(GET_MAX_MOVE(victim), GET_MOVE(victim) + move);
  GET_MANA(victim) = MIN(GET_MAX_MANA(victim), GET_MANA(victim) + mana);
}


void mag_unaffects(int level, struct char_data * ch, struct char_data * victim,
		        int spellnum, int type)
{
  int spell = 0;
  char *to_vict = NULL, *to_room = NULL;

  if (victim == NULL)
    return;

  switch (spellnum) {
  case SPELL_CURE_BLIND:
  case SPELL_HEAL:
    spell = SPELL_BLINDNESS;
    to_vict = "Your vision returns!";
    to_room = "There's a momentary gleam in $n's eyes.";
    break;
  case SPELL_REMOVE_POISON:
    spell = SPELL_POISON;
    to_vict = "A warm feeling runs through your body!";
    to_room = "$n looks better.";
    break;
  case SPELL_REMOVE_CURSE:
    spell = SPELL_CURSE;
    to_vict = "You don't feel so unlucky.";
    break;
  case SPELL_REM_INVIS:
    spell = SPELL_INVISIBLE;
    to_vict = "Your invisibility is suddenly stripped away.";
    break;
  default:
    sprintf(buf, "SYSERR: unknown spellnum %d passed to mag_unaffects", spellnum);
    nmlog(buf);
    return;
    break;
  }

  if (!affected_by_spell(victim, spell)) {
    send_to_char(NOEFFECT, ch);
    return;
  }

  affect_from_char(victim, spell);
  if (to_vict != NULL)
    act(to_vict, FALSE, victim, 0, ch, TO_CHAR);
  if (to_room != NULL)
    act(to_room, TRUE, victim, 0, ch, TO_ROOM);

}


void mag_alter_objs(int level, struct char_data * ch, struct obj_data * obj,
		         int spellnum, int savetype)
{
  char *to_char = NULL;
  char *to_room = NULL;

  if (obj == NULL)
    return;

  switch (spellnum) {
    case SPELL_BLESS:
      if (!IS_OBJ_STAT(obj, ITEM_BLESS) &&
	  (GET_OBJ_WEIGHT(obj) <= 5 * GET_LEVEL(ch))) {
	SET_BIT(GET_OBJ_EXTRA(obj), ITEM_BLESS);
	to_char = "$p glows briefly.";
      }
      break;
    case SPELL_CURSE:
      if (!IS_OBJ_STAT(obj, ITEM_NODROP)) {
	SET_BIT(GET_OBJ_EXTRA(obj), ITEM_NODROP);
	if (GET_OBJ_TYPE(obj) == ITEM_WEAPON)
	  GET_OBJ_VAL(obj, 2)--;
	to_char = "$p briefly glows red.";
      }
      break;
    case SPELL_INVISIBLE:
      if (!IS_OBJ_STAT(obj, ITEM_NOINVIS | ITEM_INVISIBLE)) {
        SET_BIT(obj->obj_flags.extra_flags, ITEM_INVISIBLE);
        to_char = "$p vanishes.";
      }
      break;
    case SPELL_POISON:
      if (((GET_OBJ_TYPE(obj) == ITEM_DRINKCON) ||
         (GET_OBJ_TYPE(obj) == ITEM_FOUNTAIN) ||
         (GET_OBJ_TYPE(obj) == ITEM_FOOD)) && !GET_OBJ_VAL(obj, 3)) {
      GET_OBJ_VAL(obj, 3) = 1;
      to_char = "$p steams briefly.";
      }
      break;
    case SPELL_REMOVE_CURSE:
      if (IS_OBJ_STAT(obj, ITEM_NODROP)) {
        REMOVE_BIT(obj->obj_flags.extra_flags, ITEM_NODROP);
        if (GET_OBJ_TYPE(obj) == ITEM_WEAPON)
          GET_OBJ_VAL(obj, 2)++;
        to_char = "$p briefly glows blue.";
      }
      break;
    case SPELL_REMOVE_POISON:
      if (((GET_OBJ_TYPE(obj) == ITEM_DRINKCON) ||
         (GET_OBJ_TYPE(obj) == ITEM_FOUNTAIN) ||
         (GET_OBJ_TYPE(obj) == ITEM_FOOD)) && GET_OBJ_VAL(obj, 3)) {
        GET_OBJ_VAL(obj, 3) = 0;
        to_char = "$p steams briefly.";
      }
      break;
    case SPELL_REM_INVIS:    /* KAKO */
      if (IS_OBJ_STAT(obj, ITEM_INVISIBLE)) {
        REMOVE_BIT(obj->obj_flags.extra_flags, ITEM_INVISIBLE);
        to_char = "$p becomes visible.";
      }
      break;
  }

  if (to_char == NULL)
    send_to_char(NOEFFECT, ch);
  else
    act(to_char, TRUE, ch, obj, 0, TO_CHAR);

  if (to_room != NULL)
    act(to_room, TRUE, ch, obj, 0, TO_ROOM);
  else if (to_char != NULL)
    act(to_char, TRUE, ch, obj, 0, TO_ROOM);

}



void mag_creations(int level, struct char_data * ch, int spellnum)
{
  struct obj_data *tobj;
  int z;

  if (ch == NULL)
    return;
  level = MAX(MIN(level, LVL_SIMP), 1);

  switch (spellnum) {
  case SPELL_CREATE_FOOD:
    z = 7090;
    break;
  case SPELL_HEROES_FEAST:
    z = 6018;
  if (!(tobj = read_object(z, VIRTUALRM))) {
    send_to_char("I seem to have goofed.\r\n", ch);
    sprintf(buf, "SYSERR: spell_creations, spell %d, obj %d: obj not found",
	    spellnum, z);
    nmlog(buf);
    return;
  }
  obj_to_char(tobj, ch);
  act("$n creates $p.", FALSE, ch, tobj, 0, TO_ROOM);
  act("You create $p.", FALSE, ch, tobj, 0, TO_CHAR);
    z = 2903;
  if (!(tobj = read_object(z, VIRTUALRM))) {
    send_to_char("I seem to have goofed.\r\n", ch);
    sprintf(buf, "SYSERR: spell_creations, spell %d, obj %d: obj not found",
	    spellnum, z);
    nmlog(buf);
    return;
  }
  obj_to_char(tobj, ch);
  act("$n creates $p.", FALSE, ch, tobj, 0, TO_ROOM);
  act("You create $p.", FALSE, ch, tobj, 0, TO_CHAR);
    z = 3002;
  if (!(tobj = read_object(z, VIRTUALRM))) {
    send_to_char("I seem to have goofed.\r\n", ch);
    sprintf(buf, "SYSERR: spell_creations, spell %d, obj %d: obj not found",
	    spellnum, z);
    nmlog(buf);
    return;
  }
  obj_to_char(tobj, ch);
  act("$n creates $p.", FALSE, ch, tobj, 0, TO_ROOM);
  act("You create $p.", FALSE, ch, tobj, 0, TO_CHAR);
    z = 3002;
  if (!(tobj = read_object(z, VIRTUALRM))) {
    send_to_char("I seem to have goofed.\r\n", ch);
    sprintf(buf, "SYSERR: spell_creations, spell %d, obj %d: obj not found",
	    spellnum, z);
    nmlog(buf);
    return;
  }
  obj_to_char(tobj, ch);
  act("$n creates $p.", FALSE, ch, tobj, 0, TO_ROOM);
  act("You create $p.", FALSE, ch, tobj, 0, TO_CHAR);
    z = 3002;
  if (!(tobj = read_object(z, VIRTUALRM))) {
    send_to_char("I seem to have goofed.\r\n", ch);
    sprintf(buf, "SYSERR: spell_creations, spell %d, obj %d: obj not found",
	    spellnum, z);
    nmlog(buf);
    return;
  }
  obj_to_char(tobj, ch);
  act("$n creates $p.", FALSE, ch, tobj, 0, TO_ROOM);
  act("You create $p.", FALSE, ch, tobj, 0, TO_CHAR);
    z = 24506;
  if (!(tobj = read_object(z, VIRTUALRM))) {
    send_to_char("I seem to have goofed.\r\n", ch);
    sprintf(buf, "SYSERR: spell_creations, spell %d, obj %d: obj not found",
	    spellnum, z);
    nmlog(buf);
    return;
  }
  obj_to_char(tobj, ch);
  act("$n creates $p.", FALSE, ch, tobj, 0, TO_ROOM);
  act("You create $p.", FALSE, ch, tobj, 0, TO_CHAR);
    z = 24506;
  if (!(tobj = read_object(z, VIRTUALRM))) {
    send_to_char("I seem to have goofed.\r\n", ch);
    sprintf(buf, "SYSERR: spell_creations, spell %d, obj %d: obj not found",
	    spellnum, z);
    nmlog(buf);
    return;
  }
  obj_to_char(tobj, ch);
  act("$n creates $p.", FALSE, ch, tobj, 0, TO_ROOM);
  act("You create $p.", FALSE, ch, tobj, 0, TO_CHAR);
    z = 3011;
    break;
  default:
    send_to_char("Spell unimplemented, it would seem.\r\n", ch);
    return;
    break;
  }

  if (!(tobj = read_object(z, VIRTUALRM))) {
    send_to_char("I seem to have goofed.\r\n", ch);
    sprintf(buf, "SYSERR: spell_creations, spell %d, obj %d: obj not found",
	    spellnum, z);
    nmlog(buf);
    return;
  }
  obj_to_char(tobj, ch);
  act("$n creates $p.", FALSE, ch, tobj, 0, TO_ROOM);
  act("You create $p.", FALSE, ch, tobj, 0, TO_CHAR);
}

