/* ************************************************************************
*   File: mail.c                                        Part of CircleMUD *
*  Usage: Internal funcs and player spec-procs of mud-mail system         *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */

/******* MUD MAIL SYSTEM MAIN FILE ***************************************

Written by Jeremy Elson (jelson@cs.jhu.edu)
Rewritten by Sammy

*************************************************************************/

#include "conf.h"
#include "sysdep.h"


#include "structs.h"
#include "utils.h"
#include "comm.h"
#include "db.h"
#include "interpreter.h"
#include "handler.h"
#include "mail.h"

void postmaster_send_mail(struct char_data * ch, struct char_data *mailman,
			  int cmd, char *arg);
void postmaster_check_mail(struct char_data * ch, struct char_data *mailman,
			  int cmd, char *arg);
void postmaster_receive_mail(struct char_data * ch, struct char_data *mailman,
			  int cmd, char *arg);
void postmaster_put_mail(struct char_data * ch, struct char_data *mailman,
			  int cmd, char *arg);
void postmaster_get_mail(struct char_data * ch, struct char_data *mailman,
			  int cmd, char *arg);
void postmaster_read_mail(struct char_data * ch, struct char_data *mailman,
			  int cmd, char *arg);

extern struct room_data *world;
extern struct index_data *mob_index;
extern struct mail_index_element *mail_table;
extern int no_mail;
extern int max_mail_save;
extern struct obj_data *obj_proto;

int find_name(char *name);

position_list_type *free_list = 0;	/* list of free positions in file */
long file_end_pos = 0;		/* length of file */
struct mail_index_element *mail_table = NULL;	/* index to mail file */

/*
void push_free_list(long pos)
{
  position_list_type *new_pos;

  CREATE(new_pos, position_list_type, 1);
  new_pos->position = pos;
  new_pos->next = free_list;
  free_list = new_pos;
}
*/

/*
long pop_free_list(void)
{
  position_list_type *old_pos;
  long return_value;

  if ((old_pos = free_list) != 0) {
    return_value = free_list->position;
    free_list = old_pos->next;
    free(old_pos);
    return return_value;
  } else
    return file_end_pos;
}
*/
/*
mail_index_type *find_char_in_index(long searchee)
{
  mail_index_type *tmp;

  if (searchee < 0) {
    nmlog("SYSERR: Mail system -- non fatal error #1.");
    return 0;
  }
  for (tmp = mail_index; (tmp && tmp->recipient != searchee); tmp = tmp->next);

  return tmp;
}
*/

struct mail_index_element *find_mail(long id)
{
  struct mail_index_element *temp_e;

  for(temp_e = mail_table; temp_e; temp_e = temp_e->next)
    if(id == temp_e->pid)
      return(temp_e);

  return NULL;
}


/*
void write_to_file(void *buf, int size, long filepos)
{
  FILE *mail_file;

  mail_file = fopen(MAIL_FILE, "r+b");

  if (filepos % BLOCK_SIZE) {
    nmlog("SYSERR: Mail system -- fatal error #2!!!");
    no_mail = 1;
    return;
  }
  fseek(mail_file, filepos, SEEK_SET);
  fwrite(buf, size, 1, mail_file);

  * find end of file *
  fseek(mail_file, 0L, SEEK_END);
  file_end_pos = ftell(mail_file);
  fclose(mail_file);
  return;
}
*/
/*
void read_from_file(void *buf, int size, long filepos)
{
  FILE *mail_file;

  mail_file = fopen(MAIL_FILE, "r+b");

  if (filepos % BLOCK_SIZE) {
    nmlog("SYSERR: Mail system -- fatal error #3!!!");
    no_mail = 1;
    return;
  }
  fseek(mail_file, filepos, SEEK_SET);
  fread(buf, size, 1, mail_file);
  fclose(mail_file);
  return;
}
*/


/*
void index_mail(long id_to_index, long pos)
{
  mail_index_type *new_index;
  position_list_type *new_position;

  if (id_to_index < 0) {
    nmlog("SYSERR: Mail system -- non-fatal error #4.");
    return;
  }
  if (!(new_index = find_char_in_index(id_to_index))) {
    * name not already in index.. add it *
    CREATE(new_index, mail_index_type, 1);
    new_index->recipient = id_to_index;
    new_index->list_start = NULL;

    * add to front of list *
    new_index->next = mail_index;
    mail_index = new_index;
  }
  * now, add this position to front of position list *
  CREATE(new_position, position_list_type, 1);
  new_position->position = pos;
  new_position->next = new_index->list_start;
  new_index->list_start = new_position;
}
*/

/* SCAN_FILE */
/* scan_file is called once during boot-up.  It scans through the mail file
   and indexes all entries currently in the mail file. */
/*int scan_file(void)
{
  FILE *mail_file;
  header_block_type next_block;
  int total_messages = 0, block_num = 0;
  char buf[100];

  if (!(mail_file = fopen(MAIL_FILE, "r"))) {
    nmlog("Mail file non-existant... creating new file.");
    mail_file = fopen(MAIL_FILE, "w");
    fclose(mail_file);
    return 1;
  }
  while (fread(&next_block, sizeof(header_block_type), 1, mail_file)) {
    if (next_block.block_type == HEADER_BLOCK) {
      index_mail(next_block.header_data.to, block_num * BLOCK_SIZE);
      total_messages++;
    } else if (next_block.block_type == DELETED_BLOCK)
      push_free_list(block_num * BLOCK_SIZE);
    block_num++;
  }

  file_end_pos = ftell(mail_file);
  fclose(mail_file);
  sprintf(buf, "   %ld bytes read.", file_end_pos);
  nmlog(buf);
  if (file_end_pos % BLOCK_SIZE) {
    nmlog("SYSERR: Error booting mail system -- Mail file corrupt!");
    nmlog("SYSERR: Mail disabled!");
    return 0;
  }
  sprintf(buf, "   Mail file read -- %d messages.", total_messages);
  nmlog(buf);
  return 1;
}*/				/* end of scan_file */


void build_mail_index(void)
{
  int n1, n2;
  FILE *mail_index;
  struct mail_index_element *temp_e, *last_e = NULL;
  char index_name[40], line[256];

  sprintf(index_name, "%s", MAIL_INDEX_FILE);
  if(!(mail_index = fopen(index_name, "r"))) {
    nmlog("Nobody has any mail");
    mail_table = NULL;
    return;
  }

  do {
    get_line(mail_index, line);
    if(*line == '~') {
      fclose(mail_index);
      return;
    }
    CREATE(temp_e, struct mail_index_element, 1);
    sscanf(line, "%d %d", &n1, &n2);
    temp_e->pid = (long) n1;
    temp_e->flags = (long) n2;
    temp_e->mailbox = NULL;
    temp_e->next = NULL;
    if(!last_e) {
      mail_table = temp_e;
      last_e = mail_table;
    } else
      last_e->next = temp_e;
  } while(!feof(mail_index));
}


/* HAS_MAIL */
/* a simple little function which tells you if the guy has mail or not */
/*int has_mail(long recipient)
{
  if (find_char_in_index(recipient))
    return 1;
  return 0;
}
*/


/* STORE_MAIL  */
/* call store_mail to store mail.  (hard, huh? :-) )  Pass 3 arguments:
   who the mail is to (long), who it's from (long), and a pointer to the
   actual message text (char *).
*/
/*
void store_mail(long to, long from, char *message_pointer)
{
  header_block_type header;
  data_block_type data;
  long last_address, target_address;
  char *msg_txt = message_pointer;
  int bytes_written = 0;
  int total_length = strlen(message_pointer);

  assert(sizeof(header_block_type) == sizeof(data_block_type));
  assert(sizeof(header_block_type) == BLOCK_SIZE);

  if (from < 0 || to < 0 || !*message_pointer) {
    nmlog("SYSERR: Mail system -- non-fatal error #5.");
    return;
  }
  memset((char *) &header, 0, sizeof(header));	* clear the record *
  header.block_type = HEADER_BLOCK;
  header.header_data.next_block = LAST_BLOCK;
  header.header_data.from = from;
  header.header_data.to = to;
  header.header_data.mail_time = time(0);
  strncpy(header.txt, msg_txt, HEADER_BLOCK_DATASIZE);
  header.txt[HEADER_BLOCK_DATASIZE] = '\0';

  target_address = pop_free_list();	* find next free block *
  index_mail(to, target_address);	* add it to mail index in memory *
  write_to_file(&header, BLOCK_SIZE, target_address);

  if (strlen(msg_txt) <= HEADER_BLOCK_DATASIZE)
    return;			* that was the whole message *

  bytes_written = HEADER_BLOCK_DATASIZE;
  msg_txt += HEADER_BLOCK_DATASIZE;	* move pointer to next bit of text *

  *
   * find the next block address, then rewrite the header to reflect where
   * the next block is.
   *
  last_address = target_address;
  target_address = pop_free_list();
  header.header_data.next_block = target_address;
  write_to_file(&header, BLOCK_SIZE, last_address);

  * now write the current data block *
  memset((char *) &data, 0, sizeof(data));	* clear the record *
  data.block_type = LAST_BLOCK;
  strncpy(data.txt, msg_txt, DATA_BLOCK_DATASIZE);
  data.txt[DATA_BLOCK_DATASIZE] = '\0';
  write_to_file(&data, BLOCK_SIZE, target_address);
  bytes_written += strlen(data.txt);
  msg_txt += strlen(data.txt);

  *
   * if, after 1 header block and 1 data block there is STILL part of the
   * message left to write to the file, keep writing the new data blocks and
   * rewriting the old data blocks to reflect where the next block is.  Yes,
   * this is kind of a hack, but if the block size is big enough it won't
   * matter anyway.  Hopefully, MUD players won't pour their life stories out
   * into the Mud Mail System anyway.
   * 
   * Note that the block_type data field in data blocks is either a number >=0,
   * meaning a link to the next block, or LAST_BLOCK flag (-2) meaning the
   * last block in the current message.  This works much like DOS' FAT.
   *

  while (bytes_written < total_length) {
    last_address = target_address;
    target_address = pop_free_list();

    * rewrite the previous block to link it to the next *
    data.block_type = target_address;
    write_to_file(&data, BLOCK_SIZE, last_address);

    * now write the next block, assuming it's the last.  *
    data.block_type = LAST_BLOCK;
    strncpy(data.txt, msg_txt, DATA_BLOCK_DATASIZE);
    data.txt[DATA_BLOCK_DATASIZE] = '\0';
    write_to_file(&data, BLOCK_SIZE, target_address);

    bytes_written += strlen(data.txt);
    msg_txt += strlen(data.txt);
  }
}*/				/* store mail */


/* new store_mail */
void store_mail(long to, long from, char *message_pointer, char *subj)
{
  int rnum;
  char *msg = message_pointer;
  /*struct mail_data *mdata;*/
  struct obj_data *mail_obj = create_obj();
  struct char_data *recipient;
  struct mail_index_element *mail_e;
  /*struct char_file_u tmp_store;*/

  struct obj_data *read_object(int nr, int type);
  int copy_object(struct obj_data * dest, struct obj_data * src);

  if((rnum = real_object(1)) < 0) {
    nmlog("SYSERR: Object #1 (mail) does not exist!");
    return;
  }
  copy_object(mail_obj, obj_proto + rnum);
  mail_obj->item_number = rnum;
/*
  if(!(mail_obj = read_object(1, VIRTUALRM))) {
    nmlog("SYSERR: Object #1 (mail) does not exist!");
    return;
  }
*/
  if(mail_obj->action_description)
    free(mail_obj->action_description);
  mail_obj->action_description = str_dup(msg);
  mail_obj->worn_on = -1;
  CREATE(mail_obj->mail, struct mail_data, 1);
  mail_obj->mail->to = to;
  mail_obj->mail->from = from;
  mail_obj->mail->date = time(0);
  mail_obj->mail->subject = str_dup(subj);
  SET_BIT(mail_obj->mail->flags, MAIL_NEW);

  mail_e = find_mail(to);

  recipient = get_char_by_id(to);
  if(recipient) {
    send_to_char("&+GYou have new mail.&+w\r\n", recipient);
/*    obj_to_char(mail_obj, recipient);
    return;*/
    mail_obj->next_content = recipient->mail;
    recipient->mail = mail_obj;
    save_mail(recipient);
    /*if(mail_e) {
      mail_obj->next_content = mail_e->mailbox;
      mail_e->mailbox = mail_obj;
    }
    update_mail_index(to, mail_obj);*/
  } else /*if(mail_e)*/ {
    /*load_mail(to);*/
    append_mail(get_name_by_id(to), mail_obj);
/*    mail_obj->next_content = mail_e->mailbox;
    mail_e->mailbox = mail_obj;
    update_mail_index(to, mail_obj);
    extract_mail(to);*/
  }/* else {
    update_mail_index(to, mail_obj);
  }*/
}
/*    load_char(get_name_by_id(to), &tmp_store, recipient);
    obj_to_char(mail_obj, recipient);
    recipient->quitting = TRUE;
    extract_char(recipient);*/


/* READ_DELETE */
/* read_delete takes 1 char pointer to the name of the person whose mail
you're retrieving.  It returns to you a char pointer to the message text.
The mail is then discarded from the file and the mail index. */
/*
char *read_delete(long recipient)
* recipient is the name as it appears in the index.
   recipient_formatted is the name as it should appear on the mail
   header (i.e. the text handed to the player) *
{
  header_block_type header;
  data_block_type data;
  mail_index_type *mail_pointer, *prev_mail;
  position_list_type *position_pointer;
  long mail_address, following_block;
  char *message, *tmstr, buf[200], *tbuf;
  size_t string_size;

  if (recipient < 0) {
    nmlog("SYSERR: Mail system -- non-fatal error #6.");
    return 0;
  }
  if (!(mail_pointer = find_char_in_index(recipient))) {
    nmlog("SYSERR: Mail system -- post office spec_proc error?  Error #7.");
    return 0;
  }
  if (!(position_pointer = mail_pointer->list_start)) {
    nmlog("SYSERR: Mail system -- non-fatal error #8.");
    return 0;
  }
  if (!(position_pointer->next)) {	* just 1 entry in list. *
    mail_address = position_pointer->position;
    free(position_pointer);

    * now free up the actual name entry *
    if (mail_index == mail_pointer) {	* name is 1st in list *
      mail_index = mail_pointer->next;
      free(mail_pointer);
    } else {
      * find entry before the one we're going to del *
      for (prev_mail = mail_index;
	   prev_mail->next != mail_pointer;
	   prev_mail = prev_mail->next);
      prev_mail->next = mail_pointer->next;
      free(mail_pointer);
    }
  } else {
    * move to next-to-last record *
    while (position_pointer->next->next)
      position_pointer = position_pointer->next;
    mail_address = position_pointer->next->position;
    free(position_pointer->next);
    position_pointer->next = 0;
  }

  * ok, now lets do some readin'! *
  read_from_file(&header, BLOCK_SIZE, mail_address);

  if (header.block_type != HEADER_BLOCK) {
    nmlog("SYSERR: Oh dear.");
    no_mail = 1;
    nmlog("SYSERR: Mail system disabled!  -- Error #9.");
    return 0;
  }
  tmstr = asctime(localtime(&header.header_data.mail_time));
  *(tmstr + strlen(tmstr) - 1) = '\0';

  * this is to check for bad sender names..take this out and put the
     get_name_by_id in blace of the tbuf thing below to take this fix out
  *
  if(!(tbuf = get_name_by_id(header.header_data.from)))
    nmlog("SYSERR: Bad sender name in mail!");

  sprintf(buf, " * * * * Midgaard Mail System * * * *\r\n"
	  "Date: %s\r\n"
	  "  To: %s\r\n"
	  "From: %s\r\n\r\n", tmstr, get_name_by_id(recipient),
	  tbuf ? tbuf : "BAD_SENDER");

  string_size = (sizeof(char) * (strlen(buf) + strlen(header.txt) + 1));
  CREATE(message, char, string_size);
  strcpy(message, buf);
  strcat(message, header.txt);
  message[string_size - 1] = '\0';
  following_block = header.header_data.next_block;

  * mark the block as deleted *
  header.block_type = DELETED_BLOCK;
  write_to_file(&header, BLOCK_SIZE, mail_address);
  push_free_list(mail_address);

  while (following_block != LAST_BLOCK) {
    read_from_file(&data, BLOCK_SIZE, following_block);

    string_size = (sizeof(char) * (strlen(message) + strlen(data.txt) + 1));
    RECREATE(message, char, string_size);
    strcat(message, data.txt);
    message[string_size - 1] = '\0';
    mail_address = following_block;
    following_block = data.block_type;
    data.block_type = DELETED_BLOCK;
    write_to_file(&data, BLOCK_SIZE, mail_address);
    push_free_list(mail_address);
  }

  return message;
}
*/

/*****************************************************************
** Below is the spec_proc for a postmaster using the above       **
** routines.  Written by Jeremy Elson (jelson@server.cs.jhu.edu) **
*****************************************************************/

SPECIAL(postmaster)
{
  char buf[128];

  if (!ch->desc || IS_NPC(ch))
    return 0;			/* so mobs don't get caught here */

  if(ch->desc->original) {
    sprintf(buf, "SYSERR: %s attempting to %s %s's mail!",
      GET_NAME(ch->desc->original), cmd_info[cmd].command,
      GET_NAME(ch));
    nmlog(buf);
    sprintf(buf, "You can't %s other people's mail.\r\n",
      cmd_info[cmd].command);
    send_to_char(buf, ch);
  }

  if (!(CMD_IS("mail") || CMD_IS("check") || CMD_IS("receive") ||
    CMD_IS("put") || CMD_IS("get")))/* || CMD_IS("read")))*/
    return 0;
/*
  if (no_mail) {
    send_to_char("Sorry, the mail system is having technical difficulties.\r\n", ch);
    return 0;
  }
*/
  if (CMD_IS("mail")) {
    postmaster_send_mail(ch, me, cmd, argument);
    return 1;
  } else if (CMD_IS("check")) {
    postmaster_check_mail(ch, me, cmd, argument);
    return 1;
  } else if (CMD_IS("receive")) {
    postmaster_receive_mail(ch, me, cmd, argument);
    return 1;
  } else if (CMD_IS("put")) {
    return 0;
    postmaster_put_mail(ch, me, cmd, argument);
    return 1;
  } else if (CMD_IS("get")) {
    postmaster_get_mail(ch, me, cmd, argument);
    return 1;
/*
  } else if (CMD_IS("read")) {
    postmaster_read_mail(ch, me, cmd, argument);
    return 1;
*/
  } else
    return 0;
}


void postmaster_send_mail(struct char_data * ch, struct char_data *mailman,
			  int cmd, char *arg)
{
  long recipient;
  char buf[256];

  if (GET_LEVEL(ch) < MIN_MAIL_LEVEL) {
    sprintf(buf, "&+r$n &+rtells you, 'Sorry, you have to be level %d to send mail!'",
	    MIN_MAIL_LEVEL);
    act(buf, FALSE, mailman, 0, ch, TO_VICT);
    return;
  }
  one_argument(arg, buf);

  if (!*buf) {			/* you'll get no argument from me! */
    act("&+r$n &+rtells you, 'You need to specify an addressee!'",
	FALSE, mailman, 0, ch, TO_VICT);
    return;
  }
  if ((GET_GOLD(ch) < STAMP_PRICE) && (GET_LEVEL(ch) < LVL_IMMORT)) {
    sprintf(buf, "&+r$n &+rtells you, 'A stamp costs %d coins.'\r\n"
	    "$n tells you, '...which I see you can't afford.'", STAMP_PRICE);
    act(buf, FALSE, mailman, 0, ch, TO_VICT);
    return;
  }
  if ((recipient = get_id_by_name(buf)) < 0) {
    act("&+r$n &+rtells you, 'No one by that name is registered here!'",
	FALSE, mailman, 0, ch, TO_VICT);
    return;
  }
  act("$n starts to write some mail.", TRUE, ch, 0, 0, TO_ROOM);
  if(GET_LEVEL(ch) < LVL_IMMORT) {
    sprintf(buf, "&+r$n &+rtells you, 'I'll take %d coins for the stamp.'\r\n",
	STAMP_PRICE);
    act(buf, FALSE, mailman, 0, ch, TO_VICT);
    GET_GOLD(ch) -= STAMP_PRICE;
  }
/*
  sprintf(buf, "$n tells you, 'Write your message, use @ on a new line when done.'");
  act(buf, FALSE, mailman, 0, ch, TO_VICT);
  SET_BIT(PLR_FLAGS(ch), PLR_MAILING | PLR_WRITING);
*/
  ch->desc->mail_to = recipient;
  ch->desc->str = (char **) malloc(sizeof(char *));
  *(ch->desc->str) = NULL;
  ch->desc->max_str = MAX_MAIL_SIZE;
  send_to_char("\r\nSubject: ", ch);
  STATE(ch->desc) = CON_MAIL_SUBJ;
}


void postmaster_check_mail(struct char_data * ch, struct char_data *mailman,
			  int cmd, char *arg)
{
  int i = 1, to_ch, is_new;
  char buf[8172], mail_date[25];
  /*struct mail_index_element *mail_e;*/
  struct obj_data *letter;
/*
  send_to_char("The postmaster tells you, 'Check your inventory for mail.\r\n", ch);
  return;
*/
/*  if(!(mail_e = find_mail(GET_IDNUM(ch)))) {*/
  if(!ch->mail) {
    sprintf(buf, "&+r$n &+rtells you, 'Sorry, you don't have any mail waiting.'");
    act(buf, FALSE, mailman, 0, ch, TO_VICT);
    return;
  }

  sprintf(buf, "    ## Date:      From:           To:             Subject:\r\n");
  for(letter = ch->mail; letter; letter = letter->next_content) {
    to_ch = (letter->mail->to == GET_IDNUM(ch));
    is_new = letter->mail && (IS_SET(letter->mail->flags, MAIL_NEW));
    strncpy(mail_date, (char *) asctime(localtime(&letter->mail->date)), sizeof(mail_date));
    mail_date[10] = '\0';
    sprintf(buf, "%s%c %c %2d %-10s %-15s %-15s %s\r\n", buf, to_ch ? '+' : ' ',
      is_new ? 'N' : ' ', i, mail_date,
      get_name_by_id(letter->mail->from),
      get_name_by_id(letter->mail->to), letter->mail->subject ?
      letter->mail->subject : "(none)");
    i++;
  }
  send_to_char(buf, ch);
}


void postmaster_receive_mail(struct char_data * ch, struct char_data *mailman,
			  int cmd, char *arg)
{
  int i = 0;
  char buf[256];
  struct obj_data *obj, *last = NULL;
  /*struct mail_index_element *mail_e;*/
/*
  send_to_char("The postmaster tells you, 'Check your inventory for mail.\r\n", ch);
  return;
*/
/*  if (!(mail_e = find_mail(GET_IDNUM(ch)))) {*/
  if(!ch->mail) {
    sprintf(buf, "&+r$n &+rtells you, 'Sorry, you don't have any new mail.'");
    act(buf, FALSE, mailman, 0, ch, TO_VICT);
    return;
  }
/*  if (!(mail_e->mailbox) || !IS_SET(mail_e->flags, MI_HAS_NEW)) {
    sprintf(buf, "&+r$n &+rtells you, 'Sorry, you don't have any new mail.'");
    act(buf, FALSE, mailman, 0, ch, TO_VICT);
    return;
  }*/

  for(obj = ch->mail; obj; ) {
    if(IS_SET(obj->mail->flags, MAIL_NEW)) {
      if(!last) {
	ch->mail = obj->next_content;
	obj->next_content = NULL;
	obj_to_char(obj, ch);
	REMOVE_BIT(obj->mail->flags, MAIL_NEW);
	obj = ch->mail;
	i++;
      } else {
	last->next_content = obj->next_content;
	obj->next_content = NULL;
	obj_to_char(obj, ch);
	REMOVE_BIT(obj->mail->flags, MAIL_NEW);
	obj = last->next_content;
	i++;
      }
    } else {
      last = obj;
      obj = obj->next_content;
    }
  }

  /* save mail? GPN */
  save_mail(ch);
  
  switch (i) {
  case 0:
    sprintf(buf, "&+r$n &+rtells you, 'Sorry, you don't have any new mail.'");
    break;
  case 1:
    sprintf(buf, "$n gives you a piece of mail.");
    break;
  default:
    sprintf(buf, "$n gives you %d pieces of mail.", i);
  }

  act(buf, FALSE, mailman, 0, ch, TO_VICT);
  if(i) {
    act("$N gives $n some mail.", FALSE, ch, 0, mailman, TO_ROOM);
    save_mail(ch);
  }

  /*update_mail_index(GET_IDNUM(ch), mail_e->mailbox);*/

/*
  while (has_mail(GET_IDNUM(ch))) {
    obj = create_obj();
    obj->item_number = NOTHING;
    obj->name = str_dup("mail paper letter mudmail");
    obj->short_description = str_dup("a piece of mail");
    obj->description = str_dup("Someone has left a piece of mail here.");

    GET_OBJ_TYPE(obj) = ITEM_NOTE;
    GET_OBJ_WEAR(obj) = ITEM_WEAR_TAKE | ITEM_WEAR_HOLD;
    GET_OBJ_WEIGHT(obj) = 1;
    GET_OBJ_COST(obj) = 30;
    GET_OBJ_RENT(obj) = 10;
    obj->action_description = read_delete(GET_IDNUM(ch));

    if (obj->action_description == NULL)
      obj->action_description =
	str_dup("Mail system error - please report.  Error #11.\r\n");

    obj_to_char(obj, ch);

    act("$n gives you a piece of mail.", FALSE, mailman, 0, ch, TO_VICT);
    act("$N gives $n a piece of mail.", FALSE, ch, 0, mailman, TO_ROOM);
  }
*/
}


void postmaster_put_mail(struct char_data * ch, struct char_data *mailman,
			  int cmd, char *arg)
{
  int i = 0;
  char buf[1024], num[256];
  struct obj_data *obj = NULL, *list = NULL;
/*  struct mail_index_element *mail_e;*/

  /*mail_e = find_mail(GET_IDNUM(ch));*/
  one_argument(arg, num);

  if(is_abbrev(num, "all")) {
    act("&+r$n &+rtells you, 'Sorry, put all is broke.  You'll have to put messages in your box individually.'", FALSE, mailman, 0, ch, TO_VICT);
    return;
    /*if(mail_e)
      list = mail_e->mailbox;*/
    for(obj = ch->carrying; obj; ) {
      if(IS_SET(GET_OBJ_EXTRA(obj), ITEM_MAIL)) {
	obj_from_char(obj);
	obj->next_content = list;
	list = obj;
	obj = ch->carrying;
	i++;
      } else {
	obj = obj->next_content;
      }
    }
    if(!list) {
      send_to_char("You're not carrying any mail.\r\n", ch);
      return;
    } else {
      if(i == 1)
	sprintf(buf, "You put a piece of mail in your mailbox.\r\n");
      else
	sprintf(buf, "You put %d pieces of mail in your mailbox.\r\n", i);
      send_to_char(buf, ch);
      update_mail_index(GET_IDNUM(ch), list);
    }
  } else if(*num && !(obj = get_obj_in_list_vis(ch, num, ch->carrying))) {
    send_to_char("You don't seem to be carrying that.\r\n", ch);
  } else if(obj) {
    if(!IS_SET(GET_OBJ_EXTRA(obj), ITEM_MAIL)) {
      send_to_char("You can't put that in your mailbox.\r\n", ch);
    } else {
      obj->next_content = ch->mail;
      ch->mail = obj;
      send_to_char("You put a piece of mail in your mailbox.\r\n", ch);
	/*update_mail_index(GET_IDNUM(ch), obj);*/
      save_mail(ch);
    }
  } else {
    sprintf(buf, "&+r$n &+rtells you, 'You can either 'put all' to put all your mail in");
    sprintf(buf, "%s your inbox, or 'put <object>' to put an individual", buf);
    sprintf(buf, "%s message in your mailbox.  For example, 'put 2.mail'", buf);
    sprintf(buf, "%s to put the 2nd message from your inventory to your", buf);
    sprintf(buf, "%s mailbox.'", buf);
    act(buf, FALSE, mailman, 0, ch, TO_VICT);
  }
}


void postmaster_get_mail(struct char_data * ch, struct char_data *mailman,
			  int cmd, char *arg)
{
  char buf[1024], num[256];
  int msgnum, i = 1;
  struct obj_data *obj, *last = NULL;
  /*struct mail_index_element *mail_e;*/

  one_argument(arg, num);

  if(is_abbrev(num, "new")) {
    postmaster_receive_mail(ch, mailman, cmd, arg);
    return;
  } else if(*num && is_number(num)) {
/*    if(!(mail_e = find_mail(GET_IDNUM(ch)))) {*/
      if(!ch->mail) {
      send_to_char("Your mailbox is empty.\r\n", ch);
      return;
    } else {
      msgnum = atoi(num);
      for(obj = ch->mail; obj; ) {
	if(i == msgnum) {
	  if(!last) {
	    ch->mail = obj->next_content;
	    obj->next_content = NULL;
	    obj_to_char(obj, ch);
	    REMOVE_BIT(obj->mail->flags, MAIL_NEW);
	    obj = ch->mail;
	  } else {
	    last->next_content = obj->next_content;
	    obj->next_content = NULL;
	    obj_to_char(obj, ch);
	    REMOVE_BIT(obj->mail->flags, MAIL_NEW);
	    obj = last->next_content;
	  }
	  send_to_char("You get a piece of mail from your mailbox.\r\n", ch);
	  act("$n gets some mail from $s mailbox.", FALSE, ch, 0, mailman, TO_ROOM);
	  save_mail(ch);
	  return;
	} else {
          last = obj;
          obj = obj->next_content;
          i++;
	}
      }
    send_to_char("That you don't have that many letters.\r\n", ch);
    }
  } else {
    sprintf(buf, "&+r$n &+rtells you, 'You can either 'get new' to get your new messages");
    sprintf(buf, "%s from your mailbox, or 'get <message number>' to get a certain message.", buf);
    sprintf(buf, "%s For Example, type 'get 2' to get message number 2.'", buf);
    act(buf, FALSE, mailman, 0, ch, TO_VICT);
  }
}


void postmaster_read_mail(struct char_data * ch, struct char_data *mailman,
			  int cmd, char *arg)
{
}


/*void remove_mail(long id)
{
  char name[40];
  struct mail_index_element *last_e = NULL, *temp_e;

  for(temp_e = mail_table; temp_e; temp_e = temp_e->next)
    if(id == temp_e->pid) {
      if(!last_e) {
	mail_table = temp_e->next;
	free(temp_e);
      } else {
	last_e->next = temp_e->next;
	free(temp_e);
      }
      sprintf(name, "%s/%s", MAIL_PREFIX, get_name_by_id(id));
      remove(name);
      if(!mail_table)
	remove(MAIL_INDEX_FILE);
      return;
    }
  nmlog("SYSERR: Attempt to remove a nonexistant mail element.");
}*/


/*void update_mail_index(long id, struct obj_data *box)
{
  int mail_count = 0, i;
  FILE *mail_index, *mail_file;
  struct mail_index_element *temp_e;
  struct obj_data *letter;
  char index_name[40], pl_name[40], mail_name[40], buf[256];
  struct char_data *t;

  if(!(temp_e = find_mail(id))) {
    CREATE(temp_e, struct mail_index_element, 1);
    temp_e->pid = id;
    temp_e->mailbox = box;
    temp_e->next = mail_table;
    mail_table = temp_e;
  } else {
    temp_e->mailbox = box;
  }

  if(!box) {
    remove_mail(id);
    return;
  }

  temp_e->flags = 0;
  if(box != NULL) {
    SET_BIT(temp_e->flags, MI_HAS_MAIL);
    for(letter = box; letter; letter = letter->next_content) {
      if(IS_SET(letter->mail->flags, MAIL_NEW))
	SET_BIT(temp_e->flags, MI_HAS_NEW);
      mail_count++;
    }
    if(mail_count >= max_mail_save)
      SET_BIT(temp_e->flags, MI_FULL);
    else if(mail_count >= (max_mail_save * 3) / 4)
      SET_BIT(temp_e->flags, MI_FULL);

    strcpy(pl_name, get_name_by_id(id));
    for(i = 0; (*(pl_name + i) = LOWER(*(pl_name + i))); i++);
    sprintf(mail_name, "%s/%s", MAIL_PREFIX, pl_name);
    if(!(mail_file = fopen(mail_name, "w"))) {
      sprintf(buf, "SYSERR: Can't write mail to %s.", mail_name);
      return;
    }
    Crash_save(NULL, box, (t = get_char_by_id(id)) != NULL ? max_mail_save
      : 0, mail_file);
    fclose(mail_file);
  }

  sprintf(index_name, "%s", MAIL_INDEX_FILE);
  if(!(mail_index = fopen(index_name, "w"))) {
    nmlog("SYSERR: Error opening mail index file mail/mail_index");
    return;
  }

  for(temp_e = mail_table; temp_e; temp_e = temp_e->next)
    fprintf(mail_index, "%d %d\n", (int) temp_e->pid, (int) temp_e->flags);

  fprintf(mail_index, "~\n");
  fclose(mail_index);
}*/


/*void load_mail(long id)
{
  char *pl_name, mail_name[40];
  FILE *mail_file;
  struct mail_index_element *mail_e;  

  if(!(mail_e = find_mail(id)))
    return;

  pl_name = get_name_by_id(id);
  sprintf(mail_name, "%s/%s", MAIL_PREFIX, pl_name);
  if(!(mail_file = fopen(mail_name, "r"))) {
    sprintf(buf, "SYSERR: Can't read mail to %s.", mail_name);
    return;
  }
  mail_e->mailbox = Crash_load(NULL, mail_file);
  fclose(mail_file);
}
*/


void extract_mail(struct char_data *ch)
{
  struct obj_data *letter, *next;
/*  struct mail_index_element *mail_e;*/

  /*if(!(mail_e = find_mail(id)))*/
  if(!ch->mail)
    return;

  for(letter = ch->mail; letter; ) {
    next = letter->next_content;
    extract_obj(letter);
    letter = next;
  }
}


int load_mail(struct char_data *ch)
{
  FILE *fl;
  char filename[40];
  char *p;

  sprintf(filename, "%s/%s", MAIL_PREFIX, ch->player.name);
  for(p = filename; *p; p++)
    *p = LOWER(*p); 
  if(!(fl = fopen(filename, "r")))
    return 0;

  ch->mail = Crash_load(NULL, fl);
  fclose(fl);
  return 1;
}


void save_mail(struct char_data * ch)
{
  FILE *fl;
  char filename[40];
  char *p;

  /* GPN */
  if((ch->desc && ch->desc->original) || !*ch->player.name)
    return;

  sprintf(filename, "%s/%s", MAIL_PREFIX, ch->player.name);
  for(p = filename; *p; p++)
    *p = LOWER(*p); 

  if (!ch->mail) { /* GPN */
    unlink(filename);
    return;
  }
  chmod(filename, S_IREAD | S_IWRITE);

  if (!(fl = fopen(filename, "w"))) {
    sprintf(buf, "error opening output file: %s", filename);
    perror(buf);
    exit(1);
  }

  Crash_save(ch, ch->mail, 0, fl);
  fclose(fl);
  chmod(filename, S_IREAD);
}


void append_mail(char *name, struct obj_data *mail)
{
  FILE *fl;
  char filename[40];
  char *p;

  sprintf(filename, "%s/%s", MAIL_PREFIX, name);
  for(p = filename; *p; p++)
    *p = LOWER(*p); 

  chmod(filename, S_IREAD | S_IWRITE);

  if (!(fl = fopen(filename, "wa"))) {
    sprintf(buf, "error opening output file: %s", filename);
    perror(buf);
    exit(1);
  }

  Crash_save(NULL, mail, 0, fl);
  fclose(fl);
  chmod(filename, S_IREAD);
}


void check_mail_status(struct char_data *ch)
{
  struct obj_data *ml;
  byte has_new = FALSE;
  int count = 0;

  for(ml = ch->mail; ml; ml = ml->next_content, count++)
    if(IS_SET(ml->mail->flags, MAIL_NEW))
      has_new = TRUE;

  if(has_new)
    send_to_char("&+GYou have new mail waiting.\r\n", ch);
  if(count >= max_mail_save)
    send_to_char("&+RYour mailbox is FULL!  Better clean it out.\r\n", ch);
  else if(count > (max_mail_save * 3) / 4)
    send_to_char("&+YYour mailbox is almost full!!\r\n", ch);
}
