/* menu.c

   This file handles all the new menu interface code for obuild.

   By Samedi

*/

#define __MENU_C__
#include "conf.h"
#include "sysdep.h"

#include "menu.h"
#include "structs.h"
#include "interpreter.h"
#include "utils.h"
#include "comm.h"
#include "screen.h"
#include "db.h"

/* menu colors 1, 2, and 3 */
#define MC1	CCWHT(ch, C_SPR)	/* number	*/
#define MC2 	CCMAG(ch, C_SPR)	/* )		*/
#define MC3 	CCWHT(ch, C_SPR)	/* field	*/
#define MC4 	CCMAG(ch, C_SPR)	/* colon	*/
#define MC5 	CCCYN(ch, C_SPR)	/* data		*/

/* menu contexts */
#define CONTEXT_TOP		0	/* at top menu			*/
#define CONTEXT_SAVE		1	/* do you wish to save?		*/
#define CONTEXT_ROOM_NAME	2	/* get room name		*/
#define CONTEXT_DESCRIPTION	3	/* do you want to change desc?	*/
#define CONTEXT_SECTOR_TYPE	4	/* room sector type		*/
#define CONTEXT_ROOM_FLAGS	5	/* room flags			*/
#define CONTEXT_EX_DESC		6	/* extra descrip menu		*/
#define CONTEXT_EX_DESC_ADD	7	/* extra descrip add menu	*/
#define CONTEXT_EX_DESC_KEY	8	/* extra descrip keyword change	*/
#define CONTEXT_EX_DESC_DESC	9	/* extra descrip descrip change	*/
#define CONTEXT_EX_DESC_DEL	10	/* extra descrip delete		*/
#define CONTEXT_EXIT		11	/* exit menu			*/
#define CONTEXT_EXIT_NEW	12	/* exit creation		*/
#define CONTEXT_EXIT_NEW_WAYS	13	/* exit creation oneway/twoway	*/
#define CONTEXT_EXIT_NEW_1	14	/* exit creation oneway vnum	*/
#define CONTEXT_EXIT_NEW_2	15	/* exit creation twoway vnum	*/
#define CONTEXT_EXIT_ROOM	16
#define CONTEXT_EXIT_DESCRIP	17
#define CONTEXT_EXIT_FLAGS	18
#define CONTEXT_EXIT_KEYWORD	19
#define CONTEXT_EXIT_KEY	20
#define CONTEXT_EXIT_DELETE	21
#define CONTEXT_ROOM_DAMAGE     22
#define CONTEXT_DAMAGE_AMOUNT   23
#define CONTEXT_DAMAGE_MESSAGE  24
#define CONTEXT_DAMAGE_INTERVAL 25
#define CONTEXT_DAMAGE_NEUTRAL  26


/* external variables */
extern struct room_data *world;
extern char *sector_types[];
extern char *room_bits[];
extern char *dirs[];
extern char *dir_abbrev[];
extern int rev_dir[];
extern char *OK;
extern char *exit_bits[];
extern char *affected_bits[];
extern char *affected_bits2[];

/* external functions */
ACMD(do_rset);
ACMD(do_redit);
ACMD(do_save);
int isname(char *str, char *namelist);


/* Find a flag in a given bitvector that matches "txt" and
   toggle it.  "Mask" is a bitvector of flags that can't be set
   so individual or groups of flags can be untoggleable (ROOM_HOUSE,
   MOB_SPEC, etc).
*/
int check_toggle_flags(char *txt, char *names[], int *bitvector,
			int mask)
{
  int i = 0;

  if(!*txt || *txt == '\r' || *txt == '\n')
    return FALSE;

  while(*room_bits[i] != '\n') {
    if(!strn_cmp(txt, names[i], strlen(names[i]))) {
      if((1 << i) & ~mask) {
	TOGGLE_BIT(*bitvector, 1 << i);
	return TRUE;
      } else {
	return TRUE;
      }
    }
    i++;
  }
  return FALSE;
}


/* Find a "type" from a text entry and set a type variable.
   This is used to set room sector types, item types, etc
*/
int check_set_type(char *txt, char *names[], int *type)
{
  int i = 0;
  char tmp[MAX_INPUT_LENGTH];

  if(!*txt || *txt == '\r' || *txt == '\n')
    return FALSE;

  while(*names[i] != '\n') {
    if(!strn_cmp(txt, names[i], strlen(names[i]))) {
      *type = i;
      half_chop(txt, tmp, txt);
      return TRUE;
    }
    i++;
  }
  return FALSE;
}


void *find_edesc_by_key(struct extra_descr_data *edesc, char *keyword)
{
  struct extra_descr_data *d;

  for(d = edesc ; d; d = d->next)
    if(isname(keyword, d->keyword))
      return d;

  return NULL;
}


void *find_edesc_by_num(struct extra_descr_data *edesc, int num)
{
  int i;
  struct extra_descr_data *d;

  for(d = edesc, i = 2; d; d = d->next, i++)
    if(i == num)
      return d;

  return NULL;
}


void build_room_menu(struct char_data *ch)
{
  char buf[4096];  /* increase this for bigger menus */
  char buf2[512], buf3[512];
  int i, twoway, to_room;
  struct room_data *room = world + ch->in_room;
  struct extra_descr_data *desc;
  struct menu_data *mdata = (struct menu_data*)ch->player.parse_data;
  struct room_direction_data *dir;

  switch(mdata->context) {

  case CONTEXT_TOP:
    sprintf(buf, "%sRoom Vnum%s: %s%d\r\n", MC1, MC2, MC5, room->number);
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%s\r\n", buf, MC1,
		  1, MC2, MC3, "Room Name", MC4, MC5, room->name);
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%s\r\n", buf, MC1,
		  2, MC2, MC3, "Description", MC4, MC5,
		  room->description ? "(Not Shown)" : "(None)");
    sprinttype(room->sector_type, sector_types, buf2);
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%s\r\n", buf, MC1,
		  3, MC2, MC3, "Sector Type", MC4, MC5, buf2);
    sprintbit(room->room_flags, room_bits, buf2);
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%s\r\n", buf, MC1,
		  4, MC2, MC3, "Flags", MC4, MC5, buf2);
    /* extra descriptions */
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s", buf, MC1,
		  5, MC2, MC3, "Extra Descriptions", MC4, MC5);
    if(!room->ex_description)
      strcat(buf, "(None)\r\n");
    else {
      for(desc = room->ex_description; desc; desc = desc->next)
        sprintf(buf, "%s%s ", buf, desc->keyword);
      strcat(buf, "\r\n");
    }
    /* GPN damage rooms */
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s", buf, MC1,
                  6, MC2, MC3, "Damage", MC4, MC5);
    if (!room->damage.dam)
      strcat(buf, "(None)\r\n");
    else
      sprintf(buf, "%s%d damage\r\n", buf, room->damage.dam);
    /* GPN end damage */
    /* exits */
#define DMN 7	/* direction menu number */
    for(i = DMN; i < NUM_OF_DIRS + DMN; i++) {
      sprintf(buf2, "Exit %s", dirs[i - DMN]);
      sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s", buf, MC1,
		  i, MC2, MC3, buf2, MC4, MC5);
      if(!room->dir_option[i - DMN])
        strcat(buf, "No Exit\r\n");
      else if(room->dir_option[i - DMN]->to_room == NOWHERE)
        strcat(buf, "To Nowhere\r\n");
      else {
        to_room = room->dir_option[i - DMN]->to_room;
        if(world[to_room].dir_option[rev_dir[i - DMN]] &&
	   world[to_room].dir_option[rev_dir[i - DMN]]->to_room ==
	 	ch->in_room)
	  twoway = 2;
        else
	  twoway = 1;
        sprintf(buf, "%s(%d) %d\r\n", buf, twoway, world[to_room].number);
      }
    }
    break;

  case CONTEXT_EX_DESC:
    /* if parse_me is NULL, we're at the top edesc menu */
    if(!ch->player.parse_me) {
      sprintf(buf, "%sRoom Vnum%s: %s%d  %sExtra Descrips\r\n", MC3, MC4,
		  MC5, room->number, MC3);
      sprintf(buf, "%s%s%2d%s) %s%-20s\r\n", buf, MC1,
		  1, MC2, MC3, "Add an Extra Desc");
      for(desc = room->ex_description, i = 2; desc; desc = desc->next, i++)
        sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%s\r\n", buf, MC1,
		  i, MC2, MC3, "Extra Description", MC4, MC5, desc->keyword);
    } else {	/* show menu for a specific edesc */
      desc = (struct extra_descr_data *)ch->player.parse_me;
      sprintf(buf, "%sExtra Description\r\n", MC1);
      sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%s\r\n", buf, MC1,
		1, MC2, MC3, "Keywords", MC4, MC5, desc->keyword);
      sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%s\r\n", buf, MC1,
		2, MC2, MC3, "Description", MC4, MC5,
		desc->description ? "(Not Shown)" : "(None)");
      sprintf(buf, "%s%s%2d%s) %s%-20s\r\n", buf, MC1,
		3, MC2, MC3, "Delete This Edesc");
    }
    break;

  case CONTEXT_EXIT:
    i = (int)ch->player.parse_me;
    dir = room->dir_option[i];
    sprintf(buf, "%sRoom Vnum%s: %s%d  %sExit%s: %s%s\r\n", MC3, MC4,
		MC5, room->number, MC3, MC4, MC5, dirs[i]);
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%d\r\n", buf, MC1,
		1, MC2, MC3, "Connects to", MC4, MC5,
		world[dir->to_room].number);
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%s\r\n", buf, MC1,
		2, MC2, MC3, "Description", MC4, MC5,
		dir->general_description ? "(Not Shown)" : "(None)");
    sprintbit(dir->exit_info, exit_bits, buf2);
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%s\r\n", buf, MC1,
		3, MC2, MC3, "Flags", MC4, MC5, buf2);
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%s\r\n", buf, MC1,
		4, MC2, MC3, "Keyword", MC4, MC5,
		dir->keyword ? dir->keyword : "(None)");
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%d\r\n", buf, MC1,
		5, MC2, MC3, "Key Vnum", MC4, MC5, dir->key);
    sprintf(buf, "%s%s%2d%s) %s%-20s\r\n", buf, MC1,
		6, MC2, MC3, "Delete Exit");
    break;
  case CONTEXT_ROOM_DAMAGE:
    sprintf(buf, "%s%2d%s) %s%-20s %s: %s%d\r\n", MC1,
                 1, MC2, MC3, "Damage", MC4, MC5, room->damage.dam);
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%s", buf, MC1,
                 2, MC2, MC3, "Message", MC4, MC5,
                 room->damage.mesg ? room->damage.mesg : "(None)");
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s", buf, MC1,
                 3, MC2, MC3, "Interval", MC4, MC5);
    switch(room->damage.interval) {
      case 0: strcat(buf, "(S)ingle\r\n"); break;
      case 1: strcat(buf, "(C)ombat Round\r\n"); break;
      case 2: strcat(buf, "(T)ick\r\n"); break;
    }
    if (!room->damage.neutralizer && !room->damage.neutralizer2)
      sprintf(buf2, "(None)");
    else {
      if (room->damage.neutralizer)
        sprintbit(room->damage.neutralizer, affected_bits, buf2);
      else 
        *buf2 = '\0';
    }
    if (room->damage.neutralizer2) {
      sprintbit(room->damage.neutralizer2, affected_bits2, buf3);
      strcat(buf2, buf3);
    }
    sprintf(buf, "%s%s%2d%s) %s%-20s %s: %s%s\r\n", buf, MC1,
                 4, MC2, MC3, "Neutralizers", MC4, MC5, buf2);
    break;
  /*case*/
  }

  strcat(buf, CCNRM(ch, C_SPR));
  send_to_char(buf, ch);

  return;
}


PARSER(room_edit_parser)
{
  int choice = 0, dir;
  char arg1[MAX_INPUT_LENGTH], arg2[MAX_INPUT_LENGTH], buf[2048];
  struct menu_data *mdata = (struct menu_data*)ch->player.parse_data;
  struct room_data *room = world + ch->in_room;
  struct extra_descr_data *desc;

  /* check to make sure room is in zone being edited */
  if(room->number < mdata->bot_vnum || room->number > mdata->top_vnum) {
    send_to_char("Warning: You've left the zone you're editing.\r\n", ch);
    return FALSE;
  }

  half_chop(inp, arg1, arg2);	/* these 3 lines to save many later */
  if(*arg1)
    choice = atoi(arg1);


  switch(mdata->context) {

  case CONTEXT_TOP:
    /* room speed-creation..  If builder tries to move in a direction
       that doesn't exits (exits to nowhere don't count) new room is
       created on the fly
    */
    if (!PRF2_FLAGGED(ch, PRF2_NOSPDBLD)) {
      if(!inp[1]) { /* this will be a check for the option flag */
        if(LOWER(inp[0]) == 'n' && !room->dir_option[0]) {
  	do_rset(ch, "exit n connect 2", 0, 0);
  	return TRUE;
        } else if(LOWER(inp[0]) == 'e' && !room->dir_option[1]) {
  	do_rset(ch, "exit e connect 2", 0, 0);
  	return TRUE;
        } else if(LOWER(inp[0]) == 's' && !room->dir_option[2]) {
  	do_rset(ch, "exit s connect 2", 0, 0);
  	return TRUE;
        } else if(LOWER(inp[0]) == 'w' && !room->dir_option[3]) {
  	do_rset(ch, "exit w connect 2", 0, 0);
  	return TRUE;
        } else if(LOWER(inp[0]) == 'u' && !room->dir_option[4]) {
  	do_rset(ch, "exit u connect 2", 0, 0);
  	return TRUE;
        } else if(LOWER(inp[0]) == 'd' && !room->dir_option[5]) {
  	do_rset(ch, "exit d connect 2", 0, 0);
  	return TRUE;
        }
      }
    if (!inp[2]) {  /* check for non-compass dirs */
      if(!strn_cmp(inp, "ne", 2) && !room->dir_option[6]) {
        do_rset(ch, "exit ne connect 2", 0, 0);
        return TRUE;
      } else if(!strn_cmp(inp, "se", 2) && !room->dir_option[7]) {
        do_rset(ch, "exit se connect 2", 0, 0);
        return TRUE;
      } else if(!strn_cmp(inp, "sw", 2) && !room->dir_option[8]) {
        do_rset(ch, "exit sw connect 2", 0, 0);
        return TRUE;
      } else if(!strn_cmp(inp, "nw", 2) && !room->dir_option[9]) {
        do_rset(ch, "exit nw connect 2", 0, 0);
        return TRUE;
      } 
    }
    }
    if(!*inp) {
      build_room_menu(ch);
      return TRUE;
    } else if((inp[0] == 'x' && !inp[1]) || !str_cmp(inp, "exit")) {
      send_to_char("Do you want to save the rooms in this zone?\r\n", ch);
      mdata->context = CONTEXT_SAVE;
      return TRUE;
    } else if(inp[0] == '?' && inp[1] == '\0') {  /* faster than strcmp */
      send_to_char("Sorry, no help yet.\r\n", ch);
      return TRUE;
    } else if(is_abbrev(inp, "save") && inp[1]) {
	/* the above makes sure you aren't entering an 's' for south */
      do_redit(ch, "save", 0, 0);
      do_save(ch, "", 0, 0);
      /*send_to_char("Character saved.\r\n", ch);
      save_char(ch, ch->in_room);*/
      return TRUE;
    } else if(!isdigit(*inp)) {
      return FALSE;	/* input might be a mud command, so back to interp */
    } else {		/* numeric input must be a menu choice, right?	*/
      switch(choice) {	/* remember those lines we're saving?		*/

      /* all these cases MUST correspond to build_room_menu */
      case 1:		/* room name */
	if(!*arg2) {	/* input was just a # so we have to ask for name */
	  send_to_char("Enter a new room name.\r\n", ch);
	  mdata->context = CONTEXT_ROOM_NAME;
	  return TRUE;
	} else {	/* take text after number as the new room name	*/
	  sprintf(buf, "name %s", arg2);
	  do_rset(ch, buf, 0, 0);	/* pass it off to the old editor */
	  send_to_char(OK, ch);
	  return TRUE;
	}

      case 2:		/* room description */
	sprintf(buf, "Old Description:\r\n");
        sprintf(buf, "%s%sDo you wish to change it? (yes/NO)\r\n", buf,
			room->description);
	send_to_char(buf, ch);
	mdata->context = CONTEXT_DESCRIPTION;
	return TRUE;

      case 3:		/* sector type */
	if(!*arg2) {
	  send_to_char("Enter new sector type.\r\nEnter ? for help.\r\n", ch);
	  mdata->context = CONTEXT_SECTOR_TYPE;
	  return TRUE;
	} else {	/* take arg as the new sector type */
	  do_rset(ch, arg2, 0, 0);
	  send_to_char(OK, ch);
	  return TRUE;
	}

      case 4:		/* room flags */
	if(!*arg2) {
	  send_to_char("Enter room flags to toggle.\r\nEnter ? for help.\r\n", ch);
	  mdata->context = CONTEXT_ROOM_FLAGS;
	  return TRUE;
	} else {	/* take arg as the room flags to toggle */
	  do_rset(ch, arg2, 0, 0);
	  send_to_char(OK, ch);
	  return TRUE;
	}

      case 5:		/* extra descriptions */
	mdata->context = CONTEXT_EX_DESC;
	build_room_menu(ch);
	return TRUE;
      case 6:           /* room damage */
        mdata->context = CONTEXT_ROOM_DAMAGE;
        build_room_menu(ch);
        return TRUE;
      case DMN:		/* exits */
      case DMN+1:
      case DMN+2:
      case DMN+3:
      case DMN+4:
      case DMN+5:	/* add more if you're using more directions */
      case DMN+6:       /* Okay, if you insist... */
      case DMN+7:
      case DMN+8:
      case DMN+9:
	/* check if dir_option[choice - DMN] exists */
	if(!room->dir_option[choice - DMN]) {	/* no exit, create one? */
	  send_to_char("Create a new exit?  (yes/NO)\r\n", ch);
	  mdata->context = CONTEXT_EXIT_NEW;
	  ch->player.parse_me = (void *)(choice - DMN);
	  return TRUE;
	} else {	/* exit exists, so go to exit menu */
	  mdata->context = CONTEXT_EXIT;
	  ch->player.parse_me = (void *)(choice - DMN);
	  build_room_menu(ch);
	  return TRUE;
	}

      default:
	return FALSE;
      }
    }


  case CONTEXT_SAVE:
    if(!*inp) {
      send_to_char("Save?  Yes?  No?\r\n", ch);
      return TRUE;
    } else if(is_abbrev(inp, "yes")) {
      do_redit(ch, "save", 0, 0);
      ch->player.parser = NULL;
      free(mdata);
      ch->player.parse_data = NULL;
      ch->player.room_edit = -1;
      return TRUE;
    } else if(!str_cmp(inp, "no")) {	/* 'n' will still work for movement */
      ch->player.parser = NULL;
      free(mdata);
      ch->player.parse_data = NULL;
      send_to_char("Exiting room editor without saving.\r\n", ch);
      ch->player.room_edit = -1;
      return TRUE;
    } else
      return FALSE;


  case CONTEXT_ROOM_NAME:
    if(!*inp) {
      send_to_char("Keeping old room name.\r\n", ch);
      mdata->context = CONTEXT_TOP;
      return TRUE;
    } else {
      sprintf(buf, "name %s", inp);
      mdata->context = CONTEXT_TOP;
      do_rset(ch, buf, 0, 0);
      send_to_char(OK, ch);
      return TRUE;
    }


  case CONTEXT_DESCRIPTION:
    if(!*inp) {
      send_to_char("Keeping old room description.\r\n", ch);
      mdata->context = CONTEXT_TOP;
      return TRUE;
    } else if(is_abbrev(inp, "yes")) {
      mdata->context = CONTEXT_TOP;
      do_rset(ch, "descrip", 0, 0);
      return TRUE;
    } else
      return FALSE;


  case CONTEXT_SECTOR_TYPE:
    /* note that this really has nothing to do with sector types...
       it's just feeding your input through rset */
    if(!*inp) {
      send_to_char("Keeping old sector type.\r\n", ch);
      mdata->context = CONTEXT_TOP;
      return TRUE;
    } else if(*inp == '?') {
      sprintf(buf, "Valid sector types: ");
      for(choice = 0; *sector_types[choice] != '\n'; choice++)
	sprintf(buf, "%s%s ", buf, sector_types[choice]);
      strcat(buf, "\r\nEnter the new sector type.\r\n");
      send_to_char(buf, ch);
      return TRUE;
    } else {
      mdata->context = CONTEXT_TOP;
      do_rset(ch, inp, 0, 0);
      send_to_char(OK, ch);
      return TRUE;
    }


  case CONTEXT_ROOM_FLAGS:
    /* note that this really has nothing to do with room flags...
       it's just feeding your input through rset */
    if(!*inp) {
      send_to_char("Keeping old room flags.\r\n", ch);
      mdata->context = CONTEXT_TOP;
      return TRUE;
    } else if(*inp == '?') {
/*      sprintbit((long) 0x7fffffff, room_bits, buf2); */
      listbits(room_bits, buf2);
      sprintf(buf, "Valid room flags: %s\r\nEnter flags to toggle.\r\n",
			buf2);
      send_to_char(buf, ch);
      return TRUE;
    } else {
      mdata->context = CONTEXT_TOP;
      do_rset(ch, inp, 0, 0);
      send_to_char(OK, ch);
      return TRUE;
    }


  case CONTEXT_EX_DESC:
    if(!*inp) {
      build_room_menu(ch);
      return TRUE;
    } else if((inp[0] == 'x' && !inp[1]) || !str_cmp(inp, "exit")) {
      /* go up a level */
      if(!ch->player.parse_me)
	mdata->context = CONTEXT_TOP;
      else
	ch->player.parse_me = NULL;
      build_room_menu(ch);
      return TRUE;
    } else if(!isdigit(*inp))
      return FALSE;
    else if(!ch->player.parse_me) {
      if(choice == 1) {
	if(!*arg2) {
	  mdata->context = CONTEXT_EX_DESC_ADD;
	  send_to_char("Enter the keyword(s).\r\n", ch);
	  return TRUE;
	} else {	/* get keywords after the menu number */
	  sprintf(buf, "edesc add %s", arg2);
	  do_rset(ch, buf, 0, 0);
	  ch->player.parse_me = find_edesc_by_key(room->ex_description, arg2);
	  build_room_menu(ch);
	  return TRUE;
	}
      } else {	/* else find the edesc asked for */
	ch->player.parse_me = find_edesc_by_num(room->ex_description, choice);
	build_room_menu(ch);
	return TRUE;
      }
    } else {		/* looking at a specific edesc */
      if(!*inp) {
	build_room_menu(ch);
	return TRUE;
      } else {
	switch(choice) {

	case 0:	/* input wasn't a number */
	  return FALSE;

	case 1:	/* edit the keywords */
	  if(!*arg2) {
	    send_to_char("Enter the new keyword(s).\r\n", ch);
	    mdata->context = CONTEXT_EX_DESC_KEY;
	    return TRUE;
	  } else {	/* take arg2 as the new keywords */
	    desc = (struct extra_descr_data *)ch->player.parse_me;
	    free(desc->keyword);
	    desc->keyword = str_dup(arg2);
	    send_to_char(OK, ch);
	    return TRUE;
	  }

	case 2:	/* edit the description */
	  desc = (struct extra_descr_data *)ch->player.parse_me;
	  sprintf(buf, "Old Description:\r\n");
	  sprintf(buf, "%s%s\r\nDo you wish to change it? (yes/NO)\r\n",
			buf, desc->description);
	  send_to_char(buf, ch);
	  mdata->context = CONTEXT_EX_DESC_DESC;
	  return TRUE;

	case 3:	/* delete this description */
	  send_to_char("Are you sure? (yes/NO)\r\n", ch);
	  mdata->context = CONTEXT_EX_DESC_DEL;
	  return TRUE;

	default:
	  return FALSE;
	}
      }
    }


  case CONTEXT_EX_DESC_ADD:
    if(!*inp) {
      send_to_char("Aborting desc add.\r\n", ch);
      mdata->context = CONTEXT_EX_DESC;
      return TRUE;
    } else {
      sprintf(buf, "edesc add %s", inp);
      do_rset(ch, buf, 0, 0);
      ch->player.parse_me = find_edesc_by_key(room->ex_description, arg2);
      mdata->context = CONTEXT_EX_DESC;
      build_room_menu(ch);
      return TRUE;
    }


  case CONTEXT_EX_DESC_KEY:
    if(!*inp) {
      send_to_char("Aborting keyword change.\r\n", ch);
      mdata->context = CONTEXT_EX_DESC;
      return TRUE;
    } else {
      desc = (struct extra_descr_data *)ch->player.parse_me;
      free(desc->keyword);
      desc->keyword = str_dup(inp);
      send_to_char(OK, ch);
      mdata->context = CONTEXT_EX_DESC;
      return TRUE;
    }


  case CONTEXT_EX_DESC_DESC:
    if(!*inp) {
      send_to_char("Aborting descrition change.\r\n", ch);
      mdata->context = CONTEXT_EX_DESC;
      return TRUE;
    } else {
      desc = (struct extra_descr_data *)ch->player.parse_me;
      half_chop(desc->keyword, arg1, arg2);
      sprintf(buf, "edesc set %s", arg1);
      do_rset(ch, buf, 0, 0);
      mdata->context = CONTEXT_EX_DESC;
      return TRUE;
    }


  case CONTEXT_EX_DESC_DEL:
    if(!*inp || !str_cmp(inp, "no")) {
      send_to_char("Aborting edesc deletion.\r\n", ch);
      mdata->context = CONTEXT_EX_DESC;
      return TRUE;
    } else if(is_abbrev(inp, "yes")) {
      desc = (struct extra_descr_data *)ch->player.parse_me;
      half_chop(desc->keyword, arg1, arg2);
      sprintf(buf, "edesc del %s", arg1);
      do_rset(ch, buf, 0, 0);
      send_to_char("Deleted.\r\n", ch);
      mdata->context = CONTEXT_EX_DESC;
      ch->player.parse_me = NULL;
      build_room_menu(ch);
      return TRUE;
    } else
      return FALSE;


  case CONTEXT_EXIT:
    if(!*inp) {
      build_room_menu(ch);
      return TRUE;
    } else if((inp[0] == 'x' && !inp[1]) || !str_cmp(inp, "exit")) {
      mdata->context = CONTEXT_TOP;
      ch->player.parse_me = NULL;
      build_room_menu(ch);
      return TRUE;
    } else if(!isdigit(*inp))
      return FALSE;
    else {
      switch(choice) {

      case 1:		/* change to_room */
	if(!*arg2) {
	  send_to_char("Enter the new room number to connect to.\r\n", ch);
	  mdata->context = CONTEXT_EXIT_ROOM;
	  return TRUE;
	} else {
	  dir = (int)ch->player.parse_me;
	  if(/*choice > 32767 || choice < 0 ||*/
		(choice = real_room(atoi(arg2))) < 0) {
	    send_to_char("That room doesn't exist\r\n", ch);
	    build_room_menu(ch);
	    return TRUE;
	  } else {
	    room->dir_option[dir]->to_room = choice;
	    send_to_char(OK, ch);
	    return TRUE;
	  }
	}

      case 2:		/* description */
	dir = (int)ch->player.parse_me;
	if(room->dir_option[dir]->general_description) {
	  sprintf(buf, "Old Description:\r\n%s",
			room->dir_option[dir]->general_description);
	  strcat(buf, "Change this description?\r\n");
	  send_to_char(buf, ch);
	  mdata->context = CONTEXT_EXIT_DESCRIP;
	  return TRUE;
	} else {	/* nothing to protect, so it's save to edit */
	  sprintf(buf, "exit %s descrip", dir_abbrev[dir]);
	  do_rset(ch, buf, 0, 0);
	  return TRUE;
	}	

      case 3:		/* flags */
	if(!*arg2) {
	  send_to_char("Enter the exit flags to toggle.\r\nEnter ? for help.\r\n", ch);
	  mdata->context = CONTEXT_EXIT_FLAGS;
	  return TRUE;
	} else {
	  /* needs a change to exits to check_toggle_flags */
	  sprintf(buf, "exit %s %s", dir_abbrev[(int)ch->player.parse_me], arg2);
	  do_rset(ch, buf, 0, 0);
	  send_to_char(OK, ch);
	  return TRUE;
	}

      case 4:		/* keyword */
	if(!*arg2) {
	  send_to_char("Enter the keyword(s).\r\n", ch);
	  mdata->context = CONTEXT_EXIT_KEYWORD;
	  return TRUE;
	} else {
	  sprintf(buf, "exit %s keyword %s", dir_abbrev[(int)ch->player.parse_me],
			arg2);
	  do_rset(ch, buf, 0, 0);
	  send_to_char(OK, ch);
	  return TRUE;
	}

      case 5:		/* key # */
	if(!*arg2) {
	  send_to_char("Enter the new key number.\r\n", ch);
	  mdata->context = CONTEXT_EXIT_KEY;
	  return TRUE;
	} else {
	  choice = atoi(arg2);
	  if(/*choice > 32767 || choice < 0 ||*/ (real_room(choice)) < 0) {
	    send_to_char("That object doesn't exist!\r\n", ch);
	    return TRUE;
	  } else {
	    sprintf(buf, "exit %s key %d", dir_abbrev[(int)ch->player.parse_me],
			choice);
	    do_rset(ch, buf, 0, 0);
	    send_to_char(OK, ch);
	    return TRUE;
	  }
	}

      case 6:		/* delete exit */
	send_to_char("Are you SURE you want to delete this exit?\r\n", ch);
	mdata->context = CONTEXT_EXIT_DELETE;
	return TRUE;

      default:
	return FALSE;
      }
    }


  case CONTEXT_EXIT_NEW:
    if(!*inp || !str_cmp(inp, "no")) {
      send_to_char("Aborting exit creation.\r\n", ch);
      mdata->context = CONTEXT_TOP;
      ch->player.parse_me = NULL;
      build_room_menu(ch);
      return TRUE;
    } else if(is_abbrev(inp, "yes")) {
      send_to_char("(1)One-way connection or (2)Two-way?  Default = 2\r\n", ch);
      mdata->context = CONTEXT_EXIT_NEW_WAYS;
      return TRUE;
    } else
      return FALSE;


  case CONTEXT_EXIT_NEW_WAYS:
    if(!*inp || choice == 2) {
      send_to_char("To which room?\r\n", ch);
      mdata->context = CONTEXT_EXIT_NEW_2;
      return TRUE;
    } else if(choice == 1) {
      send_to_char("To which room?\r\n", ch);
      mdata->context = CONTEXT_EXIT_NEW_1;
      return TRUE;
    } else
      return FALSE;


  case CONTEXT_EXIT_NEW_1:
    if(!*inp) {
      send_to_char("Aborting exit creation.\r\n", ch);
      mdata->context = CONTEXT_TOP;
      ch->player.parse_me = NULL;
      build_room_menu(ch);
      return TRUE;
    } else if(isdigit(*inp)) {
      sprintf(buf, "exit %s connect 1 %d", dir_abbrev[(int)ch->player.parse_me],
			choice);
      do_rset(ch, buf, 0, 0);
      if(room->dir_option[(int)ch->player.parse_me])	/* success */
	mdata->context = CONTEXT_EXIT;
      else {						/* failure */
	send_to_char("Aborting exit creation.\r\n", ch);
	mdata->context = CONTEXT_TOP;
	ch->player.parse_me = NULL;
      }
      build_room_menu(ch);
      return TRUE;
    } else
      return FALSE;


  case CONTEXT_EXIT_NEW_2:
    if(!*inp) {
      send_to_char("Aborting exit creation.\r\n", ch);
      mdata->context = CONTEXT_TOP;
      ch->player.parse_me = NULL;
      build_room_menu(ch);
      return TRUE;
    } else if(isdigit(*inp)) {
      sprintf(buf, "exit %s connect 2 %d", dir_abbrev[(int)ch->player.parse_me],
			choice);
      do_rset(ch, buf, 0, 0);
      if(room->dir_option[(int)ch->player.parse_me])	/* success */
	mdata->context = CONTEXT_EXIT;
      else {						/* failure */
	send_to_char("Aborting exit creation.\r\n", ch);
	mdata->context = CONTEXT_TOP;
	ch->player.parse_me = NULL;
      }
      build_room_menu(ch);
      return TRUE;
    } else
      return FALSE;


  case CONTEXT_EXIT_ROOM:
    if(!*inp) {
      send_to_char("Aborting room number change.\r\n", ch);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    } else if(!isdigit(*inp)) {
      return FALSE;
    } else if(/*choice > 32767 || choice < 0 ||*/
		(dir = real_room(choice)) < 0) {
      send_to_char("That room doesn't exist!\r\n", ch);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    } else {
      room->dir_option[(int)ch->player.parse_me]->to_room = dir;
      send_to_char(OK, ch);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    }


  case CONTEXT_EXIT_DESCRIP:
    if(!*inp || !str_cmp(inp, "no")) {
      send_to_char("Aborting description change.\r\n", ch);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    } else if(is_abbrev(inp, "yes")) {
      sprintf(buf, "exit %s descrip", dir_abbrev[(int)ch->player.parse_me]);
      do_rset(ch, buf, 0, 0);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    } else
      return FALSE;


  case CONTEXT_EXIT_FLAGS:
    if(!*inp) {
      send_to_char("Aborting exit flag change.\r\n", ch);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    } else if(*inp == '?') {
      /* sprintbit((long) 0x7fffffff, exit_bits, buf2); */
      listbits(exit_bits, buf2);
      sprintf(buf, "Valid exit flags: %s\r\nEnter flags to toggle.\r\n",
			buf2);
      send_to_char(buf, ch);
      return TRUE;
    } else {
      sprintf(buf, "exit %s %s", dir_abbrev[(int)ch->player.parse_me], inp);
      do_rset(ch, buf, 0, 0);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    }


  case CONTEXT_EXIT_KEYWORD:
    if(!*inp) {
      send_to_char("Aborting exit keyword change.\r\n", ch);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    } else {
      sprintf(buf, "exit %s keyword %s", dir_abbrev[(int)ch->player.parse_me],
			inp);
      do_rset(ch, buf, 0, 0);
      send_to_char(OK, ch);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    }


  case CONTEXT_EXIT_KEY:
    if(!*inp) {
      send_to_char("Aborting exit key change.\r\n", ch);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    } else if(!isdigit(*inp)) {
      return FALSE;
    } else if(/*choice > 32767 || choice < 0 ||*/
		(dir = real_object(choice)) < 0) {
      send_to_char("That object doesn't exist!\r\n", ch);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    } else {
      sprintf(buf, "exit %s key %d", dir_abbrev[(int)ch->player.parse_me],
			choice);
      do_rset(ch, buf, 0, 0);
      send_to_char(OK, ch);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    }


  case CONTEXT_EXIT_DELETE:
    if(!*inp || !str_cmp(inp, "no")) {
      send_to_char("Aborting exit deletion.\r\n", ch);
      mdata->context = CONTEXT_EXIT;
      return TRUE;
    } else if(is_abbrev(inp, "yes")) {
      sprintf(buf, "exit %s delete", dir_abbrev[(int)ch->player.parse_me]);
      do_rset(ch, buf, 0, 0);
      send_to_char(OK, ch);
      mdata->context = CONTEXT_TOP;
      ch->player.parse_me = NULL;
      build_room_menu(ch);
      return TRUE;
    } else
      return FALSE;

    case CONTEXT_ROOM_DAMAGE:
      if (!*inp) {
        build_room_menu(ch);
        return TRUE;
      } else if ((inp[0] == 'x' && !inp[1]) || !str_cmp(inp, "exit")) {
        mdata->context = CONTEXT_TOP;
        build_room_menu(ch);
        return TRUE;
      } else if (!isdigit(*inp))
        return FALSE;
      switch (choice) {
        case 1:    /* Damage amount */
          if (!*arg2) {
            send_to_char("Enter amount of damage.\r\n", ch);
            mdata->context = CONTEXT_DAMAGE_AMOUNT;
            return TRUE;
          } else {
            sprintf(buf, "damage damage %s", arg2);
            do_rset(ch, buf, 0, 0);
            send_to_char(OK, ch);
            return TRUE;
          }
        case 2:   /* Message */
          if (!*arg2) {
            send_to_char("Enter a damage message.\r\n", ch);
            mdata->context = CONTEXT_DAMAGE_MESSAGE;
            return TRUE;
          } else {
            sprintf(buf, "damage message %s", arg2);
            do_rset(ch, buf, 0, 0);
            return TRUE;
          }
        case 3:  /* Interval */
          if (!*arg2) {
            send_to_char("Enter interval (S, C, or T)\r\n", ch);
            mdata->context = CONTEXT_DAMAGE_INTERVAL;
            return TRUE;
          } else {
            sprintf(buf, "damage interval %s", arg2);
            do_rset(ch, buf, 0, 0);
            return TRUE;
          }
        case 4: /* Neutralizer */
          if (!*arg2) {
            send_to_char("Enter neutralizers to toggle.\r\n", ch);
            send_to_char("Enter ? for help.\r\n",ch);
            mdata->context = CONTEXT_DAMAGE_NEUTRAL;
            return TRUE;
          } else {
            sprintf(buf, "damage %s", arg2);
            do_rset(ch, buf, 0, 0);
            return TRUE;
          }
        default:
          return FALSE;
        }
      case CONTEXT_DAMAGE_MESSAGE:
        if (!*inp) {
          send_to_char("Keeping old message.\r\n", ch);
          mdata->context = CONTEXT_ROOM_DAMAGE;
          return TRUE;
        } else {
          sprintf(buf, "damage message %s", inp);
          do_rset(ch, buf, 0, 0);
          send_to_char(OK, ch);
          mdata->context = CONTEXT_ROOM_DAMAGE;
          return TRUE;
        }
      case CONTEXT_DAMAGE_AMOUNT:
        if (!*inp) {
          send_to_char("Keeping old damage amount.\r\n", ch);
          mdata->context = CONTEXT_ROOM_DAMAGE;
          return TRUE;
        } else {
          sprintf(buf, "damage damage %s", inp);
          do_rset(ch, buf, 0, 0);
          send_to_char(OK, ch);
          mdata->context = CONTEXT_ROOM_DAMAGE;
          return TRUE;
        }
      case CONTEXT_DAMAGE_INTERVAL:
        if (!*inp) {
          send_to_char("Keeping old damage interval.\r\n", ch);
          mdata->context = CONTEXT_ROOM_DAMAGE;
          return TRUE;
        } else {
          sprintf(buf, "damage interval %s", inp);
          do_rset(ch, buf, 0, 0);
          send_to_char(OK, ch);
          mdata->context = CONTEXT_ROOM_DAMAGE;
          return TRUE;
        }
        case CONTEXT_DAMAGE_NEUTRAL:
          if (!*inp) {
            send_to_char("Keeping old neutralizers.\r\n", ch);
            mdata->context = CONTEXT_ROOM_DAMAGE;
            return TRUE;
          } if (*inp == '?') {
            listbits(affected_bits, buf2);
            listbits(affected_bits2, arg2);
            strcat(buf2, arg2);
            sprintf(buf, "Valid neutralizers: %s\r\nEnter flags to toggle.\r\n",
                    buf2);
            send_to_char(buf, ch);
            return TRUE;
          } else {
            sprintf(buf, "damage %s", inp);
            do_rset(ch, buf, 0, 0);
            send_to_char(OK, ch);
            mdata->context = CONTEXT_ROOM_DAMAGE;
            return TRUE;
          }
            
  }	/* end of switch(mdata->context) */
  return FALSE;
}
