/* ************************************************************************
*   File: progcmd.c                                     Part of CircleMUD *
*  Usage: Program and Trigger Commands                                    *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */

#define __PROGCMD_C__

#include "conf.h"
#include "sysdep.h"

#include "structs.h"
#include "comm.h"
#include "interpreter.h"
#include "db.h"
#include "utils.h"
#include "spells.h"
#include "handler.h"

extern struct room_data *world;

void prog_cmd(struct char_data *ch, char *argument) {

  char command[10];
  int w, x, y, z;
  struct char_data *vict, *victim;
  struct follow_type *fll;
  void *item;

  char *prog_commands[] = {
    "exec",
    "puts",
    "sendto",
    "giveto",
    "take",
    "toroom",
    "set",
    "skillset",
    "affset"
    "\n"
  };

  char *targets[] = {
    "all",
    "room",
    "group",
    "char",
    "\n"
  };


  half_chop(argument, command, buf);

    
  for (x = 0; *prog_commands[x] != '\n'; x++) 
    if (!strcmp(prog_commands[x], command)) 
      break;
  if (test_mode) {
    fprintf(stderr, "%s sent the command '%s' (%d) with arguments '%s'\n",
            ch->player.name, command, x, buf); 
  }

  switch (x) {
    case 0:  /* exec */
            command_interpreter(ch, buf);
            break;
    case 1: /* puts */
            half_chop(buf, command, buf);
            strcat(buf, "\r\n");
            for (y = 0; *targets[y] != '\n'; y++) 
              if (!strcmp(targets[y], command)) 
                break;
            switch (y) {
              case 0: /* all */
                      send_to_all(buf);
                      break;
              case 1: /* room */
                      act(buf, FALSE, ch, 0, 0, TO_ROOM);
                      break;
              case 2: /* group */
                      if (ch->master && AFF_FLAGGED(ch, AFF_GROUP))
                        vict = ch->master;
                      else
                        vict = ch;
                      act(buf, FALSE, ch, 0, (struct char_data *) vict, TO_VICT);
                      for (fll = vict->followers; fll; fll = fll->next) {
                        if (fll->follower && fll->follower->in_room ==
                            ch->in_room &&
                            AFF_FLAGGED(fll->follower, AFF_GROUP))
                          act(buf, FALSE, ch, 0, fll->follower, TO_VICT);
                      }
                      break;
              case 3: /* char */
                      act(buf, FALSE, ch, 0, 0, TO_CHAR);
                      break;
            }
            break;
    case 2: /* sendto */
            half_chop(buf, command, buf);
            z = atoi(buf);
            for (y = 0; *targets[y] != '\n'; y++)
              if (!strcmp(targets[y], command))
                break;
            switch (y) { 
              case 0: /* all */
                      break;
              case 1: /* room */
                      for (vict = world[ch->in_room].people; vict; vict = victim) {
                        victim = vict->next_in_room;
                        char_from_room(vict);
                        char_to_room(vict, real_room(z));
                      } 
                      break;
              case 2: /* group */
                      if (ch->master && AFF_FLAGGED(ch, AFF_GROUP) && 
                          ch->master->in_room == ch->in_room)
                        vict = ch->master;
                      else
                        vict = ch;
                      w = ch->in_room;
                      char_from_room(vict);
                      char_to_room(vict, real_room(z));
                      for (fll = vict->followers; fll; fll = fll->next) {
                        if (fll->follower && fll->follower->in_room == w &&
                            AFF_FLAGGED(fll->follower, AFF_GROUP)) {
                          char_from_room(fll->follower);
                          char_to_room(fll->follower, real_room(z));
                        }
                      }
                      break;
              case 3: /* char */
                      char_from_room(ch);
                      char_to_room(ch, real_room(z));
                      break;
            }
            break;
    case 3: /* giveto */
            half_chop(buf, command, buf);
            for (y=0; *targets[y] != '\n'; y++) 
              if (!str_cmp(targets[y], command))
                break;
          
            switch (y) {
              case 0: /* all */
                      break;
              case 1: /* room */
                      y = atoi(buf);
                      for (vict = world[ch->in_room].people; vict; vict = vict->next_in_room) {
                        if (real_object(y) != -1) {
                          item = read_object(y, VIRTUALRM);
                          obj_to_char(item, vict);
                        }
                      }
                      break;
              case 2: /* group */
                      y = atoi(buf);
                      if (ch->master && AFF_FLAGGED(ch, AFF_GROUP) && 
                          ch->master->in_room == ch->in_room)
                        vict = ch->master;
                      else
                        vict = ch;
                      w = ch->in_room;
                      if (real_object(y) != -1) {
                        item = read_object(y, VIRTUALRM);
                        obj_to_char(item, ch);
                      }
                      for (fll = vict->followers; fll; fll = fll->next) {
                        if (fll->follower && fll->follower->in_room == w &&
                            AFF_FLAGGED(fll->follower, AFF_GROUP)) {
                          if (real_object(y) != -1) {
                            item = read_object(y, VIRTUALRM);
                            obj_to_char(item, ch);
                          }
                        }
                      }
                      break;
              case 3: /* char */
                      y = atoi(buf);
                      if (real_object(y) != -1) {
                        item = read_object(y, VIRTUALRM);
                        obj_to_char(item, ch);
                      }
                      break;
            }
            break;
    case 4: /* take */
            break;
    case 5: /* toroom */
            half_chop(buf, command, buf);
            y = atoi(buf);
            if (!strcmp(command, "mob")) {
              if (real_mobile(y) != -1)  {
                 item = read_mobile(y, VIRTUALRM);
                 char_to_room(item, ch->in_room);
              }
            } else {
              if (real_object(y) != -1)  {
                 item = read_object(y, VIRTUALRM);
                 obj_to_room(item, ch->in_room);
              }
            }
            break;
    case 6: /* set */
            break;
    case 7: /* skillset */
            break;
    case 8: /* affset */
            break;
  }
}
