/***************************************************************************
*                                 Races!                                   *
*                                by: KAKO                                  *
***************************************************************************/

#define __RACE_C__
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "structs.h"
#include "db.h"
#include "utils.h"
#include "spells.h"
#include "interpreter.h"

void update_gargoyles(int time);
/* { keyletter (unique), short name, long name, donation room } */
 const struct clan_stuff clans[] = {
  {"N", "NoClan",  "NoClan", 3063},
  {"", "(*DKC*)", "Dragon Knights Clan", 3063},
  {"", "(*RWC*)", "RWC", 3063},
  {"S", "(*SDC*)",  "Silent Death Clan", 3036},
  {"", "(*KKC*)", "KKC", 3063},
  {"C", "(*CDA*)",  "Clan D'ell Arte", 4444},
  {"", "(*ACOMA*)","Acoma", 3063},
  {"W", "(*TSF*)",  "The Shining Force", 8220},
  {"O", "(*COS*)",  "Clan Of the Spoon", 3092},
  {"E", "(*ETC*)",  "Elite Thieves Clan", 4438},
  {"L", "(*LOTR*)", "Lords of the Rings", 3063},
  {"J", "(*JEDI*)", "Jedi Knights", 8215},
  {"M", "(*WMS*)",  "Wandering Minstrel Society", 3063},
  {"T", "(*TKC*)",  "Torture Kill Cult", 13038},
  {"", "(*WAR*)",  "Knights of Light", 3063},
  {"U", "(*LUSH*)",   "Life's UnSung Heros", 1951},
  {"", "(*RDS*)",  "Revenge of the Dark Society", 3063},
  {"Y", "(*CSR*)",  "Circle of Sylvan Rangers", 4435},
  {"", "(*CNW*)",  "Clan of the Night Winds", 3063},
  {"V", "(*COTN*)", "Children of the Night", 3149},
  {"K", "(*CTC*)",  "Crimson Tide Coalition", 4456},
  {"F", "(*TSO*)",  "The Silent Order", 3063},
  {"", "(*Dagger*)", "The Silver Daggers", 3063},
  {"Q", "(*DMA*)", "Dragon Moon Alliance", 3063},
  {"B", "(*NLS*)", "NoLimit Soldiers", 8220}, 
  {"\n", "\n", "\n", 3063}
};
/*  RACE STUFF -- KAKO */
const char *race_abbrevs[] = {
   "&+yHu",
   "&+gEl",
   "&+YDw",
   "&+WHo",
   "&+bOg",
   "&+rVa",
   "&+mTr",
   "&+MFa",
   "&+RDr",
   "&+BTi",
   "&+GTK",
   "&+CGy",
   "\n"
 };

 const char *race_types[] = {
   "&+yHuman",
   "&+gElf",
   "&+YDwarf",
   "&+WHobbit",
   "&+bOgre",
   "&+rVampire",
   "&+mTroll",
   "&+MFairy",
   "&+RDragon",
   "&+BTiefling",
   "&+GThri-Kreen",
   "&+CGargoyle",
   "\n"
 };

 const char *race_menu =
 "\r\n"
 "&+cSelect your race:\r\n"
 " [H] for &+yHuman&+c\r\n"
 " [E] for &+gElf&+c\r\n"
 " [D] for &+YDwarf&+c\r\n"
 " [a] for &+WHobbit&+c\r\n"
 " [O] for &+bOgre&+c\n\r"
 " [V] for &+rVampire&+c\r\n"
 " [T] for &+mTroll&+c\r\n"
 " [F] for &+MFairy&+c\r\n"
 " [r] for &+RDragon&+c\r\n"
 " [i] for &+BTiefling&+c\r\n"
 " [k] for &+GThri-kreen&+c\r\n"
 " [G] for &+CGargoyle&+c\r\n"
 " [?] for Race info\r\n\r\n"
 " Race: ";


const char *race_info = 
"\r\n&+c"
"&+yHuman&+c      - Balanced attributes. No extra abilities or talents.\r\n"
"&+gElf&+c        - Magically gifted. Regen mana twice as fast.\r\n"
"&+YDwarf&+c      - Hardy, resistant to magic. Heal wounds twice as fast.\r\n"
"&+WHobbit&+c     - Small, agile, protected from evil.\r\n"
"&+bOgre&+c       - Tough. Slow regen. Eats anything.\r\n"
"&+rVampire&+c    - Undead. Bites to regen and sees in the dark.\r\n"
"&+mTroll&+c      - Incredible regen, vulnerable to magic, protected from good.\r\n"
"&+MFairy&+c      - Small, magical, flying, hard to hit.\r\n"
"&+RDragon&+c     - Intimidating, dangerous, fire breathing, fliers.\r\n"
"&+BTiefling&+c   - Hybrids. All different, chance of many or no abilities.\r\n"
"&+GThri-Kreen&+c - Insectoid mantis creatures. Fast in combat.\r\n"
"&+CGargoyle&+c   - Strong by night, weakened by day.\r\n"
"\r\n"
"Race: ";

int parse_race(char arg)
{
  arg = LOWER(arg);

  switch (arg) {
  case 'h':
    return RACE_HUMAN;
    break;
  case 'e':
    return RACE_ELF;
    break;
  case 'd':
    return RACE_DWARF;
    break;
  case 'a':
    return RACE_HOBBIT;
    break;
  case 'o':
    return RACE_OGRE;
    break;
  case 'v':
    return RACE_VAMPIRE;
    break;
  case 't':
    return RACE_TROLL;
    break;
  case 'f':
    return RACE_FAIRY;
    break;
  case 'r':
    return RACE_DRAGON;
    break;
  case 'i':
    return RACE_TIEFLING;
    break;
  case 'k':
    return RACE_THRIKREEN;
    break;
  case 'g':
    return RACE_GARGOYLE;
    break;
  default:
    return RACE_UNDEFINED;
    break;
  }
}

long find_race_bitvector(char arg)
{
  arg = LOWER(arg);

  switch (arg) {
  case 'h':
    return (1 << 0);
    break;
  case 'e':
    return (1 << 1);
    break;
  case 'd':
    return (1 << 2);
    break;
  case 'a':
    return (1 << 3);
    break;
  case 'o':
    return (1 << 4);
    break;
  case 'v':
    return (1 << 5);
    break;
  case 't':
    return (1 << 6);
    break;
  case 'f':
    return (1 << 7);
    break;
  case 'r':
    return (1 << 8);
    break;
  case 'i':
    return (1 << 9);
    break;
  case 'k':
    return (1 << 10);
    break;
  case 'g':
    return (1 << 11);
    break;
  default:
    return 0;
    break;
  }
}
/* End of Race Stuff */
int parse_clan(char *arg)
{
 int i;

 for (i = 0; str_cmp(clans[i].abbrev, "\n"); i++) {
  if (!strn_cmp(clans[i].abbrev, arg, 1))
   return i;
}
return CLAN_UNDEFINED;
}

long find_clan_bitvector(char *arg)
{
  int i;

  for (i = 0; str_cmp(clans[i].abbrev, "\n"); i++)
  if (!strn_cmp(clans[i].abbrev, arg, 1))
   return (1 << i);

 return 0;

}


int valid_race_table[NUM_RACES][NUM_CLASSES] =
  {/* Nb  Mu  Cl  Th  Wa  Pa  Ba  Ap  Ra  Mo  Sa */


{     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,     }, /* human */
{     1,  1,  1,  1,  1,  0,  1,  0,  1,  1,  0,     }, /* elf */
{     1,  0,  1,  1,  1,  0,  1,  0,  1,  1,  1,     }, /* dwarf */

{     1,  0,  1,  1,  1,  0,  1,  0,  0,  0,  0,     }, /* hobbit */
{     1,  1,  1,  0,  1,  0,  1,  0,  1,  0,  0,     }, /* ogre */
{     1,  1,  0,  1,  1,  0,  1,  1,  0,  0,  0,     }, /* vampire */

{     1,  1,  0,  1,  1,  0,  1,  1,  1,  0,  0,     }, /* troll */
{     1,  1,  1,  1,  1,  0,  1,  0,  0,  0,  0,     }, /* fairy */
{     1,  1,  0,  0,  1,  1,  1,  1,  0,  0,  0,     }, /* dragon */

{     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,     }, /* tiefling */
{     1,  0,  0,  1,  1,  0,  1,  0,  1,  0,  1,     }, /* thrikreen */
{     1,  1,  0,  1,  1,  0,  1,  1,  0,  0,  1,     }, /* gargoyle */


  };  /* end of valid_race_table */


int valid_race(int race, int class)
{
return(valid_race_table[race][class]);
}


void update_gargoyles(int time)
{
  struct char_data *g;
  extern struct char_data *character_list;

  for(g = character_list; g; g = g->next) {
    if(!IS_NPC(g) && GET_RACE(g) == RACE_GARGOYLE) {
      if(time == SUN_RISE) {
	GET_STR(g) -= 2;
	GET_DEX(g) -= 2;
	GET_CON(g) -= 2;
      } else if(time == SUN_DARK) {
	GET_STR(g) += 2;
	GET_DEX(g) += 2;
	GET_CON(g) += 2;
      }
    }
  }
}
