/* ************************************************************************
*   File: alias.c				   A utility to CircleMUD *
*  Usage: writing/reading player's aliases                                *
*                                                                         *
*  Code done by Jeremy Hess and Chad Thompson				  *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "structs.h"
#include "utils.h"
#include "interpreter.h"
#include "saves.h"

void write_saves(struct char_data *ch)
{
  FILE *file;
  char fn[127];
/*  char *buf; */
  struct alias *temp;
  int fields=0;

  get_filename(GET_NAME(ch),fn,SAVES_FILE);
  unlink(fn);

  file = fopen(fn,"wt");

  temp = GET_ALIASES(ch);
  
  while( temp ) {
    if(*(temp->alias) && *(temp->replacement) && *(temp->alias) != '0'
       && *(temp->alias) != '1') {
      fprintf(file, "%c%s\n", SAVE_ALIAS, temp->alias);
      fprintf(file, "%s\n", temp->replacement);
      fprintf(file, "%i\n", temp->type);
      fields++;
      }
    temp = temp->next;
    }
  if (POOFIN(ch)) {
    fprintf(file,"%c%s\n", SAVE_POOFIN, POOFIN(ch));
    fields++;
    }
  if (POOFOUT(ch)) {
    fprintf(file,"%c%s\n", SAVE_POOFOUT, POOFOUT(ch));
    fields++;
    }

  if (GET_BINDTELL(ch)) {
    fprintf(file,"%c%s\n", SAVE_BINDTELL, GET_BINDTELL(ch));
    fields++;
    }
  if (GET_BINDHB(ch)) {
    fprintf(file,"%c%s\n", SAVE_BINDHB, GET_BINDHB(ch));
    fields++;
    }
  if (GET_BINDGT(ch)) {
    fprintf(file,"%c%s\n", SAVE_BINDGT, GET_BINDGT(ch));
    fields++;
    }
  if (GET_BINDWIMP(ch)) {
    fprintf(file,"%c%s\n", SAVE_BINDWIMP, GET_BINDWIMP(ch));
    fields++;
    }

  if (GET_PROMPT_STRING(ch)) {
    fprintf(file,"%c%s\n", SAVE_PROMPT, GET_PROMPT_STRING(ch));
    fields++;
    }
  
  fclose(file);
  if (!fields)
    unlink(fn);
}

void read_saves(struct char_data *ch)
{   
  FILE *file;
  char fn[127];
  struct alias *t2;
  struct alias *t1;
  char buf[127];
  char line[256];

  get_filename(GET_NAME(ch),fn,SAVES_FILE);

  file = fopen(fn,"r");

  if( !file )
    return;
  
  for (t2 = GET_ALIASES(ch) ; t2 ; t2 = t1) {
    t1 = t2->next;
    free(t2);
    }
  GET_ALIASES(ch) = NULL;
 
  do {
    get_line(file, line);
    if(!*line) {
      sprintf(buf, "alias: Error in alias file: %s", GET_NAME(ch));
      mudlog(buf, BRF, LVL_IMMORT, TRUE);
      return;
      }
    switch(*line) {
    case SAVE_ALIAS:
      if (!GET_ALIASES(ch)) {
	CREATE(GET_ALIASES(ch), struct alias, 1);
	t2 = GET_ALIASES(ch);
	}
      else {
	CREATE(t2->next, struct alias, 1);
	t2 = t2->next;
	}
      t2->alias = strdup(&line[1]);
      get_line(file, line);
      if(!*line) {
	sprintf(buf, "alias: Error in alias file: %s", GET_NAME(ch));
	mudlog(buf, BRF, LVL_IMMORT, TRUE);
	return;
	}
      t2->replacement = strdup(line);
      get_line(file, line);
      if(!*line) {
	sprintf(buf, "alias: Error in alias file: %s", GET_NAME(ch));
	mudlog(buf, BRF, LVL_IMMORT, TRUE);
	return;
	}
      t2->type = atoi(line);
      break;
    case SAVE_POOFIN:
      if (POOFIN(ch))
	free(POOFIN(ch));
      POOFIN(ch) = str_dup(&line[1]);
      break;
    case SAVE_POOFOUT:
      if (POOFOUT(ch))
	free(POOFOUT(ch));
      POOFOUT(ch) = str_dup(&line[1]);
      break;
    case SAVE_BINDHB:
      if (GET_BINDHB(ch))
	free(GET_BINDHB(ch));
      GET_BINDHB(ch) = str_dup(&line[1]);
      break;
    case SAVE_BINDTELL:
      if (GET_BINDTELL(ch))
	free(GET_BINDTELL(ch));
      GET_BINDTELL(ch) = str_dup(&line[1]);
      break;
    case SAVE_BINDGT:
      if (GET_BINDGT(ch))
	free(GET_BINDGT(ch));
      GET_BINDGT(ch) = str_dup(&line[1]);
      break;
    case SAVE_BINDWIMP:
      if (GET_BINDWIMP(ch))
	free(GET_BINDWIMP(ch));
      GET_BINDWIMP(ch) = str_dup(&line[1]);
      break;
    case SAVE_PROMPT:
      if (GET_PROMPT_STRING(ch))
	free(GET_PROMPT_STRING(ch));
      GET_PROMPT_STRING(ch) = str_dup(&line[1]);
      break;
      }
    
    } while( !feof(file) ); 
  
  fclose(file);
} 
