/* ************************************************************************
*   File: screen.h                                      Part of CircleMUD *
*  Usage: header file with ANSI color codes for online color              *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */

#define KNRM  "\x1B[0m"
#define KRED  "\x1B[0;31m"
#define KBRE  "\x1B[1;31m"
#define KGRN  "\x1B[0;32m"
#define KBGR  "\x1B[1;32m"
#define KYEL  "\x1B[0;33m"
#define KBYE  "\x1B[1;33m"
#define KDBL  "\x1B[0;34m"
#define KBLU  "\x1B[1;34m"
#define KMAG  "\x1B[0;35m"
#define KBMA  "\x1B[1;35m"
#define KCYN  "\x1B[0;36m"
#define KBCY  "\x1B[1;36m"
#define KWHT  "\x1B[0;37m"
#define KBWH  "\x1B[1;37m"
#define KNUL  ""

/* conditional color.  pass it a pointer to a char_data and a color level. */
#define C_OFF	0
#define C_SPR	1
#define C_NRM	2
#define C_CMP	3
#define _clrlevel(ch) ((PRF_FLAGGED((ch), PRF_COLOR_1) ? 1 : 0) + \
		       (PRF_FLAGGED((ch), PRF_COLOR_2) ? 2 : 0))
/* need to have the initial ch to stop it from going on if no character */
/* this is important in login screens since there is no ch yet */
/* if you want color on by default when there is no users, then: */
/* #define clr(ch,lvl) (!(ch) || _clrlevel(ch) >= (lvl)) */
#define clr(ch,lvl) (ch && _clrlevel(ch) >= (lvl))
#define CCNRM(ch,lvl)  (clr((ch),(lvl))?KNRM:KNUL)
#define CCRED(ch,lvl)  (clr((ch),(lvl))?KRED:KNUL)
#define CCBRE(ch,lvl)  (clr((ch),(lvl))?KBRE:KNUL)
#define CCGRN(ch,lvl)  (clr((ch),(lvl))?KGRN:KNUL)
#define CCBGR(ch,lvl)  (clr((ch),(lvl))?KBGR:KNUL)
#define CCYEL(ch,lvl)  (clr((ch),(lvl))?KYEL:KNUL)
#define CCBYE(ch,lvl)  (clr((ch),(lvl))?KBYE:KNUL)
#define CCDBL(ch,lvl)  (clr((ch),(lvl))?KDBL:KNUL)
#define CCBLU(ch,lvl)  (clr((ch),(lvl))?KBLU:KNUL)
#define CCMAG(ch,lvl)  (clr((ch),(lvl))?KMAG:KNUL)
#define CCBMA(ch,lvl)  (clr((ch),(lvl))?KBMA:KNUL)
#define CCCYN(ch,lvl)  (clr((ch),(lvl))?KCYN:KNUL)
#define CCBCY(ch,lvl)  (clr((ch),(lvl))?KBCY:KNUL)
#define CCWHT(ch,lvl)  (clr((ch),(lvl))?KWHT:KNUL)
#define CCBWH(ch,lvl)  (clr((ch),(lvl))?KBWH:KNUL)

#define COLOR_LEV(ch) (_clrlevel(ch))

#define QNRM CCNRM(ch,C_SPR)
#define QRED CCRED(ch,C_SPR)
#define QBRE CCBRE(ch,C_SPR)
#define QGRN CCGRN(ch,C_SPR)
#define QBGR CCBGR(ch,C_SPR)
#define QYEL CCYEL(ch,C_SPR)
#define QBYE CCBYE(ch,C_SPR)
#define QDBL CCDBL(ch,C_SPR)
#define QBLU CCBLU(ch,C_SPR)
#define QMAG CCMAG(ch,C_SPR)
#define QBMA CCBMA(ch,C_SPR)
#define QCYN CCCYN(ch,C_SPR)
#define QBCY CCBCY(ch,C_SPR)
#define QWHT CCWHT(ch,C_SPR)
#define QBWH CCBWH(ch,C_SPR)

