/* ************************************************************************
*   File: spec_assign.c                                 Part of CircleMUD *
*  Usage: Functions to assign function pointers to objs/mobs/rooms        *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */

#include "conf.h"
#include "sysdep.h"

#include "structs.h"
#include "db.h"
#include "interpreter.h"
#include "utils.h"
#include "boards.h"

extern struct room_data *world;
extern int top_of_world;
extern int mini_mud;
extern struct char_data *mob_proto;
extern struct index_data *mob_index;
extern struct index_data *obj_index;
extern struct board_info_type board_info[NUM_OF_BOARDS];


/* functions to perform assignments */

void ASSIGNMOB(int mob, SPECIAL(fname))
{
  if (real_mobile(mob) >= 0) {
    mob_index[real_mobile(mob)].func = fname;
    SET_BIT(MOB_FLAGS(mob_proto + real_mobile(mob)), MOB_SPEC);
  } else if (!mini_mud) {
    sprintf(buf, "SYSERR: Attempt to assign spec to non-existant mob #%d",
	    mob);
    nmlog(buf);
  }
}

void ASSIGNOBJ(int obj, SPECIAL(fname))
{
  if (real_object(obj) >= 0)
    obj_index[real_object(obj)].func = fname;
  else if (!mini_mud) {
    sprintf(buf, "SYSERR: Attempt to assign spec to non-existant obj #%d",
	    obj);
    nmlog(buf);
  }
}

void ASSIGNROOM(int room, SPECIAL(fname))
{
  if (real_room(room) >= 0)
    world[real_room(room)].func = fname;
  else if (!mini_mud) {
    sprintf(buf, "SYSERR: Attempt to assign spec to non-existant rm. #%d",
	    room);
    nmlog(buf);
  }
}


/* ********************************************************************
*  Assignments                                                        *
******************************************************************** */

/* assign special procedures to mobiles */
void assign_mobiles(void)
{
  SPECIAL(postmaster);
  SPECIAL(cityguard);
  SPECIAL(receptionist);
  SPECIAL(cryogenicist);
  SPECIAL(guild_guard);
  SPECIAL(guild);
  SPECIAL(puff);
  SPECIAL(guardian);
  SPECIAL(kalpet);
  SPECIAL(TKCers);
  SPECIAL(evil_lich);
  SPECIAL(ghoul);
  SPECIAL(scorpion);
  SPECIAL(CDAers);
  SPECIAL(demon);
  SPECIAL(barny);
  SPECIAL(fido);
  SPECIAL(janitor);
  SPECIAL(blob);
  SPECIAL(mayor);
  SPECIAL(snake);
  SPECIAL(thief);
  SPECIAL(magic_user);
  SPECIAL(ganon);
  SPECIAL(lynx);
  SPECIAL(baby);
  SPECIAL(cleric);
  SPECIAL(minstrel);
  SPECIAL(wilson);
  SPECIAL(dragon);
  SPECIAL(elves); /*jabber*/
  SPECIAL(dinos); /*jabber*/
  SPECIAL(mudzones);/*jabber*/
  SPECIAL(Happy_Noodle_Boy);
  SPECIAL(elminster);
  SPECIAL(hoareb);
  SPECIAL(rewel);
  SPECIAL(munro);
  SPECIAL(midnight);
  SPECIAL(lhaeo);
  SPECIAL(adon);
  SPECIAL(citizen);
  SPECIAL(rocker);
  SPECIAL(brother);
  SPECIAL(friend);
  SPECIAL(saurial);
  SPECIAL(storm);
  SPECIAL(torm);
  SPECIAL(bane);
  SPECIAL(myrkul);
  SPECIAL(mystra);
  SPECIAL(hanilzone);
  SPECIAL(finalfantasy);
  SPECIAL(furytwin);
  SPECIAL(furyhelper);

  void assign_kings_castle(void);

  assign_kings_castle();

  ASSIGNMOB(1, puff);
  ASSIGNMOB(13201, baby); /* Bouncing baby */

  /* Immortal Zone */
  ASSIGNMOB(6, Happy_Noodle_Boy);
  ASSIGNMOB(1200, receptionist);
  ASSIGNMOB(1201, postmaster);
  ASSIGNMOB(1202, janitor);
  ASSIGNMOB(1458, furytwin);
  ASSIGNMOB(1466, furyhelper);

  /* Midgaard */
  ASSIGNMOB(3005, receptionist);
  ASSIGNMOB(3010, postmaster);
  ASSIGNMOB(3020, guild);
  ASSIGNMOB(3021, guild);
  ASSIGNMOB(3022, guild);
  ASSIGNMOB(3023, guild);
  ASSIGNMOB(3024, guild_guard);
  ASSIGNMOB(3025, guild_guard);
  ASSIGNMOB(3026, guild_guard);
  ASSIGNMOB(3027, guild_guard);
  ASSIGNMOB(3059, cityguard);
  ASSIGNMOB(3060, cityguard);
  ASSIGNMOB(3061, janitor);
  ASSIGNMOB(3062, fido);
  ASSIGNMOB(3066, fido);
  ASSIGNMOB(3067, cityguard);
  ASSIGNMOB(3068, blob);
  ASSIGNMOB(3095, cryogenicist);
  ASSIGNMOB(3105, mayor);
  ASSIGNMOB(3096, guild_guard);      /*     KAKO        */
  ASSIGNMOB(3097, guild);            
  ASSIGNMOB(3099, guild);            /*  urrr como      */
  ASSIGNMOB(3070, guild_guard);      /* urrr me again   */
  ASSIGNMOB(3069, guild_guard);      /*  guess who      */
  ASSIGNMOB(8003, guild_guard);      /* i wonder...	*/
  ASSIGNMOB(8004, guild);	     /*  hmmm.. bye	*/
  ASSIGNMOB(3125, guild);            /* Charon */
  ASSIGNMOB(3124, guild_guard);      /* wuz here */

  /* MORIA */
  ASSIGNMOB(4000, snake);
  ASSIGNMOB(4001, snake);
  ASSIGNMOB(4053, snake);
  ASSIGNMOB(4100, magic_user);
  ASSIGNMOB(4102, snake);
  ASSIGNMOB(4103, thief);

  /* Redferne's */
  ASSIGNMOB(7900, cityguard);

  /* PYRAMID */
  ASSIGNMOB(5300, snake);
  ASSIGNMOB(5301, snake);
  ASSIGNMOB(5304, thief);
  ASSIGNMOB(5305, thief);
  ASSIGNMOB(5309, magic_user); /* should breath fire */
  ASSIGNMOB(5311, magic_user);
  ASSIGNMOB(5313, magic_user); /* should be a cleric */
  ASSIGNMOB(5314, magic_user); /* should be a cleric */
  ASSIGNMOB(5315, magic_user); /* should be a cleric */
  ASSIGNMOB(5316, magic_user); /* should be a cleric */
  ASSIGNMOB(5317, magic_user);

  /* High Tower Of Sorcery */
  ASSIGNMOB(2501, magic_user); /* should likely be cleric */
  ASSIGNMOB(2504, magic_user);
  ASSIGNMOB(2507, magic_user);
  ASSIGNMOB(2508, magic_user);
  ASSIGNMOB(2510, magic_user);
  ASSIGNMOB(2511, thief);
  ASSIGNMOB(2514, magic_user);
  ASSIGNMOB(2515, magic_user);
  ASSIGNMOB(2516, magic_user);
  ASSIGNMOB(2517, magic_user);
  ASSIGNMOB(2518, magic_user);
  ASSIGNMOB(2520, magic_user);
  ASSIGNMOB(2521, magic_user);
  ASSIGNMOB(2522, magic_user);
  ASSIGNMOB(2523, magic_user);
  ASSIGNMOB(2524, magic_user);
  ASSIGNMOB(2525, magic_user);
  ASSIGNMOB(2526, magic_user);
  ASSIGNMOB(2527, magic_user);
  ASSIGNMOB(2528, magic_user);
  ASSIGNMOB(2529, magic_user);
  ASSIGNMOB(2530, magic_user);
  ASSIGNMOB(2531, magic_user);
  ASSIGNMOB(2532, magic_user);
  ASSIGNMOB(2533, magic_user);
  ASSIGNMOB(2534, magic_user);
  ASSIGNMOB(2536, magic_user);
  ASSIGNMOB(2537, magic_user);
  ASSIGNMOB(2538, magic_user);
  ASSIGNMOB(2540, magic_user);
  ASSIGNMOB(2541, magic_user);
  ASSIGNMOB(2548, magic_user);
  ASSIGNMOB(2549, magic_user);
  ASSIGNMOB(2552, magic_user);
  ASSIGNMOB(2553, magic_user);
  ASSIGNMOB(2554, magic_user);
  ASSIGNMOB(2556, magic_user);
  ASSIGNMOB(2557, magic_user);
  ASSIGNMOB(2559, magic_user);
  ASSIGNMOB(2560, magic_user);
  ASSIGNMOB(2562, magic_user);
  ASSIGNMOB(2564, magic_user);
  /* SHIRE */
/*
  ASSIGNMOB(3706, guild);
  ASSIGNMOB(3759, cityguard);
  ASSIGNMOB(3760, cityguard);
  ASSIGNMOB(3761, janitor); 
*/

  /* SEWERS */
  ASSIGNMOB(7006, snake);
  ASSIGNMOB(7009, magic_user);
  ASSIGNMOB(7200, magic_user);
  ASSIGNMOB(7201, magic_user);
  ASSIGNMOB(7202, magic_user);

  /* FOREST */
  ASSIGNMOB(6112, magic_user);
  ASSIGNMOB(6113, snake);
  ASSIGNMOB(6114, magic_user);
  ASSIGNMOB(6115, magic_user);
  ASSIGNMOB(6116, magic_user); /* should be a cleric */
  ASSIGNMOB(6117, magic_user);

  /* ARACHNOS */
  ASSIGNMOB(6302, magic_user);
  ASSIGNMOB(6309, magic_user);
  ASSIGNMOB(6312, magic_user);
  ASSIGNMOB(6314, magic_user);
  ASSIGNMOB(6315, magic_user);

  /* Desert */
  ASSIGNMOB(5004, magic_user);
  ASSIGNMOB(5005, guild_guard); /* brass dragon */
  ASSIGNMOB(5010, magic_user);
  ASSIGNMOB(5014, magic_user);

  /* Drow City */
  ASSIGNMOB(5103, magic_user);
  ASSIGNMOB(5104, magic_user);
  ASSIGNMOB(5107, magic_user);
  ASSIGNMOB(5108, magic_user);

  /* Old Thalos */
  ASSIGNMOB(5200, magic_user);
  ASSIGNMOB(5201, magic_user);
  ASSIGNMOB(5209, magic_user);

  /* New Thalos */
/* 5481 - Cleric (or Mage... but he IS a high priest... *shrug*) */
  ASSIGNMOB(5404, receptionist);
  ASSIGNMOB(5421, magic_user);
  ASSIGNMOB(5422, magic_user);
  ASSIGNMOB(5423, magic_user);
  ASSIGNMOB(5424, magic_user);
  ASSIGNMOB(5425, magic_user);
  ASSIGNMOB(5426, magic_user);
  ASSIGNMOB(5427, magic_user);
  ASSIGNMOB(5428, magic_user);
  ASSIGNMOB(5434, cityguard);
  ASSIGNMOB(5440, magic_user);
  ASSIGNMOB(5455, magic_user);
  ASSIGNMOB(5461, cityguard);
  ASSIGNMOB(5462, cityguard);
  ASSIGNMOB(5463, cityguard);
  ASSIGNMOB(5482, cityguard);
/*
5400 - Guildmaster (Mage)
5401 - Guildmaster (Cleric)
5402 - Guildmaster (Warrior)
5403 - Guildmaster (Thief)
5456 - Guildguard (Mage)
5457 - Guildguard (Cleric)
5458 - Guildguard (Warrior)
5459 - Guildguard (Thief)
*/

  /* ROME */
  ASSIGNMOB(12009, magic_user);
  ASSIGNMOB(12018, cityguard);
  ASSIGNMOB(12020, magic_user);
  ASSIGNMOB(12021, cityguard);
  ASSIGNMOB(12025, magic_user);
  ASSIGNMOB(12030, magic_user);
  ASSIGNMOB(12031, magic_user);
  ASSIGNMOB(12032, magic_user);

  /* King Welmar's Castle (not covered in castle.c) */
  ASSIGNMOB(15015, thief);      /* Ergan... have a better idea? */
  ASSIGNMOB(15032, magic_user); /* Pit Fiend, have something better?  Use it */

  /* DWARVEN KINGDOM */
  ASSIGNMOB(6500, cityguard);
  ASSIGNMOB(6502, magic_user);
  ASSIGNMOB(6509, magic_user);
  ASSIGNMOB(6516, magic_user);
  /* Midkemia -- Cantessa's Zone */
  ASSIGNMOB(8608, magic_user);   /* Kulgan */

  /* Sparta */
  ASSIGNMOB(21085, fido);
  ASSIGNMOB(21003, cityguard);
  ASSIGNMOB(21084, janitor);
  ASSIGNMOB(21072, guild);
  ASSIGNMOB(21073, guild);
  ASSIGNMOB(21074, guild);
  ASSIGNMOB(21075, guild);

  /* Trivia */
  ASSIGNMOB(13602, magic_user);
  ASSIGNMOB(13606, magic_user);
  ASSIGNMOB(13610, magic_user);

  /* Rand's Tower */
  ASSIGNMOB(6409, snake);
  ASSIGNMOB(6410, scorpion);
  ASSIGNMOB(6406, ghoul);
  ASSIGNMOB(6407, evil_lich);
  ASSIGNMOB(6408, magic_user);

  /* CDA clanhall */
  ASSIGNMOB(4404, CDAers);

  /* Nothing -- Nobodys's Zone */
  ASSIGNMOB(2001, magic_user); /*Demonic Wizard*/

  /* Paradise                  */
/*
  ASSIGNMOB(10106, guild);
  ASSIGNMOB(10159, cityguard);
  ASSIGNMOB(10160, cityguard);
  ASSIGNMOB(10161, janitor);
*/

  /* Scarborough Faire */
  ASSIGNMOB(838, magic_user); /* Lauren */
  ASSIGNMOB(823, magic_user); /* Rowan */
  ASSIGNMOB(815, magic_user); /* Becket */
  ASSIGNMOB(841, wilson); /* Wilson */
  ASSIGNMOB(840, magic_user); /* Merlin */
  ASSIGNMOB(818, cityguard); /* Constable */
  ASSIGNMOB(816, minstrel); /* Minstrel */
  ASSIGNMOB(817, thief); /* Crafty Child */
  ASSIGNMOB(843, cityguard); /* Beefeater */
  ASSIGNMOB(846, guardian); /* Chief Beefeater */
  ASSIGNMOB(851, cleric); /* Simeon */
  ASSIGNMOB(847, evil_lich); /* Blake */
  ASSIGNMOB(3804, thief); 
  ASSIGNMOB(826, evil_lich); /* Sweeney */

  /* Brownie Village */
 ASSIGNMOB (21801, dragon);  /* Dredd */

  /* Galad's zones */
/*  ASSIGNMOB(21705, magic_user); */

  /* Jabber's elf zone */
  ASSIGNMOB(1328, dragon); /*jabber*/
  ASSIGNMOB(1305, elves); /*jabber*/
  ASSIGNMOB(1306, elves); /*jabber*/
  ASSIGNMOB(1307, elves); /*jabber*/
  ASSIGNMOB(1308, elves); /*jabber*/
  ASSIGNMOB(1309, elves); /*jabber*/
  ASSIGNMOB(1312, elves); /*jabber*/
  ASSIGNMOB(1313, elves); /*jabber*/
  ASSIGNMOB(1314, elves); /*jabber*/
  ASSIGNMOB(1315, elves); /*jabber*/
  ASSIGNMOB(1316, elves); /*jabber*/
  ASSIGNMOB(1317, elves); /*jabber*/
  ASSIGNMOB(1318, elves); /*jabber*/
  ASSIGNMOB(1319, elves); /*jabber*/
  ASSIGNMOB(1324, elves); /*jabber*/
  ASSIGNMOB(2701, dinos); /*jabber*/
  ASSIGNMOB(2702, dinos); /*jabber*/
  ASSIGNMOB(2704, dinos); /*jabber*/
  ASSIGNMOB(907,    mudzones); /*jabber*/
  ASSIGNMOB(21023,  mudzones); /*jabber*/
  ASSIGNMOB(21038,  mudzones); /*jabber*/
  ASSIGNMOB(12023,  mudzones); /*jabber*/
  ASSIGNMOB(5002,   mudzones); /*jabber*/
  ASSIGNMOB(7001,   mudzones); /*jabber*/
  ASSIGNMOB(7002,   mudzones); /*jabber*/
  ASSIGNMOB(24300,  mudzones); /*jabber*/
  ASSIGNMOB(2131,   mudzones); /*GtG for musashi*/
  ASSIGNMOB(2133,   mudzones); /*GtG for musashi*/
  
  /* Fury's Zone - Zone 14 */
  ASSIGNMOB(1409, elminster);
  ASSIGNMOB(1424, hoareb);
  ASSIGNMOB(1425, rewel);
  ASSIGNMOB(1426, munro);
  ASSIGNMOB(1406, midnight);
  ASSIGNMOB(1449, lhaeo);
  ASSIGNMOB(1404, adon);
  ASSIGNMOB(1401, citizen);
  ASSIGNMOB(1416, rocker);
  ASSIGNMOB(1417, brother);
  ASSIGNMOB(1459, friend);
  ASSIGNMOB(1415, saurial);
  ASSIGNMOB(1402, storm);
  ASSIGNMOB(1435, torm);
  ASSIGNMOB(1437, bane);
  ASSIGNMOB(1442, myrkul);
  ASSIGNMOB(1448, mystra);

  ASSIGNMOB(12560, guild_guard);  /* Rancor */  

  /* Hanil's zone */
  ASSIGNMOB(6702, hanilzone);
  ASSIGNMOB(6704, hanilzone);
  ASSIGNMOB(6706, hanilzone);
  ASSIGNMOB(6711, hanilzone);
  ASSIGNMOB(6712, hanilzone);
  ASSIGNMOB(6713, hanilzone);
  ASSIGNMOB(6714, hanilzone);
  ASSIGNMOB(6716, hanilzone);
  ASSIGNMOB(6720, hanilzone);
  ASSIGNMOB(6721, hanilzone);
  ASSIGNMOB(6723, hanilzone);
  
  /* Jago's Zone - Final Fantasy */
  ASSIGNMOB(7700, finalfantasy);
  ASSIGNMOB(7701, finalfantasy);
  ASSIGNMOB(7703, finalfantasy);
  ASSIGNMOB(7704, finalfantasy);
  ASSIGNMOB(7707, finalfantasy);
  ASSIGNMOB(7708, finalfantasy);
  ASSIGNMOB(7709, finalfantasy);
  ASSIGNMOB(7710, finalfantasy);
  ASSIGNMOB(7714, finalfantasy);
  ASSIGNMOB(7724, finalfantasy);
  ASSIGNMOB(7719, finalfantasy);
  ASSIGNMOB(7736, finalfantasy);
  ASSIGNMOB(7739, finalfantasy);

}


/* assign special procedures to objects */
void assign_objects(void)
{
  SPECIAL(bank);
  SPECIAL(gen_board);
  SPECIAL(slots);
  SPECIAL(portal);
  SPECIAL(nomudcon);
  
  int x;
  for (x = 0; x < NUM_OF_BOARDS; x++)
    ASSIGNOBJ(board_info[x].vnum, gen_board); 

/*    NOTE: You don't need to assign each board manually anymore *
  ASSIGNOBJ(3006, gen_board);   |* COS clan board -Myrddin *|
  ASSIGNOBJ(3012, gen_board);   |*LOTR clan board-Rowan*|
  ASSIGNOBJ(3096, gen_board);	|* social board *|
  ASSIGNOBJ(3097, gen_board);	|* freeze board *|
  ASSIGNOBJ(3098, gen_board);	|* immortal board *|
  ASSIGNOBJ(3099, gen_board);	|* mortal board *|
  ASSIGNOBJ(3095, gen_board);   |* implementor board  KAKO *|  
  ASSIGNOBJ(3094, gen_board);   |* builder board KAKO *|
  ASSIGNOBJ(3093, gen_board);   |* information board *|
  ASSIGNOBJ(3119, gen_board);   |*CDA clan board Rowan*|
  ASSIGNOBJ(3121, gen_board);   |*COTN clan board Rowan*|
  ASSIGNOBJ(3007, gen_board);   |*JEDI clan board Rowan*|
  ASSIGNOBJ(3092, gen_board);	|* coder board KAKO *|
  ASSIGNOBJ(3937, gen_board);   |* Immortal App board Rowan*|
  ASSIGNOBJ(4402, gen_board);   |* NHN board.. Myrddin *|
  ASSIGNOBJ(4419, gen_board);   |*CSR clan board Rowan*|
  ASSIGNOBJ(10234, gen_board);   |* Suggestion board MISERY *|
  ASSIGNOBJ(10235, gen_board);   |* poll board MISERY *|
  ASSIGNOBJ(10237, gen_board);   |* Miscellaneous board MISERY *|
  ASSIGNOBJ(10238, gen_board);   |* Complaint board MISERY *|
  ASSIGNOBJ(10239, gen_board);   |* ETC board MISERY *|
  ASSIGNOBJ(10242, gen_board);   |* matchmaker board MISERY *|
  ASSIGNOBJ(10243, gen_board);   |* bored board MISERY *|
  ASSIGNOBJ(10250, gen_board);   |* FAQ board MISERY *|
  ASSIGNOBJ(10258, gen_board);   |* Demi-Gods Misery *|
  ASSIGNOBJ(13036, gen_board);   |* TKC Clan Board Rowan*|
  ASSIGNOBJ(1213 , gen_board);   |* Promotion Board *|
  ASSIGNOBJ(3118 , gen_board);   |* SDC Clan Board CHARON *|
  ASSIGNOBJ(1930, gen_board);    |* LUSH Clan Board BlackRose *|
  ASSIGNOBJ(8203, gen_board);    |* TSF board *|
  ASSIGNOBJ(10245, gen_board);   |* Advertisement board *|
*/
  ASSIGNOBJ(3034, bank);	/* atm */
  ASSIGNOBJ(3036, bank);	/* cashcard */
  ASSIGNOBJ(8508, slots);       /* temp slot machine */
  ASSIGNOBJ(23400, slots);      /* slot machine #1 */
  ASSIGNOBJ(23401, slots);      /* slot machine #2 */
  ASSIGNOBJ(31, portal);        /* portal obj */
  ASSIGNOBJ(33, nomudcon);      /* NomudCon shirt */
}



/* assign special procedures to rooms */
void assign_rooms(void)
{
  extern int dts_are_dumps;
  int i;

  SPECIAL(dump);
  SPECIAL(pet_shops);
  SPECIAL(phone_booth);
  SPECIAL(pray_for_items);
  SPECIAL(gym);
  SPECIAL(twinsroom);

  ASSIGNROOM(3030, dump);
  ASSIGNROOM(3031, pet_shops);
  ASSIGNROOM(13219, phone_booth);
  ASSIGNROOM(13238, gym);
  ASSIGNROOM(1549, twinsroom);

  if (dts_are_dumps)
    for (i = 0; i < top_of_world; i++)
      if (IS_SET(ROOM_FLAGS(i), ROOM_DEATH))
	world[i].func = dump;
}
