/* ************************************************************************
*   File: spells.h                                      Part of CircleMUD *
*  Usage: header file: constants and fn prototypes for spell system       *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */

#define DEFAULT_STAFF_LVL	12
#define DEFAULT_WAND_LVL	12

#define CAST_UNDEFINED	-1
#define CAST_SPELL	0
#define CAST_POTION	1
#define CAST_WAND	2
#define CAST_STAFF	3
#define CAST_SCROLL	4

#define MAG_DAMAGE	(1 << 0)
#define MAG_AFFECTS	(1 << 1)
#define MAG_UNAFFECTS	(1 << 2)
#define MAG_POINTS	(1 << 3)
#define MAG_ALTER_OBJS	(1 << 4)
#define MAG_GROUPS	(1 << 5)
#define MAG_MASSES	(1 << 6)
#define MAG_AREAS	(1 << 7)
#define MAG_SUMMONS	(1 << 8)
#define MAG_CREATIONS	(1 << 9)
#define MAG_MANUAL	(1 << 10)


#define TYPE_UNDEFINED               -1
#define SPELL_RESERVED_DBC            0  /* SKILL NUMBER ZERO -- RESERVED */

/* PLAYER SPELLS -- Numbered from 1 to MAX_SPELLS */

#define SPELL_ARMOR                   1 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_TELEPORT                2 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_BLESS                   3 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_BLINDNESS               4 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_BURNING_HANDS           5 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_CALL_LIGHTNING          6 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_CHARM                   7 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_CHILL_TOUCH             8 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_CLONE                   9 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_COLOR_SPRAY            10 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_CONTROL_WEATHER        11 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_CREATE_FOOD            12 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_CREATE_WATER           13 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_CURE_BLIND             14 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_CURE_CRITIC            15 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_CURE_LIGHT             16 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_CURSE                  17 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_DETECT_ALIGN           18 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_DETECT_INVIS           19 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_DETECT_MAGIC           20 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_DETECT_POISON          21 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_DISPEL_EVIL            22 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_EARTHQUAKE             23 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_ENCHANT_WEAPON         24 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_ENERGY_DRAIN           25 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_FIREBALL               26 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_HARM                   27 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_HEAL                   28 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_INVISIBLE              29 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_LIGHTNING_BOLT         30 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_LOCATE_OBJECT          31 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_MAGIC_MISSILE          32 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_POISON                 33 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_PROT_FROM_EVIL         34 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_REMOVE_CURSE           35 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_SANCTUARY              36 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_SHOCKING_GRASP         37 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_SLEEP                  38 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_STRENGTH               39 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_SUMMON                 40 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_VENTRILOQUATE          41 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_WORD_OF_RECALL         42 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_REMOVE_POISON          43 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_SENSE_LIFE             44 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_ANIMATE_DEAD	     45 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_DISPEL_GOOD	     46 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_GROUP_ARMOR	     47 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_GROUP_HEAL	     48 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_GROUP_RECALL	     49 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_INFRAVISION	     50 /* Reserved Skill[] DO NOT CHANGE */
#define SPELL_WATERWALK		     51 /* Reserved Skill[] DO NOT CHANGE */
/*   KAKO   */
#define SPELL_ASTRAL_WALK            52 /* Added spell by Kako            */
#define SPELL_FLIGHT                 53 /* Added spell by Kako            */
#define SPELL_VIGORIZE		     54 /* Added spell by Kako            */
#define SPELL_REM_INVIS              55 /* Added spell by Kako            */
#define SPELL_VAMPIRIC_TOUCH         56 /* Added spell by Kako            */
#define SPELL_CURE_SERIOUS           57 /* Added spell by Kako            */
#define SPELL_CREATE_FAMILIAR        58 /* Added spell -=FAMILIAR=-       */
#define SPELL_FAERIE_FIRE	     59 /* Added spell by Kako            */
#define SPELL_FLAME_BLADE            60 /* Added spell by Kako            */
#define SPELL_ENERGY_BLAST           62
#define SPELL_MANA_BOLT              63
#define SPELL_MANA_WAVE              64
#define SPELL_FIRE_STORM             65
#define SPELL_DEATH_WIND             66
#define SPELL_BLUR		     67
#define SPELL_SCRY		     68
#define SPELL_FEAR		     69 /* Beginning of spells by Myst */
#define SPELL_GATE                   70
#define SPELL_DISPEL_MAGIC	     71
#define SPELL_PARALYZE               72
#define SPELL_PWR_WRD_STUN           73
#define SPELL_PACIFY                 74
#define SPELL_TURN_UNDEAD            75 /* Charon's new spell for NPC classes */
#define SPELL_HASTE                  76
#define SPELL_WEB                    77
#define SPELL_SLOW                   78
#define SPELL_PORTAL		     79
#define SPELL_DECOMPOSE              80
#define SPELL_HEROES_FEAST           81
#define SPELL_SHIELD                 82 
#define SPELL_STONESKIN              83
#define SPELL_ROWANS_PIZZA	     84
#define SPELL_REVERSAL               85
#define SPELL_SANDSTORM              86
#define SPELL_GROUP_BLESS            87
#define SPELL_BLADE_LEGEND           88
#define SPELL_PALADIN_FURY           89
#define SPELL_BANISH_EVIL            90
#define SPELL_HOLY_AURA              91
#define SPELL_STRATOS_RACING         92
#define SPELL_DIVINE_PROT            93
#define SPELL_BLINK                  94

/* Insert new spells here, up to MAX_SPELLS */
#define MAX_SPELLS		    130

/* PLAYER SKILLS - Numbered from MAX_SPELLS+1 to MAX_SKILLS */
#define SKILL_BACKSTAB              131 /* Reserved Skill[] DO NOT CHANGE */
#define SKILL_BASH                  132 /* Reserved Skill[] DO NOT CHANGE */
#define SKILL_HIDE                  133 /* Reserved Skill[] DO NOT CHANGE */
#define SKILL_KICK                  134 /* Reserved Skill[] DO NOT CHANGE */
#define SKILL_PICK_LOCK             135 /* Reserved Skill[] DO NOT CHANGE */
#define SKILL_PUNCH                 136 /* Reserved Skill[] DO NOT CHANGE */
#define SKILL_RESCUE                137 /* Reserved Skill[] DO NOT CHANGE */
#define SKILL_SNEAK                 138 /* Reserved Skill[] DO NOT CHANGE */
#define SKILL_STEAL                 139 /* Reserved Skill[] DO NOT CHANGE */
#define SKILL_TRACK		    140 /* Reserved Skill[] DO NOT CHANGE */
#define SKILL_SECOND_ATTACK         141 /* Reserved Skill[] DO NOT CHANGE */
#define SKILL_DODGE                 142 /* KAKO Dodge skill               */
#define SKILL_JUMP                  143 /* KAKO Jump skill                */
#define SKILL_DISARM		    144 /* KAKO Disarm skill	 	  */
#define SKILL_PARRY                 145 /* KAKO Parry skill               */
#define SKILL_DOUBLE_BS             146 /* Double backstab skill          */
#define SKILL_TRIP                  147 /* Trip                           */
#define SKILL_PALM                  148 /* Palm                           */
#define SKILL_DOORBASH              149 /* Door Bash                      */
#define SKILL_HEADBUTT              150 /* Headbutt                       */
#define SKILL_CHARGE                151 /* Charge                         */
#define SKILL_RIDING                152 /* Ride 'em cowboy!!              */
#define SKILL_BERSERK               153 /* Berserk!                       */
#define SKILL_WRESTLE               154 /* Let's rassle!                  */
#define SKILL_THIRD_ATTACK          155 /* dwix: third attack             */
#define SKILL_FOURTH_ATTACK         156 /* dwix: fourth attack            */
#define SKILL_FIFTH_ATTACK          157 /* dwix: fifth attack             */
#define SKILL_SIXTH_ATTACK          158 /* dwix: sixth attack             */
#define SKILL_NSTRIKE               159 /* dwix: nstrike                  */
#define SKILL_SOULSTRIKE	    160 /* Soulstrike, Myst		  */
#define SKILL_ARCHERY               161 /* rangemod Archery               */
#define SKILL_FIREARMS              162 /* rangemod Firearms              */
#define SKILL_CIRCLE                163 /* circle backstab                */
#define SKILL_2HAND                 164 /* 2-handed proficiency           */
#define SKILL_FORAGE                165 /* forage skill                   */
/* New skills may be added here up to MAX_SKILLS (200) */


/*
 *  NON-PLAYER AND OBJECT SPELLS AND SKILLS
 *  The practice levels for the spells and skills below are _not_ recorded
 *  in the playerfile; therefore, the intended use is for spells and skills
 *  associated with objects (such as SPELL_IDENTIFY used with scrolls of
 *  identify) or non-players (such as NPC-only spells).
 */

#define SPELL_IDENTIFY               201
#define SPELL_FIRE_BREATH            202
#define SPELL_GAS_BREATH             203
#define SPELL_FROST_BREATH           204
#define SPELL_ACID_BREATH            205
#define SPELL_LIGHTNING_BREATH       206
#define SPELL_MANA_REGEN             207

#define TOP_SPELL_DEFINE	     299
/* NEW NPC/OBJECT SPELLS can be inserted here up to 299 */


/* WEAPON ATTACK TYPES */

#define TYPE_HIT                     300
#define TYPE_STING                   301
#define TYPE_WHIP                    302
#define TYPE_SLASH                   303
#define TYPE_BITE                    304
#define TYPE_BLUDGEON                305
#define TYPE_CRUSH                   306
#define TYPE_POUND                   307
#define TYPE_CLAW                    308
#define TYPE_MAUL                    309
#define TYPE_THRASH                  310
#define TYPE_PIERCE                  311
#define TYPE_BLAST		     312
#define TYPE_PUNCH		     313
#define TYPE_STAB		     314

/* new attack types can be added here - up to TYPE_SUFFERING */
#define TYPE_SUFFERING		     399
#define TYPE_THIRST                  400
#define TYPE_FALL                    401
#define TYPE_BACKFIRE		     402
#define TYPE_EFFORT		     403
#define TYPE_RANGED                  404
#define TYPE_DEATHTRAP              405



#define SAVING_PARA   0
#define SAVING_ROD    1
#define SAVING_PETRI  2
#define SAVING_BREATH 3
#define SAVING_SPELL  4

#define NUM_SAVING	5 /* This is the number of saving throws KAKO */

#define TAR_IGNORE        1
#define TAR_CHAR_ROOM     2
#define TAR_CHAR_WORLD    4
#define TAR_FIGHT_SELF    8
#define TAR_FIGHT_VICT   16
#define TAR_SELF_ONLY    32 /* Only a check, use with i.e. TAR_CHAR_ROOM */
#define TAR_NOT_SELF     64 /* Only a check, use with i.e. TAR_CHAR_ROOM */
#define TAR_OBJ_INV     128
#define TAR_OBJ_ROOM    256
#define TAR_OBJ_WORLD   512
#define TAR_OBJ_EQUIP  1024

struct spell_info_type {
   byte min_position;	/* Position for caster	 */
   byte mana_min;	/* Min amount of mana used by a spell (highest lev) */
   byte mana_max;	/* Max amount of mana used by a spell (lowest lev) */
   byte mana_change;	/* Change in mana used by spell from lev to lev */

   byte min_level[NUM_CLASSES];
   int learned[NUM_CLASSES];
   int routines;
   byte violent;
   sh_int targets;         /* See below for use with TAR_XXX  */
   int remort[NUM_CLASSES];
};

/* Possible Targets:

   bit 0 : IGNORE TARGET
   bit 1 : PC/NPC in room
   bit 2 : PC/NPC in world
   bit 3 : Object held
   bit 4 : Object in inventory
   bit 5 : Object in room
   bit 6 : Object in world
   bit 7 : If fighting, and no argument, select tar_char as self
   bit 8 : If fighting, and no argument, select tar_char as victim (fighting)
   bit 9 : If no argument, select self, if argument check that it IS self.

*/

#define SPELL_TYPE_SPELL   0
#define SPELL_TYPE_POTION  1
#define SPELL_TYPE_WAND    2
#define SPELL_TYPE_STAFF   3
#define SPELL_TYPE_SCROLL  4


/* Attacktypes with grammar */

struct attack_hit_type {
   char	*singular;
   char	*plural;
};


#define ASPELL(spellname) \
void    spellname(byte level, struct char_data *ch, \
                  struct char_data *victim, struct obj_data *obj, char *tstring, int cost)
 
#define MANUAL_SPELL(spellname) spellname(level, caster, cvict, ovict, tstring, cost);
 
ASPELL(spell_create_water);
ASPELL(spell_recall);
ASPELL(spell_teleport);
ASPELL(spell_summon);
ASPELL(spell_locate_object);
ASPELL(spell_charm);
ASPELL(spell_information);
ASPELL(spell_identify);
ASPELL(spell_enchant_weapon);
ASPELL(spell_detect_poison);
ASPELL(spell_astral_walk);       /*   KAKO   */
ASPELL(spell_energy_drain);
ASPELL(spell_create_familiar);
ASPELL(spell_clone);
ASPELL(spell_flame_blade);
ASPELL(spell_scry);
ASPELL(spell_fear);             /* MYST */
ASPELL(spell_dispel_magic);
ASPELL(spell_paralyze);
ASPELL(spell_power_word_stun);
ASPELL(spell_pacify);
ASPELL(spell_control_weather);
ASPELL(spell_portal);
ASPELL(spell_decompose);
ASPELL(spell_rowans_pizza);
ASPELL(spell_blade_legend);
ASPELL(spell_paladin_fury);
ASPELL(spell_stratos_racing);

/* basic magic calling functions */

int find_skill_num(char *name);

void mag_damage(int level, struct char_data *ch, struct char_data *victim,
  int spellnum, int savetype);

void mag_affects(int level, struct char_data *ch, struct char_data *victim,
  int spellnum, int savetype);

void mag_group_switch(int level, struct char_data *ch, struct char_data *tch, 
  int spellnum, int savetype);

void mag_groups(int level, struct char_data *ch, int spellnum, int savetype);

void mag_masses(int level, struct char_data *ch, int spellnum, int savetype);

void mag_areas(byte level, struct char_data *ch, int spellnum, int savetype);

void mag_summons(int level, struct char_data *ch, struct obj_data *obj,
 int spellnum, int savetype);

void mag_points(int level, struct char_data *ch, struct char_data *victim,
 int spellnum, int savetype);

void mag_unaffects(int level, struct char_data *ch, struct char_data *victim,
  int spellnum, int type);

void mag_alter_objs(int level, struct char_data *ch, struct obj_data *obj,
  int spellnum, int type);

void mag_creations(int level, struct char_data *ch, int spellnum);

int     call_magic(struct char_data *caster, struct char_data *cvict,
  struct obj_data *ovict, char *tstring, int spellnum, int level, 
  int cost, int casttype);

void	mag_objectmagic(struct char_data *ch, struct obj_data *obj,
			char *argument);

int     cast_spell(struct char_data *ch, struct char_data *tch,
  struct obj_data *tobj, char *tstring, int cost, int spellnum);
 

/* other prototypes */
void spell_level(int spell, int class, int level, int remort, int learned);
void init_spell_levels(void);
char *skill_name(int num);
