/* ************************************************************************
*  file:  boardtoascii.c                                Part of CircleMud *
*									  *
*  Usage: convert board files to ascii					  *
*  Copyright (C) 1990, 1991 - see 'license.doc' for complete information. *
*  All Rights Reserved                                                    *
************************************************************************* */

#include "../conf.h"
#include "../sysdep.h"

#include "../structs.h"
#include "../boards.h"

void make_index(void);
void convert_boards(void);
int get_line(FILE * fl, char *buf);

int main(void)
{
  make_index();
  convert_boards();
  return(0);
}

void make_index(void)
{
  if((system("ls -1 etc/board.* > board_index"))) {
    perror("Can't make board index");
    exit(1);
  }
}

void convert_boards(void)
{
  FILE *index_file, *boardfile, *newfile;
  char boardname[40], newname[44], *header, *message;
  int num_messages = 0, i;
  struct board_msginfo brd;

  if(!(index_file = fopen("board_index", "r"))) {
    perror("Can't open board index");
    exit(1);
  }

  while (!feof(index_file)) {
    get_line(index_file, boardname);

    if(!(boardfile = fopen(boardname, "rb"))) {
      perror("Error reading board file");
      exit(1);
    }

    sprintf(newname, "%s.new", boardname);
    if(!(newfile = fopen(newname, "w"))) {
      perror("Error writing board file");
      exit(1);
    }

    printf("Writing: %s\n", boardname);
    fread(&num_messages, sizeof(int), 1, boardfile);
    fprintf(newfile, "%i\n", num_messages);

    for(i = 0; i < num_messages; i++) {
      fread(&brd, sizeof(struct board_msginfo), 1, boardfile);
      if(!(header = (char *) malloc(sizeof(char) * brd.heading_len))) {
	perror("Can't allocate memory for strings");
	exit(1);
      }
      fread(header, sizeof(char), brd.heading_len, boardfile);

      if(!(message = (char *) malloc(sizeof(char) * brd.message_len))) {
	perror("Can't allocate memory for strings");
	exit(1);
      }
      fread(message, sizeof(char), brd.message_len, boardfile);
      fprintf(newfile, "%i %i\n%s\n%s\n~\n", brd.slot_num, brd.level,
	header, message);

      free(header);
      free(message);
    }
    fclose(boardfile);
    fclose(newfile);
  }
  fclose(index_file);
}


int get_line(FILE * fl, char *buf)
{
  char temp[256];
  int lines = 0;

  do {
    lines++;
    fgets(temp, 256, fl);
    if (*temp)
      temp[strlen(temp) - 1] = '\0';
  } while (!feof(fl) && (*temp == '*' || !*temp));

  if (feof(fl))
    return 0;
  else {
    strcpy(buf, temp);
    return lines;
  }
}
