/* ************************************************************************
*  file:  objtoascii.c.c                                Part of CircleMud *
*  Usage: convert obj files to ascii					  *
*  Copyright (C) 1990, 1991 - see 'license.doc' for complete information. *
*  All Rights Reserved                                                    *
************************************************************************* */

#include "../conf.h"
#include "../sysdep.h"

#include "../structs.h"

void convert_objects(void);
void sprintbits(long vektor,char *outstring);
int get_line(FILE * fl, char *buf);

int main(int argc, char **argv)
{
  convert_objects();
  return(0);
}


void convert_objects(void)
{
  FILE *obj_file, *index_file, *pfile, *outfile, *outfile2;
  char filename[40], outname[40], line[1024], outname2[40];
  char name[40], *dir, bits[40];
  int num, i;

  if(!(index_file = fopen("pfiles/plr_index", "r"))) {
    perror("Can't open player index");
    exit(1);
  }

  while (!feof(index_file)) {
    get_line(index_file, line);
    sscanf(line, "%d	%s\n", &num, name);

    sprintf(filename, "pfiles/%c/%s", *name, name);
    if(!(pfile = fopen(filename, "r"))) {
      perror("Can't open player file");
      exit(1);
    }
    sprintf(outname, "pfiles/%c/%s.new", *name, name);
    if(!(outfile = fopen(outname, "w"))) {
      perror("Can't open player output file");
      exit(1);
    }
    sprintf(outname2, "rent/%c/%s", *name, name);
    if(!(outfile2 = fopen(outname2, "w"))) {
      perror("Can't open rent output file");
      exit(1);
    }
    printf("Writing: %s\n", outname2);
    do {
      get_line(pfile, line);
      if(!feof(pfile) && strcmp(line, "Objs:"))
	fprintf(outfile, "%s\n", line);
    } while(!feof(pfile) && strcmp(line, "Objs:"));

    if(feof(pfile)) {
      fclose(pfile);
      fclose(outfile);
      fclose(outfile2);
      remove(outname2);
      rename(outname, filename);
      continue;
    }

    while(!feof(pfile)) {
      get_line(pfile, line);
      fprintf(outfile2, "%s\n", line);
    }
    fclose(pfile);
    fclose(outfile2);
    fclose(outfile);
    rename(outname, filename);
  }
  fclose(index_file);
}


int get_line(FILE * fl, char *buf)
{
  char temp[256];
  int lines = 0;

  do {
    lines++;
    fgets(temp, 256, fl);
    if (*temp)
      temp[strlen(temp) - 1] = '\0';
  } while (!feof(fl) && (*temp == '*' || !*temp));

  if (feof(fl))
    return 0;
  else {
    strcpy(buf, temp);
    return lines;
  }
}


/*thanks to Luis Carvalho for sending this my way..it's probably a
  lot shorter than the one I would have made :)  */
void sprintbits(long vektor,char *outstring)
{
  int i;
  char flags[53]="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

  strcpy(outstring,"");
  for (i=0;i<32;i++)
  {
    if (vektor & 1) {
      *outstring=flags[i];
      outstring++;
    };
    vektor>>=1;
  };
  *outstring=0;
};
