/* ************************************************************************
*  file:  plrtoascii.c                                  Part of CircleMud *
*  Copyright (C) 1990, 1991 - see 'license.doc' for complete information. *
*  All Rights Reserved                                                    *
************************************************************************* */

#include "../conf.h"
#include "../sysdep.h"

#include "../structs.h"
#include "../utils.h"

void sprintbits(long vektor,char *outstring);

void convert(char *filename)
{
  FILE *fl;
  struct char_file_u player;
  FILE *outfile, *index_file;
  char outname[40], bits[127];
  int i;
  struct char_special_data_saved *csds;
  struct player_special_data_saved *psds;
  struct char_ability_data *cad;
  struct char_point_data *cpd;
  struct affected_type *aff;

  if (!(fl = fopen(filename, "r+"))) {
    perror("error opening playerfile");
    exit(1);
  }
  if (!(index_file = fopen("pfiles/plr_index", "w"))) {
    perror("error opening index file");
    exit(1);
  }
  for (;;) {
    fread(&player, sizeof(struct char_file_u), 1, fl);
    if (feof(fl)) {
      fclose(fl);
      fclose(index_file);
      exit(1);
    }

    for(i = 0;
      (*(bits + i) = LOWER(*(player.name + i))); i++);
    sprintf(outname, "pfiles/%c/%s", *bits, bits);
    printf("writing: %s\n", outname);

    fprintf(index_file, "%d	%s\n", (int)player.char_specials_saved.idnum,
      bits);

    if (!(outfile = fopen(outname, "w"))) {
      perror("error opening output file");
      exit(1);
    }

/* char_file_u */
    if(player.name)
      fprintf(outfile, "Name: %s\n", player.name);
    if(player.pwd)
      fprintf(outfile, "Pass: %s\n", player.pwd);
    if(player.title)
      fprintf(outfile, "Titl: %s\n", player.title);
    if(player.description)
      fprintf(outfile, "Desc:\n%s~\n", player.description);
    if(player.sex)
      fprintf(outfile, "Sex : %d\n", (int)player.sex); 
    if(player.class)
      fprintf(outfile, "Clas: %d\n", (int)player.class); 
    if(player.level)
      fprintf(outfile, "Levl: %d\n", (int)player.level); 
    fprintf(outfile, "Brth: %d\n", (int)player.birth);
    fprintf(outfile, "Plyd: %d\n", (int)player.played);
    fprintf(outfile, "Last: %d\n", (int)player.last_logon);
    fprintf(outfile, "Host: %s\n", player.host);
    if(player.height)
      fprintf(outfile, "Hite: %d\n", (int)player.height);
    if(player.weight)
      fprintf(outfile, "Wate: %d\n", (int)player.weight);

/* char_special_data_saved */
    csds = &(player.char_specials_saved);
    if(csds->alignment)
      fprintf(outfile, "Alin: %d\n", csds->alignment);
    fprintf(outfile, "Id  : %d\n", (int)csds->idnum);
    if(csds->act)
      fprintf(outfile, "Act : %d\n", (int)csds->act);
    if(csds->affected_by) {
      sprintbits(csds->affected_by, bits);
      fprintf(outfile, "Aff : %s\n", bits);
    }
    if(csds->apply_saving_throw[0])
      fprintf(outfile, "Thr1: %d\n", csds->apply_saving_throw[0]);
    if(csds->apply_saving_throw[1])
      fprintf(outfile, "Thr2: %d\n", csds->apply_saving_throw[1]);
    if(csds->apply_saving_throw[2])
      fprintf(outfile, "Thr3: %d\n", csds->apply_saving_throw[2]);
    if(csds->apply_saving_throw[3])
      fprintf(outfile, "Thr4: %d\n", csds->apply_saving_throw[3]);
    if(csds->apply_saving_throw[4])
      fprintf(outfile, "Thr5: %d\n", csds->apply_saving_throw[4]);

/* player_special_data_saved */
    psds = &(player.player_specials_saved);
    if(player.level < LVL_IMMORT) {
      fprintf(outfile, "Skil:\n");
      for(i = 1; i <= MAX_SKILLS; i++) {
	if(psds->skills[i])
	  fprintf(outfile, "%d %d\n", i, (int)psds->skills[i]);
      }
      fprintf(outfile, "0 0\n");
    }
    if(psds->wimp_level)
      fprintf(outfile, "Wimp: %d\n", psds->wimp_level);
    if(psds->freeze_level)
      fprintf(outfile, "Frez: %d\n", (int)psds->freeze_level);
    if(psds->invis_level)
      fprintf(outfile, "Invs: %d\n", (int)psds->invis_level);
    if(psds->load_room)
      fprintf(outfile, "Room: %d\n", (int)psds->load_room);
    if(psds->pref) {
      sprintbits(psds->pref, bits);
      fprintf(outfile, "Pref: %s\n", bits);
    }
    if(psds->conditions[0] && player.level < LVL_IMMORT)
      fprintf(outfile, "Hung: %d\n", (int)psds->conditions[0]);
    if(psds->conditions[1] && player.level < LVL_IMMORT)
      fprintf(outfile, "Thir: %d\n", (int)psds->conditions[1]);
    if(psds->conditions[2] && player.level < LVL_IMMORT)
      fprintf(outfile, "Drnk: %d\n", (int)psds->conditions[2]);
    if(psds->clan)
      fprintf(outfile, "Clan: %d\n", (int)psds->clan);
    if(psds->race)
      fprintf(outfile, "Race: %d\n", (int)psds->race);
    if(psds->spells_to_learn)
      fprintf(outfile, "Lern: %d\n", (int)psds->spells_to_learn);
    if(psds->pkill_points)
      fprintf(outfile, "Pkpt: %d\n", (int)psds->pkill_points);
    if(psds->purity)
      fprintf(outfile, "Pure: %d\n", (int)psds->purity);
    if(psds->quest)
      fprintf(outfile, "Qust: %d\n", (int)psds->quest);

/* char_ability_data */
    cad = &(player.abilities);
    fprintf(outfile, "Str : %d/%d\n", cad->str, cad->str_add);
    fprintf(outfile, "Int : %d\n", cad->intel);
    fprintf(outfile, "Wis : %d\n", cad->wis);
    fprintf(outfile, "Dex : %d\n", cad->dex);
    fprintf(outfile, "Con : %d\n", cad->con);
    fprintf(outfile, "Cha : %d\n", cad->cha);

/* char_point_data */
    cpd = &(player.points);
    fprintf(outfile, "Hit : %d/%d\n", cpd->hit, cpd->max_hit);
    fprintf(outfile, "Mana: %d/%d\n", cpd->mana, cpd->max_mana);
    fprintf(outfile, "Move: %d/%d\n", cpd->move, cpd->max_move);
    fprintf(outfile, "Ac  : %d\n", cpd->armor);
    if(cpd->gold)
      fprintf(outfile, "Gold: %d\n", cpd->gold);
    if(cpd->bank_gold)
      fprintf(outfile, "Bank: %d\n", cpd->bank_gold);
    if(cpd->exp)
      fprintf(outfile, "Exp : %d\n", cpd->exp);
    if(cpd->hitroll)
      fprintf(outfile, "Hrol: %d\n", cpd->hitroll);
    if(cpd->damroll)
      fprintf(outfile, "Drol: %d\n", cpd->damroll);

/* affected_type */
    fprintf(outfile, "Affs:\n");
    for(i = 0; i < MAX_AFFECT; i++) {
      aff = &(player.affected[i]);
      if(aff->type)
	fprintf(outfile, "%d %d %d %d %d\n", aff->type, aff->duration,
	  aff->modifier, aff->location, (int)aff->bitvector);
    }
    fprintf(outfile, "0 0 0 0 0\n");

    fclose(outfile);
  }
}


int main(int argc, char **argv)
{
  if (argc != 2)
    printf("Usage: %s playerfile-name\n", argv[0]);
  else
    convert(argv[1]);

  return 0;
}


/*thanks to Luis Carvalho for sending this my way..it's probably a
  lot shorter than the one I would have made :)  */
void sprintbits(long vektor,char *outstring)
{
  int i;
  char flags[53]="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

  strcpy(outstring,"");
  for (i=0;i<32;i++)
  {
    if (vektor & 1) {
      *outstring=flags[i];
      outstring++;
    };
    vektor>>=1;
  };
  *outstring=0;
};
