/* ************************************************************************
*   File: weather.c                                     Part of CircleMUD *
*  Usage: functions handling time and the weather                         *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */

#include "conf.h"
#include "sysdep.h"


#include "structs.h"
#include "utils.h"
#include "comm.h"
#include "handler.h"
#include "interpreter.h"
#include "db.h"

extern struct time_info_data time_info;
extern int control_weather;

void weather_and_time(int mode);
void another_hour(int mode);
void weather_change(void);


void weather_and_time(int mode)
{
  another_hour(mode);
  if (mode)
    weather_change();
}


void another_hour(int mode)
{
  void update_gargoyles(int time);

  time_info.hours++;

  if (mode) {
    switch (time_info.hours) {
    case 5:
      weather_info.sunlight = SUN_RISE;
      update_gargoyles(SUN_RISE);
      send_to_outdoor("&+cThe su&+yn ri&+Yses i&+yn th&+ce east.&+w\r\n");
      break;
    case 6:
      weather_info.sunlight = SUN_LIGHT;
      send_to_outdoor("&+yTh&+Ye &+yd&+Ya&+yy h&+Ya&+ys beg&+Yu&+yn.&+w\r\n");
      break;
    case 19:
      weather_info.sunlight = SUN_SET;
      send_to_outdoor("&+cThe sun s&+rlowly d&+yisapp&+rears in &+cthe west.&+w\r\n");
      break;
    case 20:
      weather_info.sunlight = SUN_DARK;
      update_gargoyles(SUN_DARK);
      send_to_outdoor("&+mT&+ch&+me n&+ci&+mght &+ch&+mas b&+ce&+mgun.&+w\r\n");
      break;
    default:
      break;
    }
  }
  if (time_info.hours > 23) {	/* Changed by HHS due to bug ??? */
    time_info.hours -= 24;
    time_info.day++;

    if (time_info.day > 34) {
      time_info.day = 0;
      time_info.month++;

      if (time_info.month > 16) {
	time_info.month = 0;
	time_info.year++;
      }
    }
  }
}


void weather_change(void)
{
  int diff, change;
  if (weather_info.humidity >= 50)
    diff = -1;
  else
    diff = 1;

  if (control_weather == 0)
    weather_info.change += (dice(1, 5) * diff + dice(1, 5) - dice(1, 5));
  else if (control_weather == -1)
    weather_info.change = (dice(1, 5) * -1 + dice(1, 5) - dice(1, 8));
  else if (control_weather == 1)
    weather_info.change = (dice(1, 5) + dice(1, 8) - dice(1, 5));

  weather_info.humidity += weather_info.change;

  weather_info.humidity = MAX(weather_info.humidity, 0);
  weather_info.humidity = MIN(weather_info.humidity, 100);

  change = 0;

  if ((time_info.month >= 1) && (time_info.month <= 5)) {
    switch (weather_info.sky) {
      case SKY_SUNNY:
        if (weather_info.humidity > 10)
          change = 1;
        break;
      case SKY_CLEAR:
        if (weather_info.humidity > 30)
          change = 4;
        else if (weather_info.humidity <= 10)
          change = 1;
        break;
      case SKY_PARTCLOUD:
        if (weather_info.humidity > 40)
          change = 6;
        else if (weather_info.humidity <= 30)
          change = 3;
        break;
      case SKY_CLOUDY:
        if (weather_info.humidity > 50)
          change = 8;
        else if (weather_info.humidity <= 40)
          change = 5;
        break;
      case SKY_SNOWING:
        if (weather_info.humidity > 75)
          change = 10;
        else if (weather_info.humidity <= 50)
          change = 7;
        break;
      case SKY_SNOWSTORM:
        if (weather_info.humidity > 90)
          change = 12;
        else if (weather_info.humidity <= 75)
          change = 9;
        break;
      case SKY_BLIZZARD:
        if (weather_info.humidity <= 90)
          change = 11;
        break;
      default:
        change = 0;
        weather_info.sky = SKY_CLEAR;
        break;
    }
  }
  if ((time_info.month >= 6) && (time_info.month <= 9)) {
    switch (weather_info.sky) {
      case SKY_SIZZLING:
        if (weather_info.humidity > 10)
          change = 2;
        break;
      case SKY_SUNNY:
        if (weather_info.humidity > 30)
          change = 4;
        else if (weather_info.humidity <= 10)
          change = 1;
        break;
      case SKY_CLEAR:
        if (weather_info.humidity > 40)
          change = 6;
        else if (weather_info.humidity <= 30)
          change = 3;
        break;
      case SKY_PARTCLOUD:
        if (weather_info.humidity > 50)
          change = 8;
        else if (weather_info.humidity <= 40)
          change = 5;
        break;
      case SKY_CLOUDY:
        if (weather_info.humidity > 55)
          change = 10;
        else if (weather_info.humidity <= 50)
          change = 7;
        break;
      case SKY_RAINING:
        if (weather_info.humidity > 75)
          change = 12;
        else if (weather_info.humidity <= 55)
          change = 9;
        break;
      case SKY_POURING:
        if (weather_info.humidity > 90)
          change = 14;
        else if (weather_info.humidity <= 75)
          change = 11;
        break;
      case SKY_THUNDERSTORM:
        if (weather_info.humidity <= 90)
          change = 13;
        break;
      default:
        change = 0;
        weather_info.sky = SKY_CLEAR;
        break;
    }
  }
  if ((time_info.month >= 10) && (time_info.month <= 14)) {
    switch (weather_info.sky) {
      case SKY_SIZZLING:
        if (weather_info.humidity > 25)
          change = 2;
        break;
      case SKY_SUNNY:
        if (weather_info.humidity > 60)
          change = 4;
        else if (weather_info.humidity <= 25)
          change = 1;
        break;
      case SKY_CLEAR:
        if (weather_info.humidity > 70)
          change = 6;
        else if (weather_info.humidity <= 60)
          change = 3;
        break;
      case SKY_PARTCLOUD:
        if (weather_info.humidity > 75)
          change = 8;
        else if (weather_info.humidity <= 70)
          change = 5;
        break;
      case SKY_CLOUDY:
        if (weather_info.humidity > 85)
          change = 10;
        else if (weather_info.humidity <= 75)
          change = 7;
        break;
      case SKY_RAINING:
        if (weather_info.humidity > 90)
          change = 12;
        else if (weather_info.humidity <= 85)
          change = 9;
        break;
      case SKY_POURING:
        if (weather_info.humidity > 95)
          change = 14;
        else if (weather_info.humidity <= 90)
          change = 11;
        break;
      case SKY_THUNDERSTORM:
        if (weather_info.humidity <= 95)
          change = 13;
        break;
      default:
        change = 0;
        weather_info.sky = SKY_CLEAR;
        break;
    }
  }
  if ((time_info.month >= 15) && (time_info.month <= 18)) {
    switch (weather_info.sky) {
      case SKY_SUNNY:
        if (weather_info.humidity > 15)
          change = 1;
        break;
      case SKY_CLEAR:
        if (weather_info.humidity > 40)
          change = 4;
        else if (weather_info.humidity <= 15)
          change = 1;
        break;
      case SKY_PARTCLOUD:
        if (weather_info.humidity > 55)
          change = 6;
        else if (weather_info.humidity <= 40)
          change = 3;
        break;
      case SKY_CLOUDY:
        if (weather_info.humidity > 75)
          change = 8;
        else if (weather_info.humidity <= 55)
          change = 5;
        break;
      case SKY_SNOWING:
        if (weather_info.humidity > 90)
          change = 10;
        else if (weather_info.humidity <= 75)
          change = 7;
        break;
      case SKY_SNOWSTORM:
        if (weather_info.humidity > 95)
          change = 12;
        else if (weather_info.humidity <= 90)
          change = 9;
        break;
      case SKY_BLIZZARD:
        if (weather_info.humidity <= 95)
          change = 11;
        break;
      default:
        change = 0;
        weather_info.sky = SKY_CLEAR;
        break;
    }
  }
  if ((time_info.month >= 6) && (time_info.month <=14)) {
    switch (change) {
    case 0:
      break;
    case 1:
      send_to_outdoor("The temperature starts to get significantly hotter.\r\n");
      weather_info.sky = SKY_SIZZLING;
      break;
    case 2:
      send_to_outdoor("The temperature gets cooler but is still hot out.\r\n");
      weather_info.sky = SKY_SUNNY;
      break;
    case 3:
      send_to_outdoor("It starts to get warmer out.\r\n");
      weather_info.sky = SKY_SUNNY;
      break;
    case 4:
      send_to_outdoor("It starts to get cooler, but the sky remains clear.\r\n");
      weather_info.sky = SKY_CLEAR;
      break;
    case 5:
      send_to_outdoor("The clouds blow off and you see the clear sky.\r\n");
      weather_info.sky = SKY_CLEAR;
      break;
    case 6:
      send_to_outdoor("Clouds starts to move in overhead.\r\n");
      weather_info.sky = SKY_PARTCLOUD;
      break;
    case 7:
      send_to_outdoor("The clouds slowly begin to dissipate.\r\n");
      weather_info.sky = SKY_PARTCLOUD;
      break;
    case 8:
      send_to_outdoor("The cloud cover overhead gets thicker.\r\n");
      weather_info.sky = SKY_CLOUDY;
      break;
    case 9:
      send_to_outdoor("The rain stops.\r\n");
      weather_info.sky = SKY_CLOUDY;
      break;
    case 10:
      send_to_outdoor("You feel the first raindrops start to land on your head.\r\n");
      weather_info.sky = SKY_RAINING;
      break;
    case 11:
      send_to_outdoor("The rain starts to thin out.\r\n");
      weather_info.sky = SKY_RAINING;
      break;
    case 12:
      send_to_outdoor("Ack!  It's starting to rain cats and dogs!\r\n");
      weather_info.sky = SKY_POURING;
      break;
    case 13:
      send_to_outdoor("The dull booms of thunder start to subside.\r\n");
      weather_info.sky = SKY_POURING;
      break;
    case 14:
      send_to_outdoor("You jump in surprise as you see a surge of lightning strike not too far away.\r\n");
      weather_info.sky = SKY_THUNDERSTORM;
      break;
    default:
      break;
    }
  } else {
    switch (change) {
    case 0:
      break;
    case 1:
      weather_info.sky = SKY_SUNNY;
      break;
    case 2:
      weather_info.sky = SKY_CLEAR;
      break;
    case 3:
      weather_info.sky = SKY_CLEAR;
      break;
    case 4:
      weather_info.sky = SKY_PARTCLOUD;
      break;
    case 5:
      weather_info.sky = SKY_PARTCLOUD;
      break;
    case 6:
      weather_info.sky = SKY_CLOUDY;
      break;
    case 7:
      weather_info.sky = SKY_CLOUDY;
      break;
    case 8:
      weather_info.sky = SKY_SNOWING;
      break;
    case 9:
      weather_info.sky = SKY_SNOWING;
      break;
    case 10:
      weather_info.sky = SKY_SNOWSTORM;
      break;
    case 11:
      weather_info.sky = SKY_SNOWSTORM;
      break;
    case 12:
      weather_info.sky = SKY_BLIZZARD;
      break;
    default:
      break;
    }
  }
}

